/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.teams.client.core;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ClientTeamDB {
    public static ClientTeamDB INSTANCE = new ClientTeamDB();
    private Set<String> teams = new HashSet<String>();
    private Set<String> onlineTeams = new HashSet<String>();

    private ClientTeamDB() {
    }

    public List<String> getTeams() {
        return this.teams.stream().toList();
    }

    public List<String> getOnlineTeams() {
        return this.onlineTeams.stream().toList();
    }

    public void addTeam(String team) {
        this.teams.add(team);
    }

    public void removeTeam(String team) {
        this.teams.remove(team);
        this.teamOffline(team);
    }

    public boolean containsTeam(String team) {
        return this.teams.contains(team);
    }

    public void teamOnline(String team) {
        this.onlineTeams.add(team);
    }

    public void teamOffline(String team) {
        this.onlineTeams.remove(team);
    }

    public boolean containsOnlineTeam(String team) {
        return this.onlineTeams.contains(team);
    }

    public void clear() {
        this.teams.clear();
        this.onlineTeams.clear();
    }
}

