/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.teams.client;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import com.t2pellet.teams.ScreenDuck;
import com.t2pellet.teams.TeamsHUD;
import com.t2pellet.teams.client.TeamsKeys;
import com.t2pellet.teams.client.core.ClientTeam;
import com.t2pellet.teams.client.core.ClientTeamDB;
import com.t2pellet.teams.client.ui.hud.CompassOverlay;
import com.t2pellet.teams.client.ui.hud.StatusOverlay;
import com.t2pellet.teams.client.ui.menu.TeamsLonelyScreen;
import com.t2pellet.teams.client.ui.menu.TeamsMainScreen;
import com.t2pellet.teams.client.ui.toast.ToastInviteSent;
import com.t2pellet.teams.client.ui.toast.ToastInvited;
import com.t2pellet.teams.client.ui.toast.ToastJoin;
import com.t2pellet.teams.client.ui.toast.ToastLeave;
import com.t2pellet.teams.client.ui.toast.ToastRequested;
import com.t2pellet.teams.mixin.InventoryScreenAccessor;
import com.t2pellet.teams.network.client.S2CTeamPlayerDataPacket;
import com.t2pellet.teams.network.client.S2CTeamUpdatePacket;
import java.util.UUID;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.ArrayUtils;

public class TeamsHUDClient {
    public static final StatusOverlay status = new StatusOverlay();
    public static final CompassOverlay compass = new CompassOverlay();
    public static final ResourceLocation TEAMS_BUTTON_TEXTURE = TeamsHUD.id("textures/gui/buttonsmall.png");

    public static void registerKeybinding(KeyMapping keyMapping) {
        Minecraft.m_91087_().f_91066_.f_92059_ = (KeyMapping[])ArrayUtils.add((Object[])Minecraft.m_91087_().f_91066_.f_92059_, (Object)keyMapping);
    }

    public static void registerKeybinds() {
        for (TeamsKeys.TeamsKey key : TeamsKeys.KEYS) {
            key.register();
        }
    }

    public static void clientDisconnect() {
        ClientTeam.INSTANCE.reset();
        ClientTeamDB.INSTANCE.clear();
    }

    public static void afterScreenInit(Minecraft minecraft, Screen screen, int scaledWidth, int scaledHeight) {
        if (screen instanceof InventoryScreen) {
            InventoryScreen inventoryScreen = (InventoryScreen)screen;
            if (minecraft.f_91072_ != null && !minecraft.f_91072_.m_105290_()) {
                InventoryScreenAccessor screenAccessor = (InventoryScreenAccessor)screen;
                ((ScreenDuck)inventoryScreen).$addButton((Button)new ImageButton(screenAccessor.getX() + screenAccessor.getBackgroundWidth() - 19, screenAccessor.getY() + 4, 15, 14, 0, 0, 13, TEAMS_BUTTON_TEXTURE, button -> {
                    if (ClientTeam.INSTANCE.isInTeam()) {
                        minecraft.m_91152_((Screen)new TeamsMainScreen(minecraft.f_91080_));
                    } else {
                        minecraft.m_91152_((Screen)new TeamsLonelyScreen(minecraft.f_91080_));
                    }
                }){

                    protected boolean m_93680_(double pMouseX, double pMouseY) {
                        return this.f_93623_ && this.f_93624_ && pMouseX >= (double)this.m_252754_() && pMouseY >= (double)this.m_252907_() && pMouseX < (double)(this.m_252754_() + this.f_93618_) && pMouseY < (double)(this.m_252907_() + this.f_93619_);
                    }
                });
            }
        }
    }

    public static void endClientTick() {
        for (TeamsKeys.TeamsKey key : TeamsKeys.KEYS) {
            if (!key.keyBinding.m_90859_()) continue;
            key.onPress.execute(Minecraft.m_91087_());
        }
    }

    public static void handleTeamUpdatePacket(String team, String player, S2CTeamUpdatePacket.Action action, boolean isLocal) {
        switch (action) {
            case JOINED: {
                Minecraft.m_91087_().m_91300_().m_94922_((Toast)new ToastJoin(team, player, isLocal));
                break;
            }
            case LEFT: {
                Minecraft.m_91087_().m_91300_().m_94922_((Toast)new ToastLeave(team, player, isLocal));
            }
        }
    }

    public static void handleTeamRequestedPacket(String name, UUID id) {
        Minecraft.m_91087_().m_91300_().m_94922_((Toast)new ToastRequested(ClientTeam.INSTANCE.getName(), name, id));
    }

    public static void handleTeamInviteSentPacket(String team, String player) {
        Minecraft.m_91087_().m_91300_().m_94922_((Toast)new ToastInviteSent(team, player));
    }

    public static void handleTeamPlayerDataPacket(CompoundTag tag) {
        UUID uuid = tag.m_128342_("playerUuid");
        switch (S2CTeamPlayerDataPacket.Type.valueOf(tag.m_128461_("actionType"))) {
            case ADD: {
                if (ClientTeam.INSTANCE.hasPlayer(uuid)) {
                    return;
                }
                String name = tag.m_128461_("playerName");
                float health = tag.m_128457_("playerHealth");
                int hunger = tag.m_128451_("playerHunger");
                String skinVal = tag.m_128461_("playerSkin");
                String skinSig = tag.m_128461_("playerSkinSignature");
                if (!skinVal.isEmpty()) {
                    GameProfile dummy = new GameProfile(UUID.randomUUID(), "");
                    dummy.getProperties().put((Object)"textures", (Object)new Property("textures", skinVal, skinSig));
                    Minecraft.m_91087_().m_91109_().m_118817_(dummy, (type, id, texture) -> {
                        if (type == MinecraftProfileTexture.Type.SKIN) {
                            ClientTeam.INSTANCE.addPlayer(uuid, name, id, health, hunger);
                        }
                    }, false);
                    break;
                }
                ClientTeam.INSTANCE.addPlayer(uuid, name, DefaultPlayerSkin.m_118627_((UUID)uuid), health, hunger);
                break;
            }
            case UPDATE: {
                float health = tag.m_128457_("playerHealth");
                int hunger = tag.m_128451_("playerHunger");
                ClientTeam.INSTANCE.updatePlayer(uuid, health, hunger);
                break;
            }
            case REMOVE: {
                ClientTeam.INSTANCE.removePlayer(uuid);
            }
        }
    }

    public static void handleTeamInvitedPacket(String team) {
        Minecraft.m_91087_().m_91300_().m_94922_((Toast)new ToastInvited(team));
    }
}

