/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.teams;

import com.mojang.brigadier.CommandDispatcher;
import com.t2pellet.teams.TeamsHUD;
import com.t2pellet.teams.client.TeamsHUDClientForge;
import com.t2pellet.teams.command.TeamCommand;
import com.t2pellet.teams.config.TomlConfig;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.commons.lang3.tuple.Pair;

@Mod(value="teams")
public class TeamsHUDForge {
    public static final TomlConfig.Client CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final TomlConfig.Server SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;

    public TeamsHUDForge() {
        TeamsHUD.LOGGER.info("Teams forge mod init!");
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_SPEC);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommand);
        MinecraftForge.EVENT_BUS.addListener(this::login);
        MinecraftForge.EVENT_BUS.addListener(this::logout);
        MinecraftForge.EVENT_BUS.addListener(this::playerClone);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarted);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStopped);
        MinecraftForge.EVENT_BUS.addListener(this::onAdvancement);
        if (FMLEnvironment.dist.isClient()) {
            TeamsHUDClientForge.init(bus);
        }
        TeamsHUD.init();
    }

    private void onAdvancement(AdvancementEvent.AdvancementEarnEvent event) {
        TeamsHUD.onAdvancement((ServerPlayer)event.getEntity(), event.getAdvancement());
    }

    private void onServerStarted(ServerStartedEvent event) {
        TeamsHUD.onServerStarted(event.getServer());
    }

    private void onServerStopped(ServerStoppedEvent event) {
        TeamsHUD.onServerStopped(event.getServer());
    }

    private void login(PlayerEvent.PlayerLoggedInEvent event) {
        TeamsHUD.playerConnect((ServerPlayer)event.getEntity());
    }

    private void logout(PlayerEvent.PlayerLoggedOutEvent event) {
        TeamsHUD.playerDisconnect((ServerPlayer)event.getEntity());
    }

    private void playerClone(PlayerEvent.Clone event) {
        TeamsHUD.playerClone((ServerPlayer)event.getOriginal(), (ServerPlayer)event.getEntity(), !event.isWasDeath());
    }

    private void registerCommand(RegisterCommandsEvent event) {
        TeamCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(TomlConfig.Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (TomlConfig.Client)specPair.getLeft();
        Pair specPair2 = new ForgeConfigSpec.Builder().configure(TomlConfig.Server::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair2.getRight();
        SERVER = (TomlConfig.Server)specPair2.getLeft();
    }
}

