/*
 * Decompiled with CFR 0.152.
 */
package fuzs.strawstatues.world.entity.decoration;

import com.google.common.collect.ImmutableSortedMap;
import com.mojang.authlib.GameProfile;
import fuzs.puzzlesapi.api.statues.v1.helper.ArmorStandInteractHelper;
import fuzs.puzzlesapi.api.statues.v1.world.entity.decoration.ArmorStandDataProvider;
import fuzs.puzzlesapi.api.statues.v1.world.inventory.data.ArmorStandPose;
import fuzs.puzzlesapi.api.statues.v1.world.inventory.data.ArmorStandScreenType;
import fuzs.puzzlesapi.api.statues.v1.world.inventory.data.ArmorStandStyleOption;
import fuzs.puzzlesapi.api.statues.v1.world.inventory.data.ArmorStandStyleOptions;
import fuzs.puzzlesapi.api.statues.v1.world.inventory.data.PosePartMutator;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.strawstatues.init.ModRegistry;
import fuzs.strawstatues.mixin.accessor.ArmorStandAccessor;
import java.util.NavigableMap;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Rotations;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class StrawStatue
extends ArmorStand
implements ArmorStandDataProvider {
    public static final Rotations DEFAULT_ENTITY_ROTATIONS = new Rotations(180.0f, 0.0f, 180.0f);
    public static final float DEFAULT_ENTITY_SCALE = 3.0f;
    public static final float MIN_MODEL_SCALE = 1.0f;
    public static final float MAX_MODEL_SCALE = 8.0f;
    public static final String OWNER_KEY = "Owner";
    public static final String SLIM_ARMS_KEY = "SlimArms";
    public static final String CROUCHING_KEY = "Crouching";
    public static final String MODEL_PARTS_KEY = "ModelParts";
    public static final String ENTITY_SCALE_KEY = "EntityScale";
    public static final String ENTITY_ROTATIONS_KEY = "EntityRotations";
    public static final EntityDataAccessor<Optional<GameProfile>> DATA_OWNER = SynchedEntityData.m_135353_(StrawStatue.class, ModRegistry.GAME_PROFILE_ENTITY_DATA_SERIALIZER);
    public static final EntityDataAccessor<Boolean> DATA_SLIM_ARMS = SynchedEntityData.m_135353_(StrawStatue.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DATA_CROUCHING = SynchedEntityData.m_135353_(StrawStatue.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Byte> DATA_PLAYER_MODE_CUSTOMISATION = SynchedEntityData.m_135353_(StrawStatue.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static final EntityDataAccessor<Float> DATA_ENTITY_SCALE = SynchedEntityData.m_135353_(StrawStatue.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Rotations> DATA_ENTITY_ROTATIONS = SynchedEntityData.m_135353_(StrawStatue.class, (EntityDataSerializer)EntityDataSerializers.f_135037_);
    private final NavigableMap<Float, EntityDimensions> defaultDimensions;
    private final NavigableMap<Float, EntityDimensions> babyDimensions;
    public float entityScaleO = 3.0f;
    public Rotations entityRotationsO = DEFAULT_ENTITY_ROTATIONS;

    public StrawStatue(EntityType<? extends StrawStatue> entityType, Level level) {
        super(entityType, level);
        ArmorStandStyleOption.setArmorStandData((ArmorStand)this, (boolean)true, (int)4);
        ArmorStandStyleOption.setArmorStandData((ArmorStand)this, (boolean)true, (int)8);
        this.defaultDimensions = StrawStatue.buildStatueDimensions(entityType, false);
        this.babyDimensions = StrawStatue.buildStatueDimensions(entityType, true);
    }

    public StrawStatue(Level level, double x, double y, double z) {
        this((EntityType<? extends StrawStatue>)((EntityType)ModRegistry.STRAW_STATUE_ENTITY_TYPE.get()), level);
        this.m_6034_(x, y, z);
    }

    private static NavigableMap<Float, EntityDimensions> buildStatueDimensions(EntityType<?> entityType, boolean forBaby) {
        float defaultScale = 3.0f * (forBaby ? 2.0f : 1.0f);
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (float scale = 1.0f; scale <= 8.0f; scale += 0.5f) {
            builder.put((Object)Float.valueOf(scale - 0.25f), (Object)entityType.m_20680_().m_20388_(scale / defaultScale));
        }
        return builder.build();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_OWNER, Optional.empty());
        this.f_19804_.m_135372_(DATA_SLIM_ARMS, (Object)false);
        this.f_19804_.m_135372_(DATA_CROUCHING, (Object)false);
        this.f_19804_.m_135372_(DATA_PLAYER_MODE_CUSTOMISATION, (Object)StrawStatue.getAllModelParts());
        this.f_19804_.m_135372_(DATA_ENTITY_SCALE, (Object)Float.valueOf(3.0f));
        this.f_19804_.m_135372_(DATA_ENTITY_ROTATIONS, (Object)DEFAULT_ENTITY_ROTATIONS);
    }

    private static byte getAllModelParts() {
        byte value = 0;
        for (PlayerModelPart modelPart : PlayerModelPart.values()) {
            value = (byte)(value | modelPart.m_36445_());
        }
        return value;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_(SLIM_ARMS_KEY, this.slimArms());
        tag.m_128379_(CROUCHING_KEY, this.m_6047_());
        tag.m_128344_(MODEL_PARTS_KEY, ((Byte)this.f_19804_.m_135370_(DATA_PLAYER_MODE_CUSTOMISATION)).byteValue());
        ((Optional)this.f_19804_.m_135370_(DATA_OWNER)).ifPresent(owner -> {
            CompoundTag gameProfileTag = new CompoundTag();
            NbtUtils.m_129230_((CompoundTag)gameProfileTag, (GameProfile)owner);
            tag.m_128365_(OWNER_KEY, (Tag)gameProfileTag);
        });
        tag.m_128350_(ENTITY_SCALE_KEY, this.getEntityScale());
        Rotations entityRotations = this.getEntityRotations();
        if (!DEFAULT_ENTITY_ROTATIONS.equals((Object)entityRotations)) {
            tag.m_128365_(ENTITY_ROTATIONS_KEY, (Tag)entityRotations.m_123155_());
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_(SLIM_ARMS_KEY, 1)) {
            this.setSlimArms(tag.m_128471_(SLIM_ARMS_KEY));
        }
        if (tag.m_128425_(CROUCHING_KEY, 1)) {
            this.setCrouching(tag.m_128471_(CROUCHING_KEY));
        }
        if (tag.m_128425_(MODEL_PARTS_KEY, 1)) {
            this.f_19804_.m_135381_(DATA_PLAYER_MODE_CUSTOMISATION, (Object)tag.m_128445_(MODEL_PARTS_KEY));
        }
        if (tag.m_128425_(OWNER_KEY, 10)) {
            this.verifyAndSetOwner(NbtUtils.m_129228_((CompoundTag)tag.m_128469_(OWNER_KEY)));
        }
        if (tag.m_128425_(ENTITY_SCALE_KEY, 5)) {
            this.setEntityScale(tag.m_128457_(ENTITY_SCALE_KEY));
            this.entityScaleO = this.getEntityScale();
        }
        if (tag.m_128425_(ENTITY_ROTATIONS_KEY, 9)) {
            Rotations entityRotations = new Rotations(tag.m_128437_(ENTITY_ROTATIONS_KEY, 5));
            this.setEntityRotations(entityRotations.m_123156_(), entityRotations.m_123158_());
            this.entityRotationsO = this.getEntityRotations();
        }
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return dimensions.f_20378_ * 0.85f;
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (this.m_31677_() || this.babyDimensions == null || this.defaultDimensions == null) {
            return super.m_6972_(pose);
        }
        NavigableMap<Float, EntityDimensions> dimensions = this.m_6162_() ? this.babyDimensions : this.defaultDimensions;
        return dimensions.floorEntry(Float.valueOf(this.getEntityScale())).getValue();
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (DATA_ENTITY_SCALE.equals(key)) {
            this.m_6210_();
        }
        super.m_7350_(key);
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        ItemStack itemInHand = player.m_21120_(hand);
        InteractionResult result = super.m_7111_(player, vec, hand);
        if (!player.m_9236_().f_46443_ && !player.m_5833_() && result == InteractionResult.SUCCESS && itemInHand.m_150930_(Items.f_42680_) && itemInHand.m_41782_()) {
            GameProfile gameProfile = null;
            CompoundTag compoundTag = itemInHand.m_41783_();
            if (compoundTag.m_128425_("SkullOwner", 10)) {
                gameProfile = NbtUtils.m_129228_((CompoundTag)compoundTag.m_128469_("SkullOwner"));
            } else if (compoundTag.m_128425_("SkullOwner", 8) && !StringUtils.isBlank((CharSequence)compoundTag.m_128461_("SkullOwner"))) {
                gameProfile = new GameProfile(null, compoundTag.m_128461_("SkullOwner"));
            }
            if (gameProfile != null) {
                this.verifyAndSetOwner(gameProfile);
            }
        }
        return result;
    }

    public static EventResultHolder<InteractionResult> onUseEntityAt(Player player, Level level, InteractionHand interactionHand, Entity target, Vec3 hitVector) {
        if (!player.m_5833_() && target.m_6095_() == ModRegistry.STRAW_STATUE_ENTITY_TYPE.get()) {
            return ArmorStandInteractHelper.tryOpenArmorStatueMenu((Player)player, (Level)level, (InteractionHand)interactionHand, (ArmorStand)((ArmorStand)target), (MenuType)((MenuType)ModRegistry.STRAW_STATUE_MENU_TYPE.get()), null);
        }
        return EventResultHolder.pass();
    }

    public boolean m_31671_() {
        return true;
    }

    public boolean m_31674_() {
        return true;
    }

    public Optional<GameProfile> getOwner() {
        return (Optional)this.f_19804_.m_135370_(DATA_OWNER);
    }

    public void verifyAndSetOwner(@Nullable GameProfile gameProfile) {
        if (!(gameProfile == null || gameProfile.isComplete() && gameProfile.getName().length() <= 16)) {
            if (gameProfile.getName().length() > 16) {
                if (gameProfile.getId() != null) {
                    gameProfile = new GameProfile(gameProfile.getId(), "");
                } else {
                    this.setOwner(null);
                    return;
                }
            }
            SkullBlockEntity.m_155738_((GameProfile)gameProfile, this::setOwner);
        } else {
            this.setOwner(gameProfile);
        }
    }

    private void setOwner(@Nullable GameProfile gameProfile) {
        this.f_19804_.m_135381_(DATA_OWNER, Optional.ofNullable(gameProfile));
    }

    public boolean slimArms() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SLIM_ARMS);
    }

    public void setSlimArms(boolean slimArms) {
        this.f_19804_.m_135381_(DATA_SLIM_ARMS, (Object)slimArms);
    }

    public boolean isModelPartShown(PlayerModelPart part) {
        return ((Byte)this.m_20088_().m_135370_(DATA_PLAYER_MODE_CUSTOMISATION) & part.m_36445_()) == part.m_36445_();
    }

    public void setModelPart(PlayerModelPart modelPart, boolean enable) {
        this.f_19804_.m_135381_(DATA_PLAYER_MODE_CUSTOMISATION, (Object)ArmorStandStyleOption.setBit((byte)((Byte)this.f_19804_.m_135370_(DATA_PLAYER_MODE_CUSTOMISATION)), (int)modelPart.m_36445_(), (boolean)enable));
    }

    public float getEntityScale() {
        return ((Float)this.f_19804_.m_135370_(DATA_ENTITY_SCALE)).floatValue();
    }

    public float getEntityXRotation() {
        return this.getEntityRotations().m_123156_();
    }

    public Rotations getEntityRotations() {
        return (Rotations)this.f_19804_.m_135370_(DATA_ENTITY_ROTATIONS);
    }

    public float getEntityZRotation() {
        return this.getEntityRotations().m_123158_();
    }

    public void setEntityXRotation(float rotationX) {
        this.setEntityRotations(rotationX, this.getEntityZRotation());
    }

    public void setEntityZRotation(float rotationZ) {
        this.setEntityRotations(this.getEntityXRotation(), rotationZ);
    }

    public void setEntityRotations(float rotationX, float rotationZ) {
        rotationX = Mth.m_14036_((float)rotationX, (float)0.0f, (float)360.0f);
        rotationZ = Mth.m_14036_((float)rotationZ, (float)0.0f, (float)360.0f);
        this.f_19804_.m_135381_(DATA_ENTITY_ROTATIONS, (Object)new Rotations(rotationX, 0.0f, rotationZ));
    }

    public void setEntityScale(float modelScale) {
        modelScale = StrawStatue.clampModelScale(modelScale);
        this.f_19804_.m_135381_(DATA_ENTITY_SCALE, (Object)Float.valueOf(modelScale));
    }

    public static float clampModelScale(double modelScale) {
        modelScale = (double)((int)(modelScale * 10.0)) / 10.0;
        return Mth.m_14036_((float)((float)modelScale), (float)1.0f, (float)8.0f);
    }

    public void m_6075_() {
        super.m_6075_();
        this.entityScaleO = this.getEntityScale();
        this.entityRotationsO = this.getEntityRotations();
    }

    public void setCrouching(boolean crouching) {
        this.f_19804_.m_135381_(DATA_CROUCHING, (Object)crouching);
    }

    public boolean m_6047_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_CROUCHING);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.m_9236_().f_46443_ && !this.m_213877_()) {
            if (source.m_269533_(DamageTypeTags.f_268738_)) {
                this.m_6074_();
                return false;
            }
            if (!(this.m_6673_(source) || this.m_20145_() || this.m_31677_())) {
                if (source.m_269533_(DamageTypeTags.f_268415_)) {
                    ((ArmorStandAccessor)((Object)this)).strawstatues$callBrokenByAnything(source);
                    this.m_6074_();
                    return false;
                }
                if (source.m_269533_(DamageTypeTags.f_268727_)) {
                    if (this.m_6060_()) {
                        ((ArmorStandAccessor)((Object)this)).strawstatues$callCauseDamage(source, 0.15f);
                    } else {
                        this.m_20254_(5);
                    }
                    return false;
                }
                if (source.m_269533_(DamageTypeTags.f_268711_) && this.m_21223_() > 0.5f) {
                    ((ArmorStandAccessor)((Object)this)).strawstatues$callCauseDamage(source, 4.0f);
                    return false;
                }
                boolean bl = source.m_7640_() instanceof AbstractArrow;
                boolean bl2 = bl && ((AbstractArrow)source.m_7640_()).m_36796_() > 0;
                boolean bl3 = "player".equals(source.m_19385_());
                if (!bl3 && !bl) {
                    return false;
                }
                if (source.m_7639_() instanceof Player && !((Player)source.m_7639_()).m_150110_().f_35938_) {
                    return false;
                }
                if (source.m_19390_()) {
                    this.m_31566_();
                    this.m_31565_();
                    this.m_6074_();
                    return bl2;
                }
                long gameTime = this.m_9236_().m_46467_();
                if (gameTime - this.f_31528_ > 5L && !bl) {
                    this.m_9236_().m_7605_((Entity)this, (byte)32);
                    this.m_146852_(GameEvent.f_223706_, source.m_7639_());
                    this.f_31528_ = gameTime;
                    this.f_19802_ = 20;
                    this.f_20916_ = this.f_20917_ = 10;
                } else {
                    this.m_31646_(source);
                    this.m_31565_();
                    this.m_6074_();
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void m_31646_(DamageSource source) {
        Block.m_49840_((Level)this.m_9236_(), (BlockPos)this.m_20183_(), (ItemStack)new ItemStack((ItemLike)ModRegistry.STRAW_STATUE_ITEM.get()));
        ((ArmorStandAccessor)((Object)this)).strawstatues$callBrokenByAnything(source);
    }

    private void m_31566_() {
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11988_, this.m_5720_(), 1.0f, 1.0f);
    }

    private void m_31565_() {
        if (this.m_9236_() instanceof ServerLevel) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50335_.m_49966_()), this.m_20185_(), this.m_20227_(0.6666666666666666), this.m_20189_(), 10, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.05);
        }
    }

    public void m_7822_(byte id) {
        if (id == 32) {
            this.f_31528_ = this.m_9236_().m_46467_();
        }
        super.m_7822_(id);
    }

    public LivingEntity.Fallsounds m_196493_() {
        return new LivingEntity.Fallsounds(SoundEvents.f_11989_, SoundEvents.f_11989_);
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_11990_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11988_;
    }

    @Nullable
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)ModRegistry.STRAW_STATUE_ITEM.get());
    }

    public ArmorStandScreenType[] getScreenTypes() {
        return new ArmorStandScreenType[]{ArmorStandScreenType.ROTATIONS, ArmorStandScreenType.POSES, ArmorStandScreenType.STYLE, ModRegistry.MODEL_PARTS_SCREEN_TYPE, ModRegistry.STRAW_STATUE_POSITION_SCREEN_TYPE, ModRegistry.STRAW_STATUE_SCALE_SCREEN_TYPE, ArmorStandScreenType.EQUIPMENT};
    }

    public PosePartMutator[] getPosePartMutators() {
        return new PosePartMutator[]{PosePartMutator.HEAD, ModRegistry.CAPE_POSE_PART_MUTATOR, PosePartMutator.RIGHT_ARM, PosePartMutator.LEFT_ARM, PosePartMutator.RIGHT_LEG, PosePartMutator.LEFT_LEG};
    }

    public ArmorStandPose getRandomPose(boolean clampRotations) {
        return ArmorStandPose.randomize((PosePartMutator[])this.getPosePartMutators(), (boolean)clampRotations);
    }

    public ArmorStandStyleOption[] getStyleOptions() {
        return new ArmorStandStyleOption[]{ArmorStandStyleOptions.SHOW_NAME, ArmorStandStyleOptions.SMALL, ModRegistry.SLIM_ARMS_STYLE_OPTION, ModRegistry.CROUCHING_STYLE_OPTION, ArmorStandStyleOptions.NO_GRAVITY, ArmorStandStyleOptions.SEALED};
    }
}

