/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.registry;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.railwayteam.railways.multiloader.ClientCommands;
import com.railwayteam.railways.registry.commands.ClearCapCacheCommand;
import com.railwayteam.railways.registry.commands.ClearCasingCacheCommand;
import com.railwayteam.railways.registry.commands.MixinAuditCommand;
import com.railwayteam.railways.registry.commands.ReloadDevCapesCommand;
import com.railwayteam.railways.util.Utils;
import java.util.Collections;
import net.minecraft.commands.SharedSuggestionProvider;

public class CRCommandsClient {
    private static final boolean FORCE_MIXIN_AUDIT_COMMAND = Boolean.getBoolean("railways.force_mixin_audit_command");

    public static void register(CommandDispatcher<SharedSuggestionProvider> dispatcher) {
        LiteralArgumentBuilder railwaysCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommands.literal("railways_client").requires(cs -> cs.m_6761_(0))).then(ClearCasingCacheCommand.register())).then(ClearCapCacheCommand.register())).then(ReloadDevCapesCommand.register());
        if (Utils.isDevEnv() || FORCE_MIXIN_AUDIT_COMMAND) {
            railwaysCommand.then(MixinAuditCommand.register());
        }
        LiteralCommandNode railwaysRoot = dispatcher.register(railwaysCommand);
        CommandNode snrc = dispatcher.findNode(Collections.singleton("snrc"));
        if (snrc != null) {
            return;
        }
        dispatcher.getRoot().addChild(CRCommandsClient.buildRedirect("snrc", railwaysRoot));
    }

    public static <T> LiteralCommandNode<T> buildRedirect(String alias, LiteralCommandNode<T> destination) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)alias).requires(destination.getRequirement())).forward(destination.getRedirect(), destination.getRedirectModifier(), destination.isFork())).executes(destination.getCommand());
        for (CommandNode child : destination.getChildren()) {
            builder.then(child);
        }
        return builder.build();
    }
}

