/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_tracks.gen_template;

import com.railwayteam.railways.content.custom_tracks.gen_template.TextureKey;
import com.simibubi.create.content.trains.track.TrackShape;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Unmodifiable;

public enum TextureMaps {
    STANDARD((shape, textureMap) -> {
        switch (shape) {
            case TE: 
            case TN: 
            case TS: 
            case TW: {
                textureMap.put("1", TextureKey.PORTAL_TRACK);
                textureMap.put("2", TextureKey.PORTAL_TRACK_MIP);
                textureMap.put("3", TextureKey.STANDARD_TRACK);
                break;
            }
            case AE: 
            case AW: 
            case AN: 
            case AS: {
                textureMap.put("0", TextureKey.STANDARD_TRACK);
                textureMap.put("1", TextureKey.STANDARD_TRACK_MIP);
                break;
            }
            case CR_O: 
            case XO: 
            case ZO: {
                textureMap.put("1", TextureKey.STANDARD_TRACK);
                textureMap.put("2", TextureKey.STANDARD_TRACK_MIP);
                textureMap.put("3", TextureKey.STANDARD_TRACK_CROSSING);
                break;
            }
            default: {
                textureMap.put("0", TextureKey.STANDARD_TRACK);
                textureMap.put("1", TextureKey.STANDARD_TRACK_MIP);
                textureMap.put("2", TextureKey.STANDARD_TRACK_CROSSING);
            }
        }
    }),
    NARROW((shape, textureMap) -> {
        switch (shape) {
            case TE: 
            case TN: 
            case TS: 
            case TW: {
                textureMap.put("1", TextureKey.PORTAL_TRACK);
                textureMap.put("2", TextureKey.PORTAL_TRACK_MIP);
                textureMap.put("3", TextureKey.STANDARD_TRACK);
                break;
            }
            case AE: 
            case AW: 
            case AN: 
            case AS: {
                textureMap.put("0", TextureKey.STANDARD_TRACK);
                textureMap.put("1", TextureKey.STANDARD_TRACK_MIP);
                break;
            }
            case CR_O: 
            case XO: 
            case ZO: 
            case ND: 
            case PD: 
            case CR_D: 
            case CR_NDX: 
            case CR_NDZ: 
            case CR_PDX: 
            case CR_PDZ: {
                textureMap.put("1", TextureKey.STANDARD_TRACK);
                textureMap.put("2", TextureKey.STANDARD_TRACK_MIP);
                textureMap.put("3", TextureKey.STANDARD_TRACK_CROSSING);
                break;
            }
            default: {
                textureMap.put("0", TextureKey.STANDARD_TRACK);
                textureMap.put("1", TextureKey.STANDARD_TRACK_MIP);
                textureMap.put("2", TextureKey.STANDARD_TRACK_CROSSING);
            }
        }
    }),
    WIDE(NARROW);

    public final @Unmodifiable Map<TrackShape, @Unmodifiable Map<String, TextureKey>> map;

    private TextureMaps(TextureMaps other) {
        this.map = other.map;
    }

    private TextureMaps(BiConsumer<TrackShape, Map<String, TextureKey>> populator) {
        HashMap map = new HashMap();
        for (TrackShape shape : TrackShape.values()) {
            HashMap textureMap = new HashMap();
            populator.accept(shape, textureMap);
            map.put(shape, Map.copyOf(textureMap));
        }
        this.map = Map.copyOf(map);
    }
}

