/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.mixin.ui;

import dev.imb11.sounds.config.SoundsConfig;
import dev.imb11.sounds.config.UISoundsConfig;
import dev.imb11.sounds.dynamic.DynamicSoundHelper;
import dev.imb11.sounds.sound.context.ItemStackSoundContext;
import dev.imb11.sounds.util.MixinStatics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractContainerMenu.class})
public abstract class ItemTransferSoundEffects {
    @Shadow
    public abstract ItemStack m_142621_();

    @Shadow
    public abstract Slot m_38853_(int var1);

    @Inject(method={"internalOnSlotClick"}, at={@At(value="HEAD")})
    void $item_transfer_sound_effects(int slotIndex, int button, ClickType actionType, Player player, CallbackInfo ci) {
        if (!(player instanceof LocalPlayer)) {
            return;
        }
        if (slotIndex < 0) {
            return;
        }
        ItemStack itemStack = this.m_38853_(slotIndex).m_7993_();
        if (actionType == ClickType.PICKUP) {
            if (itemStack.m_41619_()) {
                ItemStack cursorStack = this.m_142621_();
                SoundsConfig.get(UISoundsConfig.class).itemClickSoundEffect.playDynamicSound(cursorStack, ItemStackSoundContext.of(DynamicSoundHelper.BlockSoundType.PLACE));
            } else {
                SoundsConfig.get(UISoundsConfig.class).itemClickSoundEffect.playDynamicSound(itemStack, ItemStackSoundContext.of(DynamicSoundHelper.BlockSoundType.PLACE));
            }
        } else if (actionType == ClickType.PICKUP_ALL) {
            ItemStack cursorStack = this.m_142621_();
            SoundsConfig.get(UISoundsConfig.class).itemClickSoundEffect.playDynamicSound(cursorStack, ItemStackSoundContext.of(DynamicSoundHelper.BlockSoundType.PLACE));
        } else if (actionType == ClickType.SWAP) {
            if (itemStack.m_41619_()) {
                ItemStack buttonStack = player.m_150109_().m_8020_(button);
                SoundsConfig.get(UISoundsConfig.class).itemClickSoundEffect.playDynamicSound(buttonStack, ItemStackSoundContext.of(DynamicSoundHelper.BlockSoundType.PLACE));
            } else {
                SoundsConfig.get(UISoundsConfig.class).itemClickSoundEffect.playDynamicSound(itemStack, ItemStackSoundContext.of(DynamicSoundHelper.BlockSoundType.PLACE));
            }
        } else if (actionType == ClickType.QUICK_MOVE) {
            if (itemStack.m_41619_()) {
                ItemStack cursorStack = this.m_142621_();
                SoundsConfig.get(UISoundsConfig.class).itemClickSoundEffect.playDynamicSound(cursorStack, ItemStackSoundContext.of(DynamicSoundHelper.BlockSoundType.PLACE));
            } else {
                SoundsConfig.get(UISoundsConfig.class).itemClickSoundEffect.playDynamicSound(itemStack, ItemStackSoundContext.of(DynamicSoundHelper.BlockSoundType.PLACE));
            }
        } else if (actionType == ClickType.CLONE) {
            SoundsConfig.get(UISoundsConfig.class).itemCopySoundEffect.playDynamicSound(itemStack, ItemStackSoundContext.of(DynamicSoundHelper.BlockSoundType.PLACE));
        }
        MixinStatics.previousAction = actionType;
    }
}

