/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.mixin.ui;

import dev.imb11.sounds.config.SoundsConfig;
import dev.imb11.sounds.config.UISoundsConfig;
import dev.imb11.sounds.dynamic.DynamicSoundHelper;
import dev.imb11.sounds.mixin.ui.PlayerEntityMixin;
import dev.imb11.sounds.sound.context.ItemStackSoundContext;
import dev.imb11.sounds.util.MixinStatics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LocalPlayer.class})
public abstract class ItemDropSoundEffect
extends PlayerEntityMixin {
    @Shadow
    @Final
    protected Minecraft f_108619_;
    @Unique
    private static long dropSoundCooldownTime = 0L;

    @Shadow
    public abstract void m_5496_(SoundEvent var1, float var2, float var3);

    protected ItemDropSoundEffect(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Unique
    private void playSound(ItemStack stack) {
        if (MixinStatics.hasOpenedInventorioScreen) {
            dropSoundCooldownTime = System.currentTimeMillis() + (long)SoundsConfig.get(UISoundsConfig.class).itemSoundCooldown;
            MixinStatics.hasOpenedInventorioScreen = false;
            return;
        }
        if (dropSoundCooldownTime > System.currentTimeMillis()) {
            return;
        }
        dropSoundCooldownTime = System.currentTimeMillis() + (long)SoundsConfig.get(UISoundsConfig.class).itemSoundCooldown;
        if (MixinStatics.previousAction == ClickType.QUICK_MOVE) {
            MixinStatics.previousAction = null;
            return;
        }
        SoundsConfig.get(UISoundsConfig.class).itemDropSoundEffect.playDynamicSound(stack, ItemStackSoundContext.of(DynamicSoundHelper.BlockSoundType.FALL));
    }

    @Inject(method={"dropSelectedItem(Z)Z"}, at={@At(value="HEAD")})
    private void $drop_selected_item_sound_effect(boolean entireStack, CallbackInfoReturnable<Boolean> cir) {
        ItemStack stack = this.m_21205_();
        this.playSound(stack);
    }

    @Override
    protected void $drop_item_sound_effect(ItemStack stack, boolean throwRandomly, boolean retainOwnership, CallbackInfoReturnable<ItemEntity> cir) {
        if (!this.m_9236_().f_46443_) {
            return;
        }
        this.playSound(stack);
    }
}

