/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.client;

import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import snownee.snow.client.RenderAPI;
import snownee.snow.client.SnowClient;

public class FabricRendererRenderAPI
implements RenderAPI {
    private final RenderContext context;
    private final BlockState selfState;
    private final BakedModel unwrapped;

    public FabricRendererRenderAPI(RenderContext context, BlockState selfState, BakedModel unwrapped) {
        this.context = context;
        this.selfState = selfState;
        this.unwrapped = unwrapped;
    }

    @Override
    public boolean translateYAndRender(BlockAndTintGetter world, BlockState state, BlockPos pos, @Nullable RenderType layer, Supplier<RandomSource> randomSupplier, boolean cullSides, BakedModel model, double yOffset) {
        RandomSource random = randomSupplier.get();
        if (layer != null && !model.getRenderTypes(state, random, this.context.getModelData()).contains(layer)) {
            return false;
        }
        Vec3 offset = yOffset == 0.0 ? state.m_60824_((BlockGetter)world, pos) : state.m_60824_((BlockGetter)world, pos).m_82520_(0.0, yOffset, 0.0);
        BlockColors blockColors = Minecraft.m_91087_().m_91298_();
        this.context.pushTransform(quad -> {
            if (state.m_60713_(Blocks.f_50125_) && quad.cullFace() == Direction.DOWN && yOffset != 0.0) {
                return false;
            }
            int color = -1;
            if (quad.colorIndex() != -1) {
                color = blockColors.m_92577_(state, world, pos, quad.colorIndex());
                color |= 0xFF000000;
            }
            if (offset != Vec3.f_82478_ || color != -1) {
                for (int i = 0; i < 4; ++i) {
                    quad.pos(i, quad.x(i) + (float)offset.f_82479_, quad.y(i) + (float)offset.f_82480_, quad.z(i) + (float)offset.f_82481_);
                    quad.color(i, color);
                }
            }
            return true;
        });
        if (state == this.selfState && model != SnowClient.cachedOverlayModel) {
            model = this.unwrapped;
        }
        ((FabricBakedModel)model).emitBlockQuads(world, state, pos, randomSupplier, this.context);
        this.context.popTransform();
        return true;
    }
}

