/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.sekclib.network.s2c;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class ClientVelocityPacket {
    private final int xa;
    private final int ya;
    private final int za;

    public ClientVelocityPacket(int x, int y, int z) {
        this.xa = x;
        this.ya = y;
        this.za = z;
    }

    public ClientVelocityPacket(Vec3 velocity) {
        double maxVelocity = 3.9;
        double d1 = Mth.m_14008_((double)velocity.f_82479_, (double)(-maxVelocity), (double)maxVelocity);
        double d2 = Mth.m_14008_((double)velocity.f_82480_, (double)(-maxVelocity), (double)maxVelocity);
        double d3 = Mth.m_14008_((double)velocity.f_82481_, (double)(-maxVelocity), (double)maxVelocity);
        this.xa = (int)(d1 * 8000.0);
        this.ya = (int)(d2 * 8000.0);
        this.za = (int)(d3 * 8000.0);
    }

    public static void encode(ClientVelocityPacket msg, FriendlyByteBuf outBuffer) {
        outBuffer.writeShort(msg.xa);
        outBuffer.writeShort(msg.ya);
        outBuffer.writeShort(msg.za);
    }

    public static ClientVelocityPacket decode(FriendlyByteBuf inBuffer) {
        short x = inBuffer.readShort();
        short y = inBuffer.readShort();
        short z = inBuffer.readShort();
        return new ClientVelocityPacket(x, y, z);
    }

    public static class Handler {
        public static void handle(ClientVelocityPacket msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player != null) {
                    if (msg.ya > 0) {
                        player.m_6853_(false);
                    }
                    player.m_6001_((double)msg.xa / 8000.0, (double)msg.ya / 8000.0, (double)msg.za / 8000.0);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

