/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.sekclib.capabilitysync.capabilitysync.broadcaster;

import com.sekwah.sekclib.SekCLib;
import com.sekwah.sekclib.capabilitysync.CapabilityEntry;
import com.sekwah.sekclib.capabilitysync.capability.SyncDataCapabilityHandler;
import com.sekwah.sekclib.capabilitysync.capabilitysync.broadcaster.CapabilityInfo;
import com.sekwah.sekclib.capabilitysync.capabilitysync.tracker.CapabilityTracker;
import com.sekwah.sekclib.capabilitysync.capabilitysync.tracker.SyncTracker;
import com.sekwah.sekclib.network.SekCPacketHandler;
import com.sekwah.sekclib.network.s2c.ClientCapabilitySyncPacket;
import com.sekwah.sekclib.registries.SekCLibRegistries;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;

public class CapabilityBroadcaster {
    public static void checkCapData(LivingEntity player) {
        player.getCapability(SyncDataCapabilityHandler.SYNC_DATA).ifPresent(syncData -> {
            List<CapabilityTracker> capTrackers = syncData.getCapabilityTrackers();
            for (CapabilityTracker capTracker : capTrackers) {
                Capability<?> cap = capTracker.getCapability();
                player.getCapability(cap).ifPresent(data -> {
                    for (SyncTracker syncTracker : capTracker.getSyncTrackers()) {
                        try {
                            syncTracker.tick(data);
                        }
                        catch (Throwable e) {
                            SekCLib.LOGGER.error("There was a problem updating a sync tracker", e);
                        }
                    }
                });
            }
        });
        CapabilityBroadcaster.broadcastCapChanges(player, false);
    }

    private static List<CapabilityInfo> collectEntries(LivingEntity entity, boolean returnAll) {
        ArrayList<CapabilityInfo> capInfoList = new ArrayList<CapabilityInfo>();
        entity.getCapability(SyncDataCapabilityHandler.SYNC_DATA).ifPresent(syncData -> {
            List<CapabilityTracker> capTrackers = syncData.getCapabilityTrackers();
            for (CapabilityTracker capTracker : capTrackers) {
                CapabilityEntry capEntry = capTracker.getCapabilityEntry();
                CapabilityInfo capInfo = new CapabilityInfo(SekCLibRegistries.CAPABILITY_REGISTRY.getID((Object)capEntry), capEntry);
                for (SyncTracker syncTracker : capTracker.getSyncTrackers()) {
                    if (!returnAll && !syncTracker.isMarkedForSend()) continue;
                    if (syncTracker.getSyncEntry().isSyncGlobally()) {
                        capInfo.changedEntries.add(syncTracker);
                        continue;
                    }
                    capInfo.changedPrivateEntries.add(syncTracker);
                }
                if (capInfo.changedEntries.isEmpty() && capInfo.changedPrivateEntries.isEmpty()) continue;
                capInfoList.add(capInfo);
            }
        });
        return capInfoList;
    }

    public static void broadcastCapability(Player tracked, Player reciever) {
    }

    public static void broadcastCapChanges(LivingEntity entity, boolean sendAll) {
        List<CapabilityInfo> dataToSend = CapabilityBroadcaster.collectEntries(entity, sendAll);
        if (dataToSend.isEmpty()) {
            return;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            ClientCapabilitySyncPacket selfData = new ClientCapabilitySyncPacket(entity, dataToSend, true);
            if (!selfData.capabilityData.isEmpty()) {
                SekCPacketHandler.sendToPlayer(selfData, serverPlayer);
            }
        }
        ClientCapabilitySyncPacket forOthers = new ClientCapabilitySyncPacket(entity, dataToSend, false);
        if (!forOthers.capabilityData.isEmpty()) {
            SekCPacketHandler.sendToTracking(forOthers, entity);
        }
    }

    public static void broadcastCapToPlayer(LivingEntity entity, ServerPlayer player) {
        List<CapabilityInfo> dataToSend = CapabilityBroadcaster.collectEntries(entity, true);
        if (dataToSend.isEmpty()) {
            return;
        }
        ClientCapabilitySyncPacket forOthers = new ClientCapabilitySyncPacket(entity, dataToSend, false);
        if (!forOthers.capabilityData.isEmpty()) {
            SekCPacketHandler.sendToPlayer(forOthers, player);
        }
    }
}

