/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadsignsmod.client.gui;

import de.sarocesch.sarosroadsignsmod.client.gui.components.ModernButton;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ColorPickerScreen
extends Screen {
    private final Screen parent;
    private final ColorCallback callback;
    private int selectedColor;
    private final List<ColorTile> tiles = new ArrayList<ColorTile>();

    public ColorPickerScreen(Screen parent, int initialArgb, ColorCallback cb) {
        super((Component)Component.m_237113_((String)"Pick Color"));
        this.parent = parent;
        this.callback = cb;
        this.selectedColor = initialArgb;
    }

    private static int lighten(int col, float amt) {
        int r = col >> 16 & 0xFF;
        int g = col >> 8 & 0xFF;
        int b = col & 0xFF;
        r = (int)((float)r + (float)(255 - r) * amt);
        g = (int)((float)g + (float)(255 - g) * amt);
        b = (int)((float)b + (float)(255 - b) * amt);
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    protected void m_7856_() {
        this.tiles.clear();
        int[] palette = new int[]{-16777216, -1, -5636096, -16733696, -16777046, -22016, -5635926, -16733526, -11184811, -5592406, -43691, -11141291, -11184641, -171, -43521, -11141121};
        int cols = 8;
        int tile = 18;
        int pad = 6;
        int gridW = cols * tile + (cols - 1) * pad;
        int startX = this.f_96543_ / 2 - gridW / 2;
        int startY = this.f_96544_ / 2 - 40;
        for (int i = 0; i < palette.length; ++i) {
            int row = i / cols;
            int col = i % cols;
            int x = startX + col * (tile + pad);
            int y = startY + row * (tile + pad);
            int color = palette[i];
            ColorTile t = new ColorTile(x, y, tile, color, b -> {
                this.selectedColor = color;
            });
            this.m_142416_((GuiEventListener)t);
            this.tiles.add(t);
        }
        int centerX = this.f_96543_ / 2;
        this.m_142416_((GuiEventListener)new ModernButton(centerX - 100, startY + 2 * (tile + pad) + 16, 90, 20, (Component)Component.m_237113_((String)"Set Color"), btn -> {
            if (this.callback != null) {
                this.callback.onColorPicked(this.selectedColor);
            }
            Minecraft.m_91087_().m_91152_(this.parent);
        }, -13796106, -12677889, -1));
        this.m_142416_((GuiEventListener)new ModernButton(centerX + 10, startY + 2 * (tile + pad) + 16, 90, 20, (Component)Component.m_237113_((String)"Cancel"), btn -> Minecraft.m_91087_().m_91152_(this.parent), -9671572, -7829368, -1));
    }

    public void m_88315_(GuiGraphics gg, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(gg);
        super.m_88315_(gg, mouseX, mouseY, partialTicks);
        int centerX = this.f_96543_ / 2;
        gg.m_280653_(this.f_96547_, this.f_96539_, centerX, this.f_96544_ / 2 - 72, -1);
        int preview = this.selectedColor;
        int previewX = centerX - 40;
        int previewY = this.f_96544_ / 2 - 96;
        gg.m_280509_(previewX, previewY, previewX + 80, previewY + 20, preview);
        gg.m_280509_(previewX - 1, previewY - 1, previewX + 81, previewY + 21, -16777216);
        gg.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)String.format("#%06X", preview & 0xFFFFFF)), centerX, previewY - 12, -1);
        for (ColorTile t : this.tiles) {
            if (t.color != this.selectedColor) continue;
            gg.m_280509_(t.m_252754_() - 2, t.m_252907_() - 2, t.m_252754_() + t.m_5711_() + 2, t.m_252907_() + t.m_93694_() + 2, -1);
            gg.m_280509_(t.m_252754_() - 1, t.m_252907_() - 1, t.m_252754_() + t.m_5711_() + 1, t.m_252907_() + t.m_93694_() + 1, -16777216);
            break;
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public static interface ColorCallback {
        public void onColorPicked(int var1);
    }

    private static class ColorTile
    extends ModernButton {
        final int color;

        ColorTile(int x, int y, int size, int color, Button.OnPress press) {
            super(x, y, size, size, (Component)Component.m_237113_((String)""), press, color, ColorPickerScreen.lighten(color, 0.15f), -1);
            this.color = color;
        }
    }
}

