/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadblocksmod.procedures;

import de.sarocesch.sarosroadblocksmod.block.AsphaltBlock;
import de.sarocesch.sarosroadblocksmod.block.SidewalkBlock;
import de.sarocesch.sarosroadblocksmod.init.SarosRoadBlocksModModBlocks;
import de.sarocesch.sarosroadblocksmod.item.HammerItem;
import de.sarocesch.sarosroadblocksmod.util.RoadTextureManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class StufenProcedure {
    private static final Map<UUID, TargetVariant> playerTargetVariants = new HashMap<UUID, TargetVariant>();
    private static final Map<UUID, Long> playerHighlightTimers = new HashMap<UUID, Long>();

    public static void execute(Level world, double x, double y, double z, Player player) {
        BlockPos pos = new BlockPos((int)x, (int)y, (int)z);
        BlockState state = world.m_8055_(pos);
        UUID playerId = player.m_20148_();
        if (playerTargetVariants.containsKey(playerId)) {
            TargetVariant targetVariant = playerTargetVariants.get(playerId);
            StufenProcedure.applyTargetVariant(world, pos, state, player, targetVariant);
        } else {
            Block block = state.m_60734_();
            if (block instanceof AsphaltBlock) {
                AsphaltBlock asphaltBlock = (AsphaltBlock)block;
                StufenProcedure.handleAsphalt(world, pos, state, player);
            } else {
                block = state.m_60734_();
                if (block instanceof SidewalkBlock) {
                    SidewalkBlock sidewalkBlock = (SidewalkBlock)block;
                    StufenProcedure.handleSidewalk(world, pos, state, player);
                }
            }
        }
    }

    public static void handleHeightSetting(Level world, double x, double y, double z, Player player) {
        UUID playerId = player.m_20148_();
        BlockPos pos = new BlockPos((int)x, (int)y, (int)z);
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() instanceof AsphaltBlock) {
            AsphaltBlock.Variant currentVariant = (AsphaltBlock.Variant)((Object)state.m_61143_(AsphaltBlock.VARIANT));
            int variantOrdinal = currentVariant.ordinal();
            playerTargetVariants.put(playerId, new TargetVariant(variantOrdinal, true));
            playerHighlightTimers.put(playerId, world.m_46467_());
            StufenProcedure.updateHammerNBT(player, variantOrdinal, true);
            player.m_5661_((Component)Component.m_237113_((String)("\u00a7aTarget height set to: " + variantOrdinal)), true);
            world.m_5594_(null, pos, SoundEvents.f_11871_, SoundSource.BLOCKS, 1.0f, 1.0f);
            StufenProcedure.spawnHighlightParticles(world, pos);
        } else if (state.m_60734_() instanceof SidewalkBlock) {
            SidewalkBlock.Variant currentVariant = (SidewalkBlock.Variant)((Object)state.m_61143_(SidewalkBlock.VARIANT));
            int variantOrdinal = currentVariant.ordinal();
            playerTargetVariants.put(playerId, new TargetVariant(variantOrdinal, false));
            playerHighlightTimers.put(playerId, world.m_46467_());
            StufenProcedure.updateHammerNBT(player, variantOrdinal, false);
            player.m_5661_((Component)Component.m_237113_((String)("\u00a7aTarget height set to: " + variantOrdinal)), true);
            world.m_5594_(null, pos, SoundEvents.f_11871_, SoundSource.BLOCKS, 1.0f, 1.0f);
            StufenProcedure.spawnHighlightParticles(world, pos);
        } else {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a7cPlease click on an asphalt or sidewalk block to set target height"), true);
        }
    }

    public static void resetHeightSetting(Player player) {
        UUID playerId = player.m_20148_();
        if (playerTargetVariants.containsKey(playerId)) {
            playerTargetVariants.remove(playerId);
            playerHighlightTimers.remove(playerId);
            StufenProcedure.clearHammerNBT(player);
            player.m_5661_((Component)Component.m_237113_((String)"\u00a7aHeight level reset to normal mode"), true);
            player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.5f, 1.0f);
        } else {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a77No height level was set"), true);
        }
    }

    private static void applyTargetVariant(Level world, BlockPos pos, BlockState state, Player player, TargetVariant targetVariant) {
        if (state.m_60734_() instanceof AsphaltBlock) {
            StufenProcedure.applyAsphaltVariant(world, pos, state, player, targetVariant.variantOrdinal);
        } else if (state.m_60734_() instanceof SidewalkBlock) {
            StufenProcedure.applySidewalkVariant(world, pos, state, player, targetVariant.variantOrdinal);
        } else {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a7cPlease click on an asphalt or sidewalk block"), true);
        }
    }

    private static void applyAsphaltVariant(Level world, BlockPos pos, BlockState state, Player player, int targetVariantOrdinal) {
        Direction currentFacing = (Direction)state.m_61143_((Property)AsphaltBlock.FACING);
        int safeVariantOrdinal = Math.max(0, Math.min(AsphaltBlock.Variant.values().length - 1, targetVariantOrdinal));
        AsphaltBlock.Variant targetVariant = AsphaltBlock.Variant.values()[safeVariantOrdinal];
        StufenProcedure.updateAsphaltBlock(world, pos, state, targetVariant, currentFacing);
        world.m_5594_(null, pos, SoundEvents.f_11664_, SoundSource.BLOCKS, 1.0f, 1.0f);
        player.m_5661_((Component)Component.m_237113_((String)("\u00a77Block set to height: " + safeVariantOrdinal)), true);
    }

    private static void applySidewalkVariant(Level world, BlockPos pos, BlockState state, Player player, int targetVariantOrdinal) {
        Direction currentFacing = (Direction)state.m_61143_((Property)SidewalkBlock.FACING);
        int safeVariantOrdinal = Math.max(0, Math.min(SidewalkBlock.Variant.values().length - 1, targetVariantOrdinal));
        SidewalkBlock.Variant targetVariant = SidewalkBlock.Variant.values()[safeVariantOrdinal];
        StufenProcedure.updateSidewalkBlock(world, pos, state, targetVariant, currentFacing);
        world.m_5594_(null, pos, SoundEvents.f_11664_, SoundSource.BLOCKS, 1.0f, 1.0f);
        player.m_5661_((Component)Component.m_237113_((String)("\u00a77Block set to height: " + safeVariantOrdinal)), true);
    }

    public static String getHammerStatusForPlayer(ItemStack stack, Level world) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("HammerTargetHeight")) {
            int targetHeight = tag.m_128451_("HammerTargetHeight");
            boolean isAsphalt = tag.m_128471_("HammerIsAsphalt");
            String blockType = isAsphalt ? "Asphalt" : "Sidewalk";
            return "Target height: " + targetHeight + " (" + blockType + ")";
        }
        return "Normal mode (right-click to cycle)";
    }

    private static void updateHammerNBT(Player player, int variantOrdinal, boolean isAsphalt) {
        ItemStack offHand;
        ItemStack mainHand = player.m_21205_();
        if (mainHand.m_41720_() instanceof HammerItem) {
            CompoundTag tag = mainHand.m_41784_();
            tag.m_128405_("HammerTargetHeight", variantOrdinal);
            tag.m_128379_("HammerIsAsphalt", isAsphalt);
        }
        if ((offHand = player.m_21206_()).m_41720_() instanceof HammerItem) {
            CompoundTag tag = offHand.m_41784_();
            tag.m_128405_("HammerTargetHeight", variantOrdinal);
            tag.m_128379_("HammerIsAsphalt", isAsphalt);
        }
    }

    private static void clearHammerNBT(Player player) {
        CompoundTag tag;
        ItemStack offHand;
        CompoundTag tag2;
        ItemStack mainHand = player.m_21205_();
        if (mainHand.m_41720_() instanceof HammerItem && (tag2 = mainHand.m_41783_()) != null) {
            tag2.m_128473_("HammerTargetHeight");
            tag2.m_128473_("HammerIsAsphalt");
        }
        if ((offHand = player.m_21206_()).m_41720_() instanceof HammerItem && (tag = offHand.m_41783_()) != null) {
            tag.m_128473_("HammerTargetHeight");
            tag.m_128473_("HammerIsAsphalt");
        }
    }

    private static void handleAsphalt(Level world, BlockPos pos, BlockState state, Player player) {
        AsphaltBlock.Variant currentVariant = (AsphaltBlock.Variant)((Object)state.m_61143_(AsphaltBlock.VARIANT));
        Direction currentFacing = (Direction)state.m_61143_((Property)AsphaltBlock.FACING);
        if (currentVariant == AsphaltBlock.Variant.FIFTEEN) {
            BlockPos belowPos = pos.m_7495_();
            BlockState belowState = world.m_8055_(belowPos);
            if (belowState.m_60734_() instanceof AsphaltBlock) {
                StufenProcedure.updateAsphaltBlock(world, belowPos, belowState, AsphaltBlock.Variant.DEFAULT, currentFacing);
                StufenProcedure.removeAndGiveItem(world, pos, player, new ItemStack((ItemLike)SarosRoadBlocksModModBlocks.ASPHALT.get()));
            }
        } else {
            AsphaltBlock.Variant nextVariant = StufenProcedure.getNextAsphaltVariant(currentVariant);
            StufenProcedure.updateAsphaltBlock(world, pos, state, nextVariant, currentFacing);
            player.m_5661_((Component)Component.m_237113_((String)("\u00a77Block changed to height: " + nextVariant.ordinal())), true);
        }
    }

    private static void handleSidewalk(Level world, BlockPos pos, BlockState state, Player player) {
        SidewalkBlock.Variant currentVariant = (SidewalkBlock.Variant)((Object)state.m_61143_(SidewalkBlock.VARIANT));
        Direction currentFacing = (Direction)state.m_61143_((Property)SidewalkBlock.FACING);
        if (currentVariant == SidewalkBlock.Variant.FIFTEEN) {
            BlockPos belowPos = pos.m_7495_();
            BlockState belowState = world.m_8055_(belowPos);
            if (belowState.m_60734_() instanceof SidewalkBlock) {
                StufenProcedure.updateSidewalkBlock(world, belowPos, belowState, SidewalkBlock.Variant.DEFAULT, currentFacing);
                StufenProcedure.removeAndGiveItem(world, pos, player, new ItemStack((ItemLike)SarosRoadBlocksModModBlocks.SIDEWALK.get()));
            }
        } else {
            SidewalkBlock.Variant nextVariant = StufenProcedure.getNextSidewalkVariant(currentVariant);
            StufenProcedure.updateSidewalkBlock(world, pos, state, nextVariant, currentFacing);
            player.m_5661_((Component)Component.m_237113_((String)("\u00a77Block changed to height: " + nextVariant.ordinal())), true);
        }
    }

    private static AsphaltBlock.Variant getNextAsphaltVariant(AsphaltBlock.Variant currentVariant) {
        return switch (currentVariant) {
            case AsphaltBlock.Variant.DEFAULT -> AsphaltBlock.Variant.ONE;
            case AsphaltBlock.Variant.ONE -> AsphaltBlock.Variant.TWO;
            case AsphaltBlock.Variant.TWO -> AsphaltBlock.Variant.THREE;
            case AsphaltBlock.Variant.THREE -> AsphaltBlock.Variant.FOUR;
            case AsphaltBlock.Variant.FOUR -> AsphaltBlock.Variant.FIVE;
            case AsphaltBlock.Variant.FIVE -> AsphaltBlock.Variant.SIX;
            case AsphaltBlock.Variant.SIX -> AsphaltBlock.Variant.SEVEN;
            case AsphaltBlock.Variant.SEVEN -> AsphaltBlock.Variant.EIGHT;
            case AsphaltBlock.Variant.EIGHT -> AsphaltBlock.Variant.NINE;
            case AsphaltBlock.Variant.NINE -> AsphaltBlock.Variant.TEN;
            case AsphaltBlock.Variant.TEN -> AsphaltBlock.Variant.ELEVEN;
            case AsphaltBlock.Variant.ELEVEN -> AsphaltBlock.Variant.TWELVE;
            case AsphaltBlock.Variant.TWELVE -> AsphaltBlock.Variant.THIRTEEN;
            case AsphaltBlock.Variant.THIRTEEN -> AsphaltBlock.Variant.FOURTEEN;
            case AsphaltBlock.Variant.FOURTEEN -> AsphaltBlock.Variant.FIFTEEN;
            default -> AsphaltBlock.Variant.FIFTEEN;
        };
    }

    private static SidewalkBlock.Variant getNextSidewalkVariant(SidewalkBlock.Variant currentVariant) {
        return switch (currentVariant) {
            case SidewalkBlock.Variant.DEFAULT -> SidewalkBlock.Variant.ONE;
            case SidewalkBlock.Variant.ONE -> SidewalkBlock.Variant.TWO;
            case SidewalkBlock.Variant.TWO -> SidewalkBlock.Variant.THREE;
            case SidewalkBlock.Variant.THREE -> SidewalkBlock.Variant.FOUR;
            case SidewalkBlock.Variant.FOUR -> SidewalkBlock.Variant.FIVE;
            case SidewalkBlock.Variant.FIVE -> SidewalkBlock.Variant.SIX;
            case SidewalkBlock.Variant.SIX -> SidewalkBlock.Variant.SEVEN;
            case SidewalkBlock.Variant.SEVEN -> SidewalkBlock.Variant.EIGHT;
            case SidewalkBlock.Variant.EIGHT -> SidewalkBlock.Variant.NINE;
            case SidewalkBlock.Variant.NINE -> SidewalkBlock.Variant.TEN;
            case SidewalkBlock.Variant.TEN -> SidewalkBlock.Variant.ELEVEN;
            case SidewalkBlock.Variant.ELEVEN -> SidewalkBlock.Variant.TWELVE;
            case SidewalkBlock.Variant.TWELVE -> SidewalkBlock.Variant.THIRTEEN;
            case SidewalkBlock.Variant.THIRTEEN -> SidewalkBlock.Variant.FOURTEEN;
            case SidewalkBlock.Variant.FOURTEEN -> SidewalkBlock.Variant.FIFTEEN;
            default -> SidewalkBlock.Variant.FIFTEEN;
        };
    }

    private static void updateAsphaltBlock(Level world, BlockPos pos, BlockState state, AsphaltBlock.Variant nextVariant, Direction facing) {
        String currentTexture = RoadTextureManager.getTextureForBlock(world, pos);
        BlockState newState = (BlockState)((BlockState)state.m_61124_(AsphaltBlock.VARIANT, (Comparable)((Object)nextVariant))).m_61124_((Property)AsphaltBlock.FACING, (Comparable)facing);
        world.m_7731_(pos, newState, 3);
        if (currentTexture != null && !currentTexture.isEmpty()) {
            RoadTextureManager.setTextureForBlock(world, pos, currentTexture);
        }
        world.m_5594_(null, pos, SoundEvents.f_11664_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private static void updateSidewalkBlock(Level world, BlockPos pos, BlockState state, SidewalkBlock.Variant nextVariant, Direction facing) {
        BlockState newState = (BlockState)((BlockState)state.m_61124_(SidewalkBlock.VARIANT, (Comparable)((Object)nextVariant))).m_61124_((Property)SidewalkBlock.FACING, (Comparable)facing);
        world.m_7731_(pos, newState, 3);
        world.m_5594_(null, pos, SoundEvents.f_11664_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private static void removeAndGiveItem(Level world, BlockPos pos, Player player, ItemStack itemStack) {
        world.m_7471_(pos, false);
        if (!player.m_7500_()) {
            player.m_36356_(itemStack);
        }
        world.m_5594_(null, pos, SoundEvents.f_11664_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private static void spawnHighlightParticles(Level world, BlockPos pos) {
        for (int i = 0; i < 8; ++i) {
            double offsetX = world.f_46441_.m_188500_() * 1.8 - 0.9;
            double offsetY = world.f_46441_.m_188500_() * 1.8 + 0.1;
            double offsetZ = world.f_46441_.m_188500_() * 1.8 - 0.9;
            world.m_7106_((ParticleOptions)ParticleTypes.f_123810_, (double)pos.m_123341_() + 0.5 + offsetX, (double)pos.m_123342_() + 0.5 + offsetY, (double)pos.m_123343_() + 0.5 + offsetZ, 0.0, 0.0, 0.0);
        }
    }

    private static class TargetVariant {
        public final int variantOrdinal;
        public final boolean isAsphalt;

        public TargetVariant(int variantOrdinal, boolean isAsphalt) {
            this.variantOrdinal = variantOrdinal;
            this.isAsphalt = isAsphalt;
        }
    }
}

