/*
 * Decompiled with CFR 0.152.
 */
package com.leo.sanguine_networks.compat.jei;

import com.leo.sanguine_networks.init.ModBlocks;
import com.leo.sanguine_networks.recipe.ModelRecipe;
import dev.shadowsoffire.hostilenetworks.Hostile;
import dev.shadowsoffire.hostilenetworks.data.DataModel;
import dev.shadowsoffire.hostilenetworks.data.DataModelRegistry;
import dev.shadowsoffire.hostilenetworks.data.ModelTier;
import dev.shadowsoffire.hostilenetworks.item.DataModelItem;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class VirtualSacrificer
implements IRecipeCategory<ModelRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("sanguine_networks", "virtual_sacrificer/recipe");
    public static final ResourceLocation TEXTURE = new ResourceLocation("sanguine_networks", "textures/gui/virtual_sacrificer_jei.png");
    public static final RecipeType<ModelRecipe> RECIPE_TYPE = new RecipeType(UID, ModelRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private ModelTier currentTier = ModelTier.FAULTY;
    private int changeCD = 0;

    public VirtualSacrificer(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 116, 54);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((Block)ModBlocks.VIRTUAL_SACRIFICER.get()).m_5456_().m_7968_());
    }

    public RecipeType<ModelRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"sanguine_networks.container.virtual_sacrificer");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ModelRecipe recipe, IFocusGroup iFocusGroup) {
        DataModelItem dataModelItem = (DataModelItem)Hostile.Items.DATA_MODEL.get();
        ItemStack modelStack = new ItemStack((ItemLike)dataModelItem);
        EntityType value = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(recipe.getEntity());
        DataModel model = DataModelRegistry.INSTANCE.getForEntity(value);
        DataModelItem.setStoredModel((ItemStack)modelStack, (DataModel)model);
        builder.addSlot(RecipeIngredientRole.INPUT, 61, 1).addItemStack(modelStack);
    }

    public void draw(ModelRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Font font = Minecraft.m_91087_().f_91062_;
        MutableComponent energy = Component.m_237110_((String)"jei.sanguine_networks.energy", (Object[])new Object[]{recipe.getEnergy()});
        guiGraphics.m_280430_(font, (Component)energy, 2, 44, -65536);
        ++this.changeCD;
        if (this.changeCD >= 120) {
            this.changeCD = 0;
            this.currentTier = !this.currentTier.next().equals((Object)this.currentTier) ? this.currentTier.next() : ModelTier.FAULTY;
        }
        Component tier = this.currentTier.getComponent();
        MutableComponent blood = Component.m_237110_((String)"jei.sanguine_networks.blood", (Object[])new Object[]{recipe.getBlood()[this.currentTier.ordinal()]});
        guiGraphics.m_280430_(font, (Component)blood, 2, 26, -65536);
        guiGraphics.m_280430_(font, tier, 2, 7, this.currentTier.color());
    }
}

