/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.recipestages.recipes;

import com.blamejared.recipestages.RecipeStages;
import com.blamejared.recipestages.recipes.IStagedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.crafting.IShapedRecipe;

public class RecipeStage
implements IStagedRecipe {
    private final ResourceLocation id;
    private final String stage;
    private final CraftingRecipe recipe;
    private final boolean shapeless;
    private int width = 0;
    private int height = 0;

    public RecipeStage(ResourceLocation id, String stage, CraftingRecipe recipe, boolean shapeless) {
        this.id = id;
        this.stage = stage;
        this.recipe = recipe;
        this.shapeless = shapeless;
        if (recipe instanceof IShapedRecipe) {
            this.width = ((IShapedRecipe)recipe).getRecipeWidth();
            this.height = ((IShapedRecipe)recipe).getRecipeHeight();
        }
    }

    @Override
    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return RecipeStages.STAGE_SERIALIZER;
    }

    @Override
    public CraftingRecipe getRecipe() {
        return this.recipe;
    }

    @Override
    public String getStage() {
        return this.stage;
    }

    public String toString() {
        return "RecipeStage{id=" + this.id + ", stage='" + this.stage + "', recipe=" + this.recipe + ", shapeless=" + this.shapeless + ", width=" + this.width + ", height=" + this.height + "}";
    }

    public boolean isShapeless() {
        return this.shapeless;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

