/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.recipestages.handlers.actions.base;

import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.recipestages.handlers.actions.base.ActionStageBase;
import com.blamejared.recipestages.recipes.IStagedRecipe;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.CraftingRecipe;

public class ActionSetStage
extends ActionStageBase {
    private final Predicate<CraftingRecipe> predicate;
    private Function<ActionStageBase, String> describeFunction;

    public ActionSetStage(IRecipeManager<CraftingRecipe> manager, String stage, Predicate<CraftingRecipe> predicate) {
        super(manager, stage);
        this.predicate = predicate;
        this.describeFunction = action -> "Setting the stage of '%s' recipes that match a custom predicate".formatted(BuiltInRegistries.f_256990_.m_7981_((Object)this.getManager().getRecipeType()));
    }

    public ActionSetStage(IRecipeManager<CraftingRecipe> manager, String stage, Predicate<CraftingRecipe> predicate, Function<ActionStageBase, String> describeFunction) {
        super(manager, stage);
        this.predicate = predicate;
        this.describeFunction = describeFunction;
    }

    public void apply() {
        ArrayList<Map.Entry<ResourceLocation, CraftingRecipe>> toChange = new ArrayList<Map.Entry<ResourceLocation, CraftingRecipe>>();
        for (Map.Entry entry2 : this.getManager().getRecipes().entrySet()) {
            CraftingRecipe recipe = (CraftingRecipe)entry2.getValue();
            if (recipe instanceof IStagedRecipe) {
                IStagedRecipe staged = (IStagedRecipe)recipe;
                recipe = staged.getRecipe();
            }
            if (!this.predicate.test(recipe)) continue;
            toChange.add(entry2);
        }
        toChange.forEach(entry -> this.getManager().getRecipeList().remove((ResourceLocation)entry.getKey()));
        this.stageRecipes(toChange);
    }

    public String describe() {
        return this.describeFunction.apply(this);
    }
}

