/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.recipestages.handlers.actions;

import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.recipestages.handlers.actions.base.ActionClearBase;
import com.blamejared.recipestages.recipes.IStagedRecipe;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.CraftingRecipe;
import org.apache.logging.log4j.Logger;

public class ActionClearStageByName
extends ActionClearBase {
    private final ResourceLocation name;

    public ActionClearStageByName(IRecipeManager<CraftingRecipe> manager, ResourceLocation name) {
        super(manager);
        this.name = name;
    }

    public void apply() {
        ArrayList<Map.Entry<ResourceLocation, CraftingRecipe>> toChange = new ArrayList<Map.Entry<ResourceLocation, CraftingRecipe>>();
        for (Map.Entry entry2 : this.getManager().getRecipes().entrySet()) {
            IStagedRecipe stagedRecipe;
            if (this.name.equals(entry2.getKey())) {
                toChange.add(entry2);
                continue;
            }
            Object v = entry2.getValue();
            if (!(v instanceof IStagedRecipe) || !this.name.equals((Object)(stagedRecipe = (IStagedRecipe)v).getRecipe().m_6423_())) continue;
            toChange.add(entry2);
        }
        toChange.forEach(entry -> this.getManager().getRecipeList().remove((ResourceLocation)entry.getKey()));
        this.clearRecipes(toChange);
    }

    public String describe() {
        return "Clearing the stage of  \"" + BuiltInRegistries.f_256990_.m_7981_((Object)this.getManager().getRecipeType()) + "\" recipes with name: " + this.name + "\"";
    }

    public boolean validate(Logger logger) {
        boolean containsKey;
        boolean bl = containsKey = this.getManager().getRecipes().containsKey(this.name) || this.getManager().getRecipes().containsKey(new ResourceLocation("recipestages", this.name.toString().replaceAll(":", "_")));
        if (!containsKey) {
            logger.warn("No recipe with type: \"" + BuiltInRegistries.f_256990_.m_7981_((Object)this.getManager().getRecipeType()) + "\" and name: \"" + this.name + "\"");
        }
        return containsKey;
    }
}

