/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.reskin.core.client;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HDDownloadingTexture
extends SimpleTexture {
    private static final Logger LOGGER = LogManager.getLogger();
    private final File cacheFile;
    private final String imageUrl;
    private int imageWidth;
    private int imageHeight;
    private boolean isTransparent;
    private final boolean legacySkin = true;
    private final Runnable processTask;
    private CompletableFuture<?> future;
    private boolean textureUploaded;

    public HDDownloadingTexture(File cacheFileIn, String imageUrlIn, ResourceLocation textureResourceLocation, boolean isTransparent, Runnable processTaskIn) {
        super(textureResourceLocation);
        this.cacheFile = cacheFileIn;
        this.imageUrl = imageUrlIn;
        this.isTransparent = isTransparent;
        this.processTask = processTaskIn;
    }

    private void setImage(NativeImage nativeImageIn) {
        if (this.processTask != null) {
            this.processTask.run();
        }
        Minecraft.m_91087_().execute(() -> {
            this.textureUploaded = true;
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(() -> this.upload(nativeImageIn));
            } else {
                this.upload(nativeImageIn);
            }
        });
    }

    private void upload(NativeImage imageIn) {
        TextureUtil.prepareImage((int)this.m_117963_(), (int)imageIn.m_84982_(), (int)imageIn.m_85084_());
        imageIn.m_85040_(0, 0, 0, true);
    }

    public void m_6704_(ResourceManager manager) throws IOException {
        Minecraft.m_91087_().execute(() -> {
            if (!this.textureUploaded) {
                try {
                    super.m_6704_(manager);
                }
                catch (IOException ioexception) {
                    LOGGER.warn("Failed to load texture: {}", (Object)this.f_118129_, (Object)ioexception);
                }
                this.textureUploaded = true;
            }
        });
        if (this.future == null) {
            NativeImage nativeimage;
            if (this.cacheFile != null && this.cacheFile.isFile()) {
                LOGGER.debug("Loading http texture from local cache ({})", (Object)this.cacheFile);
                FileInputStream fileinputstream = new FileInputStream(this.cacheFile);
                nativeimage = this.loadTexture(fileinputstream);
            } else {
                nativeimage = null;
            }
            if (nativeimage != null) {
                this.setImage(nativeimage);
            } else {
                this.future = CompletableFuture.runAsync(() -> {
                    HttpURLConnection httpurlconnection = null;
                    LOGGER.debug("Downloading http texture from {} to {}", (Object)this.imageUrl, (Object)this.cacheFile);
                    try {
                        httpurlconnection = (HttpURLConnection)new URL(this.imageUrl).openConnection(Minecraft.m_91087_().m_91096_());
                        httpurlconnection.setDoInput(true);
                        httpurlconnection.setDoOutput(false);
                        httpurlconnection.setRequestProperty("Accept", "image/png");
                        httpurlconnection.connect();
                        if (httpurlconnection.getResponseCode() == 200) {
                            InputStream inputstream;
                            if (this.cacheFile != null) {
                                FileUtils.copyInputStreamToFile((InputStream)httpurlconnection.getInputStream(), (File)this.cacheFile);
                                inputstream = new FileInputStream(this.cacheFile);
                            } else {
                                inputstream = httpurlconnection.getInputStream();
                            }
                            NativeImage nativeimage1 = this.loadTexture(inputstream);
                            if (nativeimage1 != null) {
                                this.setImage(nativeimage1);
                            }
                            return;
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.error("Couldn't download http texture", (Throwable)exception);
                        return;
                    }
                    finally {
                        if (httpurlconnection != null) {
                            httpurlconnection.disconnect();
                        }
                    }
                }, Util.m_183991_());
            }
        }
    }

    private NativeImage loadTexture(InputStream inputStreamIn) {
        NativeImage nativeimage = null;
        try {
            nativeimage = NativeImage.m_85058_((InputStream)inputStreamIn);
            Objects.requireNonNull(this);
            nativeimage = this.processLegacySkin(nativeimage);
        }
        catch (IOException ioexception) {
            LOGGER.warn("Error while loading the skin texture", (Throwable)ioexception);
        }
        return nativeimage;
    }

    private NativeImage processLegacySkin(NativeImage nativeImageIn) {
        if (nativeImageIn == null) {
            return null;
        }
        this.imageWidth = nativeImageIn.m_84982_();
        this.imageHeight = nativeImageIn.m_85084_();
        boolean flag = this.imageHeight == this.imageWidth / 2;
        float scaleFactor = 0.015625f * (float)this.imageWidth;
        if (flag) {
            NativeImage nativeimage = new NativeImage(this.imageWidth, this.imageWidth, true);
            nativeimage.m_85054_(nativeImageIn);
            nativeImageIn.close();
            nativeImageIn = nativeimage;
            if (!this.isTransparent) {
                nativeimage.m_84997_(0, (int)(32.0f * scaleFactor), (int)(64.0f * scaleFactor), (int)(32.0f * scaleFactor), 0);
            }
            HDDownloadingTexture.copyAreaRGBAScale(nativeimage, 4, 16, 16, 32, 4, 4, true, false, scaleFactor);
            HDDownloadingTexture.copyAreaRGBAScale(nativeimage, 8, 16, 16, 32, 4, 4, true, false, scaleFactor);
            HDDownloadingTexture.copyAreaRGBAScale(nativeimage, 0, 20, 24, 32, 4, 12, true, false, scaleFactor);
            HDDownloadingTexture.copyAreaRGBAScale(nativeimage, 4, 20, 16, 32, 4, 12, true, false, scaleFactor);
            HDDownloadingTexture.copyAreaRGBAScale(nativeimage, 8, 20, 8, 32, 4, 12, true, false, scaleFactor);
            HDDownloadingTexture.copyAreaRGBAScale(nativeimage, 12, 20, 16, 32, 4, 12, true, false, scaleFactor);
            HDDownloadingTexture.copyAreaRGBAScale(nativeimage, 44, 16, -8, 32, 4, 4, true, false, scaleFactor);
            HDDownloadingTexture.copyAreaRGBAScale(nativeimage, 48, 16, -8, 32, 4, 4, true, false, scaleFactor);
            HDDownloadingTexture.copyAreaRGBAScale(nativeimage, 40, 20, 0, 32, 4, 12, true, false, scaleFactor);
            HDDownloadingTexture.copyAreaRGBAScale(nativeimage, 44, 20, -8, 32, 4, 12, true, false, scaleFactor);
            HDDownloadingTexture.copyAreaRGBAScale(nativeimage, 48, 20, -16, 32, 4, 12, true, false, scaleFactor);
            HDDownloadingTexture.copyAreaRGBAScale(nativeimage, 52, 20, -8, 32, 4, 12, true, false, scaleFactor);
        }
        if (!this.isTransparent) {
            HDDownloadingTexture.setAreaOpaque(nativeImageIn, 0, 0, (int)(32.0f * scaleFactor), (int)(16.0f * scaleFactor));
        }
        if (flag) {
            HDDownloadingTexture.setAreaTransparent(nativeImageIn, 32, 0, (int)(64.0f * scaleFactor), (int)(32.0f * scaleFactor));
        }
        if (!this.isTransparent) {
            HDDownloadingTexture.setAreaOpaque(nativeImageIn, 0, (int)(16.0f * scaleFactor), (int)(64.0f * scaleFactor), (int)(32.0f * scaleFactor));
            HDDownloadingTexture.setAreaOpaque(nativeImageIn, (int)(16.0f * scaleFactor), (int)(48.0f * scaleFactor), (int)(48.0f * scaleFactor), (int)(64.0f * scaleFactor));
        }
        return nativeImageIn;
    }

    private static void copyAreaRGBAScale(NativeImage nativeimage, int xFrom, int yFrom, int xToDelta, int yToDelta, int widthIn, int heightIn, boolean mirrorX, boolean mirrorY, float scaleFactor) {
        nativeimage.m_85025_((int)((float)xFrom * scaleFactor), (int)((float)yFrom * scaleFactor), (int)((float)xToDelta * scaleFactor), (int)((float)yToDelta * scaleFactor), (int)((float)widthIn * scaleFactor), (int)((float)heightIn * scaleFactor), mirrorX, mirrorY);
    }

    private static void setAreaTransparent(NativeImage image, int x, int y, int width, int height) {
        for (int i = x; i < width; ++i) {
            for (int j = y; j < height; ++j) {
                int k = image.m_84985_(i, j);
                if ((k >> 24 & 0xFF) >= 128) continue;
                return;
            }
        }
        for (int l = x; l < width; ++l) {
            for (int i1 = y; i1 < height; ++i1) {
                image.m_84988_(l, i1, image.m_84985_(l, i1) & 0xFFFFFF);
            }
        }
    }

    private static void setAreaOpaque(NativeImage image, int x, int y, int width, int height) {
        for (int i = x; i < width; ++i) {
            for (int j = y; j < height; ++j) {
                image.m_84988_(i, j, image.m_84985_(i, j) | 0xFF000000);
            }
        }
    }
}

