/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.reskin.core.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;

public class URLArgument
implements ArgumentType<String> {
    private static final String HTTPS_START = "https://";
    private static final SimpleCommandExceptionType HTTPS_EXCEPTION = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"argument.nohttps"));
    private static final Collection<String> EXAMPLES = Arrays.asList("https://", "https://i.imgur.com/mORJxcm.png");

    public static String getURL(CommandContext<CommandSourceStack> ctx, String arg) {
        return (String)ctx.getArgument(arg, String.class);
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        StringBuilder url = new StringBuilder();
        while (reader.canRead() && reader.peek() != ' ') {
            url.append(reader.read());
            String compareString = url.toString();
            if (compareString.startsWith(compareString.length() < HTTPS_START.length() ? HTTPS_START.substring(0, compareString.length()) : HTTPS_START)) continue;
            throw HTTPS_EXCEPTION.createWithContext((ImmutableStringReader)reader);
        }
        return url.toString();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static URLArgument urlArg() {
        return new URLArgument();
    }
}

