/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.reskin.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.sekwah.reskin.CustomSkinManager;
import com.sekwah.reskin.config.SkinConfig;
import com.sekwah.reskin.core.arguments.URLArgument;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class SetSkinCommand {
    private static final String URL_ARG = "url";
    private static SuggestionProvider<CommandSourceStack> URL_SUGGESTIONS = (ctx, builder) -> SharedSuggestionProvider.m_82967_((String[])new String[]{"https://", "https://i.imgur.com/mORJxcm.png"}, (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder setSkin = (LiteralArgumentBuilder)Commands.m_82127_((String)"setskin").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)URL_ARG, (ArgumentType)URLArgument.urlArg()).requires(sender -> (Boolean)SkinConfig.SELF_SKIN_NEEDS_OP.get() == false || (Boolean)SkinConfig.OTHERS_SELF_SKIN_NEEDS_OP.get() == false || sender.m_6761_(2))).suggests(URL_SUGGESTIONS).executes(ctx -> {
            ServerPlayer entity = ((CommandSourceStack)ctx.getSource()).m_81375_();
            String url = URLArgument.getURL((CommandContext<CommandSourceStack>)ctx, URL_ARG);
            return SetSkinCommand.execute((CommandSourceStack)ctx.getSource(), Collections.singletonList(entity), url);
        })).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).requires(sender -> (Boolean)SkinConfig.OTHERS_SELF_SKIN_NEEDS_OP.get() == false || sender.m_6761_(2))).executes(ctx -> {
            String url = URLArgument.getURL((CommandContext<CommandSourceStack>)ctx, URL_ARG);
            Collection targetPlayers = EntityArgument.m_91477_((CommandContext)ctx, (String)"targets");
            return SetSkinCommand.execute((CommandSourceStack)ctx.getSource(), targetPlayers, url);
        })));
        dispatcher.register(setSkin);
    }

    private static int execute(CommandSourceStack source, Collection<ServerPlayer> targets, String skinUrl) {
        String url = skinUrl;
        List whitelist = (List)SkinConfig.SKIN_SERVER_WHITELIST.get();
        long passedWhitelist = whitelist.stream().filter(value -> url.startsWith((String)value)).count();
        if (Boolean.TRUE.equals(SkinConfig.ENABLE_SKIN_SERVER_WHITELIST.get()) && passedWhitelist == 0L) {
            MutableComponent message = Component.m_237115_((String)"setskin.notwhitelisted");
            Style redMessage = message.m_7383_().m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.RED));
            source.m_288197_(() -> message.m_6270_(redMessage), false);
            return -1;
        }
        targets.forEach(target -> {
            if (target == null) {
                return;
            }
            source.m_288197_(() -> Component.m_237110_((String)"setskin.setplayerskin", (Object[])new Object[]{target.m_6302_(), url}), false);
            CustomSkinManager.setSkin((Player)target, url);
        });
        if (targets.size() == 0) {
            return -1;
        }
        return 1;
    }
}

