/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.reskin.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.sekwah.reskin.CustomSkinManager;
import com.sekwah.reskin.config.SkinConfig;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class SetModelCommand {
    private static SuggestionProvider<CommandSourceStack> MODEL_SUGGESTIONS = (ctx, builder) -> SharedSuggestionProvider.m_82967_((String[])new String[]{"default", "slim"}, (SuggestionsBuilder)builder);
    private static final String MODEL_ARG = "modelType";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder setModel = (LiteralArgumentBuilder)Commands.m_82127_((String)"setmodel").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)MODEL_ARG, (ArgumentType)StringArgumentType.word()).requires(sender -> (Boolean)SkinConfig.SELF_SKIN_NEEDS_OP.get() == false || (Boolean)SkinConfig.OTHERS_SELF_SKIN_NEEDS_OP.get() == false || sender.m_6761_(2))).suggests(MODEL_SUGGESTIONS).executes(ctx -> {
            ServerPlayer entity = ((CommandSourceStack)ctx.getSource()).m_81375_();
            String modelType = StringArgumentType.getString((CommandContext)ctx, (String)MODEL_ARG);
            return SetModelCommand.execute((CommandSourceStack)ctx.getSource(), Collections.singletonList(entity), modelType);
        })).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).requires(sender -> (Boolean)SkinConfig.OTHERS_SELF_SKIN_NEEDS_OP.get() == false || sender.m_6761_(2))).executes(ctx -> {
            Collection targetPlayers = EntityArgument.m_91477_((CommandContext)ctx, (String)"targets");
            String modelType = StringArgumentType.getString((CommandContext)ctx, (String)MODEL_ARG);
            return SetModelCommand.execute((CommandSourceStack)ctx.getSource(), targetPlayers, modelType);
        })));
        dispatcher.register(setModel);
    }

    private static int execute(CommandSourceStack source, Collection<ServerPlayer> targets, String modelType) {
        targets.forEach(target -> {
            if (target == null) {
                return;
            }
            source.m_288197_(() -> Component.m_237110_((String)"setskin.setplayermodel", (Object[])new Object[]{target.m_5446_(), modelType}), false);
            CustomSkinManager.setModel((Player)target, modelType);
        });
        if (targets.size() == 0) {
            return -1;
        }
        return 1;
    }
}

