/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.reskin.client;

import com.google.common.collect.Maps;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.sekwah.reskin.ReSkin;
import com.sekwah.reskin.capabilities.SkinCapabilityHandler;
import com.sekwah.reskin.core.client.ClientSkinData;
import com.sekwah.reskin.core.client.HDDownloadingTexture;
import com.sekwah.reskin.core.client.SkinLoadJob;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;

public class ClientSkinManager {
    private static TextureManager textureManager;
    private static ClientSkinData missing;
    public static final Map<UUID, ClientSkinData> originalSkinMap;
    private static Map<String, ResourceLocation> cachedUrls;

    public static void getTextureManager() {
        textureManager = Minecraft.m_91087_().m_91097_();
    }

    public static void clearSkinCache() {
        for (ResourceLocation resource : cachedUrls.values()) {
            textureManager.m_118513_(resource);
        }
        cachedUrls.clear();
    }

    public static void cleanupSkinData() {
        originalSkinMap.clear();
    }

    public static void loadSkin(SkinLoadJob loadJob) {
        ResourceLocation resourceLocation = new ResourceLocation("reskin", "skins/" + loadJob.url.hashCode());
        ReSkin.LOGGER.info("Downloading skin from: {}", (Object)loadJob.url);
        HDDownloadingTexture downloadingTexture = new HDDownloadingTexture(null, loadJob.url, ClientSkinManager.missing.resourceLocation, loadJob.isTransparent, null);
        if (downloadingTexture != null) {
            textureManager.m_118495_(resourceLocation, (AbstractTexture)downloadingTexture);
        } else {
            resourceLocation = ClientSkinManager.missing.resourceLocation;
        }
        cachedUrls.put(loadJob.url, resourceLocation);
    }

    public static void checkSkin(AbstractClientPlayer player) {
        player.getCapability(SkinCapabilityHandler.SKIN_DATA).ifPresent(skin -> {
            if (skin.getSkinUrl() != null && !cachedUrls.containsKey(skin.getSkinUrl()) && !Objects.equals(skin.getSkinUrl(), "reset")) {
                ClientSkinManager.loadSkin(new SkinLoadJob(skin.getSkinUrl(), skin.isTransparent()));
            }
            if (player.f_108546_ == null) {
                return;
            }
            ResourceLocation currentSkin = (ResourceLocation)player.f_108546_.f_105299_.get(MinecraftProfileTexture.Type.SKIN);
            if (!Objects.equals(skin.getSkinUrl(), "")) {
                if (Objects.equals(skin.getSkinUrl(), "reset")) {
                    ClientSkinData originalSkin = originalSkinMap.get(player.m_20148_());
                    if (originalSkin != null) {
                        if (currentSkin != originalSkin.resourceLocation) {
                            player.f_108546_.f_105299_.put(MinecraftProfileTexture.Type.SKIN, originalSkin.resourceLocation);
                            player.f_108546_.f_105303_ = originalSkin.modelType;
                        }
                    } else if (currentSkin != null) {
                        player.f_108546_.f_105299_.put(MinecraftProfileTexture.Type.SKIN, null);
                        player.f_108546_.f_105303_ = null;
                    }
                } else {
                    if (currentSkin != cachedUrls.get(skin.getSkinUrl())) {
                        player.f_108546_.f_105299_.put(MinecraftProfileTexture.Type.SKIN, cachedUrls.get(skin.getSkinUrl()));
                    }
                    player.f_108546_.f_105303_ = skin.getModelType();
                }
            }
        });
    }

    static {
        missing = new ClientSkinData(new ResourceLocation("textures/entity/steve.png"), "default");
        originalSkinMap = Maps.newHashMap();
        cachedUrls = Maps.newHashMap();
    }
}

