/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.reskin.capabilities;

import com.sekwah.reskin.capabilities.ISkinData;
import com.sekwah.reskin.capabilities.SkinCapabilityHandler;
import com.sekwah.reskin.config.SkinConfig;
import com.sekwah.sekclib.capabilitysync.capabilitysync.annotation.Sync;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class SkinData
implements ISkinData,
ICapabilityProvider {
    @Sync(syncGlobally=true)
    private String url = "";
    @Sync(syncGlobally=true)
    private String bodyType = "default";
    @Sync(syncGlobally=true)
    public boolean isTransparent = (Boolean)SkinConfig.ALLOW_TRANSPARENT_SKIN.get();
    private static final String SKIN_TAG = "skin";
    private static final String BODY_TYPE_TAG = "bodyType";
    private final LazyOptional<ISkinData> holder = LazyOptional.of(() -> this);

    @Override
    public String getSkinUrl() {
        return this.url;
    }

    @Override
    public void setSkin(String url) {
        this.url = url == null ? "" : url;
        this.isTransparent = (Boolean)SkinConfig.ALLOW_TRANSPARENT_SKIN.get();
    }

    @Override
    public String getModelType() {
        return this.bodyType;
    }

    @Override
    public void setModelType(String bodyType) {
        this.bodyType = bodyType;
    }

    @Override
    public boolean isTransparent() {
        return this.isTransparent;
    }

    public Tag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.getSkinUrl() != null) {
            tag.m_128359_(SKIN_TAG, this.getSkinUrl());
        }
        if (this.getModelType() != null) {
            tag.m_128359_(BODY_TYPE_TAG, this.getModelType());
        }
        return tag;
    }

    public void deserializeNBT(Tag tag) {
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            this.setSkin(compoundTag.m_128461_(SKIN_TAG));
            this.setModelType(compoundTag.m_128461_(BODY_TYPE_TAG));
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return SkinCapabilityHandler.SKIN_DATA.orEmpty(cap, this.holder);
    }
}

