/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.network.message;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import vazkii.psi.common.Psi;
import vazkii.psi.common.core.handler.PlayerDataHandler;

public class MessageDeductPsi {
    private final int prev;
    private final int current;
    private final int cd;
    private final boolean shatter;

    public MessageDeductPsi(int prev, int current, int cd, boolean shatter) {
        this.prev = prev;
        this.current = current;
        this.cd = cd;
        this.shatter = shatter;
    }

    public MessageDeductPsi(FriendlyByteBuf buf) {
        this.prev = buf.m_130242_();
        this.current = buf.m_130242_();
        this.cd = buf.m_130242_();
        this.shatter = buf.readBoolean();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130130_(this.prev);
        buf.m_130130_(this.current);
        buf.m_130130_(this.cd);
        buf.writeBoolean(this.shatter);
    }

    public boolean receive(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Player player = Psi.proxy.getClientPlayer();
            if (player != null) {
                PlayerDataHandler.PlayerData data = PlayerDataHandler.get(player);
                data.lastAvailablePsi = data.availablePsi;
                data.availablePsi = this.current;
                data.regenCooldown = this.cd;
                data.deductTick = true;
                data.addDeduction(this.prev, this.prev - this.current, this.shatter);
            }
        });
        return true;
    }
}

