/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.entity;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.psi.api.internal.PsiRenderHelper;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.common.Psi;
import vazkii.psi.common.entity.EntitySpellGrenade;

public class EntitySpellProjectile
extends ThrowableProjectile {
    @ObjectHolder(registryName="minecraft:entity_type", value="psi:spell_projectile")
    public static EntityType<EntitySpellProjectile> TYPE;
    private static final String TAG_COLORIZER = "colorizer";
    private static final String TAG_BULLET = "bullet";
    private static final String TAG_TIME_ALIVE = "timeAlive";
    private static final String TAG_LAST_MOTION_X = "lastMotionX";
    private static final String TAG_LAST_MOTION_Y = "lastMotionY";
    private static final String TAG_LAST_MOTION_Z = "lastMotionZ";
    private static final EntityDataAccessor<ItemStack> COLORIZER_DATA;
    private static final EntityDataAccessor<ItemStack> BULLET_DATA;
    private static final EntityDataAccessor<Optional<UUID>> CASTER_UUID;
    protected static final EntityDataAccessor<Optional<UUID>> ATTACKTARGET_UUID;
    public SpellContext context;
    public int timeAlive;

    public EntitySpellProjectile(EntityType<? extends ThrowableProjectile> type, Level worldIn) {
        super(type, worldIn);
    }

    protected EntitySpellProjectile(EntityType<? extends ThrowableProjectile> type, Level world, LivingEntity thrower) {
        super(type, thrower, world);
        this.m_5602_((Entity)thrower);
        this.m_19915_(thrower.m_146908_() + 180.0f, -thrower.m_146909_());
        float f = 1.5f;
        double mx = (double)(Mth.m_14031_((float)(this.m_146908_() / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(this.m_146909_() / 180.0f * (float)Math.PI)) * f) / 2.0;
        double mz = (double)(-(Mth.m_14089_((float)(this.m_146908_() / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(this.m_146909_() / 180.0f * (float)Math.PI)) * f)) / 2.0;
        double my = (double)(Mth.m_14031_((float)(this.m_146909_() / 180.0f * (float)Math.PI)) * f) / 2.0;
        this.m_5997_(mx, my, mz);
    }

    public EntitySpellProjectile(Level world, LivingEntity thrower) {
        this(TYPE, world, thrower);
    }

    public EntitySpellProjectile setInfo(Player player, ItemStack colorizer, ItemStack bullet) {
        this.f_19804_.m_135381_(COLORIZER_DATA, (Object)colorizer);
        this.f_19804_.m_135381_(BULLET_DATA, (Object)bullet.m_41777_());
        this.f_19804_.m_135381_(CASTER_UUID, Optional.of(player.m_20148_()));
        this.f_19804_.m_135381_(ATTACKTARGET_UUID, Optional.empty());
        return this;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(COLORIZER_DATA, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(BULLET_DATA, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(CASTER_UUID, Optional.empty());
        this.f_19804_.m_135372_(ATTACKTARGET_UUID, Optional.empty());
    }

    public void m_7380_(CompoundTag tagCompound) {
        super.m_7380_(tagCompound);
        CompoundTag colorizerCmp = new CompoundTag();
        ItemStack colorizer = (ItemStack)this.f_19804_.m_135370_(COLORIZER_DATA);
        if (!colorizer.m_41619_()) {
            colorizerCmp = colorizer.m_41739_(colorizerCmp);
        }
        tagCompound.m_128365_(TAG_COLORIZER, (Tag)colorizerCmp);
        CompoundTag bulletCmp = new CompoundTag();
        ItemStack bullet = (ItemStack)this.f_19804_.m_135370_(BULLET_DATA);
        if (!bullet.m_41619_()) {
            bulletCmp = bullet.m_41739_(bulletCmp);
        }
        tagCompound.m_128365_(TAG_BULLET, (Tag)bulletCmp);
        tagCompound.m_128405_(TAG_TIME_ALIVE, this.timeAlive);
        tagCompound.m_128347_(TAG_LAST_MOTION_X, this.m_20184_().m_7096_());
        tagCompound.m_128347_(TAG_LAST_MOTION_Y, this.m_20184_().m_7098_());
        tagCompound.m_128347_(TAG_LAST_MOTION_Z, this.m_20184_().m_7094_());
    }

    public void m_7378_(CompoundTag tagCompound) {
        super.m_7378_(tagCompound);
        CompoundTag colorizerCmp = tagCompound.m_128469_(TAG_COLORIZER);
        ItemStack colorizer = ItemStack.m_41712_((CompoundTag)colorizerCmp);
        this.f_19804_.m_135381_(COLORIZER_DATA, (Object)colorizer);
        CompoundTag bulletCmp = tagCompound.m_128469_(TAG_BULLET);
        ItemStack bullet = ItemStack.m_41712_((CompoundTag)bulletCmp);
        this.f_19804_.m_135381_(BULLET_DATA, (Object)bullet);
        Entity thrower = this.m_19749_();
        if (thrower instanceof Player) {
            this.f_19804_.m_135381_(CASTER_UUID, Optional.of(thrower.m_20148_()));
        }
        this.timeAlive = tagCompound.m_128451_(TAG_TIME_ALIVE);
        double lastMotionX = tagCompound.m_128459_(TAG_LAST_MOTION_X);
        double lastMotionY = tagCompound.m_128459_(TAG_LAST_MOTION_Y);
        double lastMotionZ = tagCompound.m_128459_(TAG_LAST_MOTION_Z);
        this.m_20334_(lastMotionX, lastMotionY, lastMotionZ);
    }

    public void m_8119_() {
        super.m_8119_();
        int timeAlive = this.f_19797_;
        if (timeAlive > this.getLiveTime()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        ItemStack colorizer = (ItemStack)this.f_19804_.m_135370_(COLORIZER_DATA);
        int colorVal = Psi.proxy.getColorForColorizer(colorizer);
        float r = (float)PsiRenderHelper.r(colorVal) / 255.0f;
        float g = (float)PsiRenderHelper.g(colorVal) / 255.0f;
        float b = (float)PsiRenderHelper.b(colorVal) / 255.0f;
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        Vector3 lookOrig = new Vector3(this.m_20184_()).normalize();
        for (int i = 0; i < this.getParticleCount(); ++i) {
            Vector3 look = lookOrig.copy();
            double spread = 0.6;
            double dist = 0.15;
            if (this instanceof EntitySpellGrenade) {
                look.y += 1.0;
                dist = 0.05;
            }
            look.x += (Math.random() - 0.5) * spread;
            look.y += (Math.random() - 0.5) * spread;
            look.z += (Math.random() - 0.5) * spread;
            look.normalize().multiply(dist);
            if (!this.m_9236_().m_5776_()) continue;
            Psi.proxy.sparkleFX(this.m_9236_(), x, y, z, r, g, b, (float)look.x, (float)look.y, (float)look.z, 1.2f, 12);
        }
    }

    public int getLiveTime() {
        return 600;
    }

    public int getParticleCount() {
        return 5;
    }

    protected void m_6532_(@Nonnull HitResult pos) {
        if (pos instanceof EntityHitResult && ((EntityHitResult)pos).m_82443_() instanceof LivingEntity) {
            this.cast(context -> {
                if (context != null) {
                    context.attackedEntity = (LivingEntity)((EntityHitResult)pos).m_82443_();
                }
            });
        } else {
            this.cast();
        }
    }

    public void cast() {
        this.cast(null);
    }

    public void cast(Consumer<SpellContext> callback) {
        Spell spell;
        ItemStack spellContainer;
        Entity thrower = this.m_19749_();
        boolean canCast = false;
        if (thrower instanceof Player && !(spellContainer = (ItemStack)this.f_19804_.m_135370_(BULLET_DATA)).m_41619_() && ISpellAcceptor.isContainer(spellContainer) && (spell = ISpellAcceptor.acceptor(spellContainer).getSpell()) != null) {
            canCast = true;
            if (this.context == null) {
                this.context = new SpellContext().setPlayer((Player)thrower).setFocalPoint((Entity)this).setSpell(spell);
            }
            this.context.setFocalPoint((Entity)this);
        }
        if (callback != null) {
            callback.accept(this.context);
        }
        if (canCast && this.context != null) {
            this.context.cspell.safeExecute(this.context);
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public Entity m_19749_() {
        Entity superThrower = super.m_19749_();
        if (superThrower != null) {
            return superThrower;
        }
        return ((Optional)this.f_19804_.m_135370_(CASTER_UUID)).map(u -> this.m_20193_().m_46003_(u)).orElse(null);
    }

    public LivingEntity getAttackTarget() {
        double radiusVal = 32.0;
        Vector3 positionVal = Vector3.fromVec3d(this.m_20182_());
        AABB axis = new AABB(positionVal.x - radiusVal, positionVal.y - radiusVal, positionVal.z - radiusVal, positionVal.x + radiusVal, positionVal.y + radiusVal, positionVal.z + radiusVal);
        return ((Optional)this.f_19804_.m_135370_(ATTACKTARGET_UUID)).map(u -> {
            List a = this.m_20193_().m_6443_(LivingEntity.class, axis, e -> e.m_20148_().equals(u));
            if (!a.isEmpty()) {
                return (LivingEntity)a.get(0);
            }
            return null;
        }).orElse(null);
    }

    protected float m_7139_() {
        return 0.0f;
    }

    public boolean m_6090_() {
        return true;
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    static {
        COLORIZER_DATA = SynchedEntityData.m_135353_(EntitySpellProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
        BULLET_DATA = SynchedEntityData.m_135353_(EntitySpellProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
        CASTER_UUID = SynchedEntityData.m_135353_(EntitySpellProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
        ATTACKTARGET_UUID = SynchedEntityData.m_135353_(EntitySpellProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    }
}

