/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.core.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.exosuit.PsiArmorEvent;
import vazkii.psi.api.spell.detonator.IDetonationHandler;

public class CapabilityTriggerSensor
implements IDetonationHandler,
ICapabilityProvider {
    public final Player player;
    public static final String TRIGGER_TICK = "psi:LastTriggeredDetonation";

    public CapabilityTriggerSensor(Player player) {
        this.player = player;
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        return PsiAPI.DETONATION_HANDLER_CAPABILITY.orEmpty(capability, LazyOptional.of(() -> this));
    }

    @Override
    public void detonate() {
        long worldTime;
        CompoundTag playerData = this.player.getPersistentData();
        long detonated = playerData.m_128454_(TRIGGER_TICK);
        if (detonated != (worldTime = this.player.m_9236_().m_46467_())) {
            playerData.m_128356_(TRIGGER_TICK, worldTime);
            PsiArmorEvent.post(new PsiArmorEvent(this.player, "psi.event.spell_detonate"));
        }
    }

    @Override
    public Vec3 objectLocus() {
        return this.player.m_20182_();
    }
}

