/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.core.handler;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.gui.PsiHudElementType;
import vazkii.psi.api.gui.RenderPsiHudEvent;
import vazkii.psi.api.internal.PsiRenderHelper;
import vazkii.psi.client.core.handler.ShaderHandler;
import vazkii.psi.common.core.handler.ConfigHandler;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.item.base.IHUDItem;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="psi", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class HUDHandler {
    private static final ResourceLocation psiBar = new ResourceLocation("psi:textures/gui/psi_bar.png");
    private static final ResourceLocation psiBarMask = new ResourceLocation("psi:textures/gui/psi_bar_mask.png");
    private static final ResourceLocation psiBarShatter = new ResourceLocation("psi:textures/gui/psi_bar_shatter.png");
    private static boolean registeredMask = false;
    private static final int maxRemainingTicks = 30;
    private static ItemStack remainingDisplayStack;
    private static int remainingTime;
    private static int remainingCount;
    public static final IGuiOverlay PSI_BAR;
    public static final IGuiOverlay SOCKETABLE_EQUIPPED_NAME;
    public static final IGuiOverlay REMAINING_ITEMS;
    public static final IGuiOverlay HUD_ITEM;

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void register(RegisterGuiOverlaysEvent event) {
        event.registerAboveAll("psi_bar", PSI_BAR);
        event.registerAboveAll("socketable_equipped_name", SOCKETABLE_EQUIPPED_NAME);
        event.registerAboveAll("remaining_items", REMAINING_ITEMS);
        event.registerAboveAll("hud_item", HUD_ITEM);
    }

    public static void tick() {
        if (remainingTime > 0) {
            --remainingTime;
        }
    }

    private static boolean showsBar(PlayerDataHandler.PlayerData data, ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        return stack.getCapability(PsiAPI.PSI_BAR_DISPLAY_CAPABILITY).map(c -> c.shouldShow(data)).orElse(false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawPsiBar(GuiGraphics graphics, float partialTick, int screenWidth, int screenHeight) {
        Minecraft mc = Minecraft.m_91087_();
        ItemStack cadStack = PsiAPI.getPlayerCAD((Player)mc.f_91074_);
        if (cadStack.m_41619_()) {
            return;
        }
        ICAD cad = (ICAD)cadStack.m_41720_();
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get((Player)mc.f_91074_);
        int totalPsi = data.getTotalPsi();
        int currPsi = data.getAvailablePsi();
        if (((Boolean)ConfigHandler.CLIENT.contextSensitiveBar.get()).booleanValue() && currPsi == totalPsi && !HUDHandler.showsBar(data, mc.f_91074_.m_21205_()) && !HUDHandler.showsBar(data, mc.f_91074_.m_21206_())) {
            return;
        }
        graphics.m_280168_().m_85836_();
        boolean right = (Boolean)ConfigHandler.CLIENT.psiBarOnRight.get();
        int pad = 3;
        int width = 32;
        int height = 140;
        int x = -pad;
        if (right) {
            x = screenWidth + pad - width;
        }
        int y = screenHeight / 2 - height / 2;
        if (!registeredMask) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)psiBarMask);
            RenderSystem.setShaderTexture((int)1, (ResourceLocation)psiBarShatter);
            registeredMask = true;
        }
        RenderSystem.enableBlend();
        graphics.m_280163_(psiBar, x, y, 0.0f, 0.0f, width, height, 64, 256);
        x += 8;
        y += 26;
        width = 16;
        height = 106;
        float r = 0.6f;
        float g = 0.65f;
        float b = 1.0f;
        if (data.isOverflowed()) {
            r = 1.0f;
            g = 0.6f;
            b = 0.6f;
        }
        int origHeight = height;
        int origY = y;
        int v = 0;
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        for (PlayerDataHandler.PlayerData.Deduction d : data.deductions) {
            float a = d.getPercentile(partialTick);
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
            height = (int)Math.ceil((double)origHeight * (double)d.deduct / (double)totalPsi);
            int effHeight = (int)((double)origHeight * (double)d.current / (double)totalPsi);
            v = origHeight - effHeight;
            y = origY + v;
            HUDHandler.usePsiBarShader(a, d.shatter, data.overflowed);
            graphics.m_280163_(psiBar, x, y, 32.0f, (float)v, width, height, 64, 256);
        }
        float textY = origY;
        if (totalPsi > 0) {
            height = (int)((double)origHeight * (double)data.availablePsi / (double)totalPsi);
            v = origHeight - height;
            y = origY + v;
            if (data.availablePsi != data.lastAvailablePsi) {
                float textHeight = (float)((double)origHeight * ((double)((float)data.availablePsi * partialTick) + (double)data.lastAvailablePsi * (1.0 - (double)partialTick)) / (double)totalPsi);
                textY = (float)origY + ((float)origHeight - textHeight);
            } else {
                textY = y;
            }
        } else {
            height = 0;
        }
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
        HUDHandler.usePsiBarShader(1.0f, false, data.overflowed);
        graphics.m_280163_(psiBar, x, y, 32.0f, (float)v, width, height, 64, 256);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, textY, 0.0f);
        width = 44;
        height = 3;
        int storedPsi = cad.getStoredPsi(cadStack);
        String s1 = storedPsi == -1 ? "\u221e" : "" + data.availablePsi;
        String s2 = "" + storedPsi;
        int offBar = 22;
        int offStr1 = 7 + mc.f_91062_.m_92895_(s1);
        int offStr2 = 7 + mc.f_91062_.m_92895_(s2);
        if (!right) {
            offBar = 6;
            offStr1 = -23;
            offStr2 = -23;
        }
        int color = cad.getSpellColor(cadStack);
        RenderSystem.setShaderColor((float)((float)PsiRenderHelper.r(color) / 255.0f), (float)((float)PsiRenderHelper.g(color) / 255.0f), (float)((float)PsiRenderHelper.b(color) / 255.0f), (float)1.0f);
        graphics.m_280163_(psiBar, x - offBar, -2, 0.0f, 140.0f, width, height, 64, 256);
        graphics.m_280056_(mc.f_91062_, s1, x - offStr1, -11, 0xFFFFFF, true);
        graphics.m_280168_().m_85849_();
        if (storedPsi != -1) {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(0.0f, Math.max(textY + 3.0f, (float)(origY + 100)), 0.0f);
            graphics.m_280056_(mc.f_91062_, s2, x - offStr2, 0, 0xFFFFFF, true);
            graphics.m_280168_().m_85849_();
        }
        RenderSystem.disableBlend();
        graphics.m_280168_().m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderSocketableEquippedName(GuiGraphics graphics, float partialTick, int screenWidth, int screenHeight) {
        Minecraft mc = Minecraft.m_91087_();
        ItemStack stack = mc.f_91074_.m_21120_(InteractionHand.MAIN_HAND);
        if (!ISocketable.isSocketable(stack)) {
            return;
        }
        String name = ISocketable.getSocketedItemName(stack, "").getString();
        if (stack.m_41619_() || name.trim().isEmpty()) {
            return;
        }
        int ticks = mc.f_91065_.f_92993_;
        if ((ticks -= 10) > 0) {
            ISocketable socketable = ISocketable.socketable(stack);
            ItemStack bullet = socketable.getSelectedBullet();
            int alpha = Math.min(255, (int)(((float)ticks - partialTick) * 256.0f / 10.0f));
            int color = 1295871 + (alpha << 24);
            int x = screenWidth / 2 - mc.f_91062_.m_92895_(name) / 2;
            int y = screenHeight - 71;
            if (mc.f_91074_.m_7500_()) {
                y += 14;
            }
            graphics.m_280056_(mc.f_91062_, name, x, y, color, true);
            int w = mc.f_91062_.m_92895_(name);
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_((float)(x + w), (float)(y - 6), 0.0f);
            graphics.m_280168_().m_85841_((float)alpha / 255.0f, 1.0f, 1.0f);
            graphics.m_280203_(bullet, 0, 0);
            graphics.m_280168_().m_85849_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderRemainingItems(GuiGraphics graphics, float partialTick, int screenWidth, int screenHeight) {
        if (remainingTime > 0 && !remainingDisplayStack.m_41619_()) {
            int pos = 30 - remainingTime;
            Minecraft mc = Minecraft.m_91087_();
            int remainingLeaveTicks = 20;
            int x = screenWidth / 2 + 10 + Math.max(0, pos - remainingLeaveTicks);
            int y = screenHeight / 2;
            int start = 30 - remainingLeaveTicks;
            float alpha = (float)remainingTime + partialTick > (float)start ? 1.0f : ((float)remainingTime + partialTick) / (float)start;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            int xp = x + (int)(16.0f * (1.0f - alpha));
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_((float)xp, (float)y, 0.0f);
            graphics.m_280168_().m_85841_(alpha, 1.0f, 1.0f);
            graphics.m_280203_(remainingDisplayStack, 0, 0);
            graphics.m_280168_().m_85841_(1.0f / alpha, 1.0f, 1.0f);
            graphics.m_280168_().m_252880_((float)(-xp), (float)(-y), 0.0f);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Object text = remainingDisplayStack.m_41786_().m_6879_().m_130940_(ChatFormatting.GREEN).getString();
            if (remainingCount >= 0) {
                int max = remainingDisplayStack.m_41741_();
                int stacks = remainingCount / max;
                int rem = remainingCount % max;
                text = stacks == 0 ? "" + remainingCount : remainingCount + " (" + String.valueOf(ChatFormatting.AQUA) + stacks + String.valueOf(ChatFormatting.RESET) + "*" + String.valueOf(ChatFormatting.GRAY) + max + String.valueOf(ChatFormatting.RESET) + "+" + String.valueOf(ChatFormatting.YELLOW) + rem + String.valueOf(ChatFormatting.RESET) + ")";
            } else if (remainingCount == -1) {
                text = "\u221e";
            }
            int color = 0xFFFFFF | (int)(alpha * 255.0f) << 24;
            graphics.m_280056_(mc.f_91062_, (String)text, x + 20, y + 6, color, true);
            graphics.m_280168_().m_85849_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderHUDItem(GuiGraphics graphics, float partialTicks, int screenWidth, int screenHeight) {
        Minecraft mc = Minecraft.m_91087_();
        ItemStack stack = mc.f_91074_.m_21205_();
        if (!stack.m_41619_() && stack.m_41720_() instanceof IHUDItem) {
            ((IHUDItem)stack.m_41720_()).drawHUD(graphics, partialTicks, screenWidth, screenHeight, stack);
        }
        if (!(stack = mc.f_91074_.m_21206_()).m_41619_() && stack.m_41720_() instanceof IHUDItem) {
            ((IHUDItem)stack.m_41720_()).drawHUD(graphics, partialTicks, screenWidth, screenHeight, stack);
        }
    }

    public static void setRemaining(ItemStack stack, int count) {
        remainingDisplayStack = stack;
        remainingCount = count;
        remainingTime = stack.m_41619_() ? 0 : 30;
    }

    public static void setRemaining(Player player, ItemStack displayStack, Pattern pattern) {
        int count = 0;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41619_() || !(pattern == null ? ItemStack.m_41656_((ItemStack)displayStack, (ItemStack)stack) : pattern.matcher(stack.m_41778_()).find())) continue;
            count += stack.m_41613_();
        }
        HUDHandler.setRemaining(displayStack, count);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void usePsiBarShader(float percentile, boolean shatter, boolean overflowed) {
        ShaderInstance psiBarShader = ShaderHandler.getPsiBarShader();
        RenderSystem.setShader(ShaderHandler::getPsiBarShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)psiBar);
        RenderSystem.setShaderTexture((int)1, (ResourceLocation)(shatter ? psiBarShatter : psiBarMask));
        psiBarShader.m_173356_("GameTime").m_5985_(RenderSystem.getShaderGameTime());
        psiBarShader.m_173356_("PsiBarPercentile").m_5985_(percentile);
        psiBarShader.m_173356_("PsiBarOverflowed").m_142617_(overflowed ? 1 : 0);
    }

    static {
        PSI_BAR = (gui, poseStack, partialTick, screenWidth, screenHeight) -> {
            if (!MinecraftForge.EVENT_BUS.post((Event)new RenderPsiHudEvent(PsiHudElementType.PSI_BAR))) {
                HUDHandler.drawPsiBar(poseStack, partialTick, screenWidth, screenHeight);
            }
        };
        SOCKETABLE_EQUIPPED_NAME = (gui, poseStack, partialTick, screenWidth, screenHeight) -> {
            if (!MinecraftForge.EVENT_BUS.post((Event)new RenderPsiHudEvent(PsiHudElementType.SOCKETABLE_EQUIPPED_NAME))) {
                HUDHandler.renderSocketableEquippedName(poseStack, partialTick, screenWidth, screenHeight);
            }
        };
        REMAINING_ITEMS = (gui, poseStack, partialTick, screenWidth, screenHeight) -> {
            if (!MinecraftForge.EVENT_BUS.post((Event)new RenderPsiHudEvent(PsiHudElementType.REMAINING_ITEMS))) {
                HUDHandler.renderRemainingItems(poseStack, partialTick, screenWidth, screenHeight);
            }
        };
        HUD_ITEM = (gui, poseStack, partialTick, screenWidth, screenHeight) -> {
            if (!MinecraftForge.EVENT_BUS.post((Event)new RenderPsiHudEvent(PsiHudElementType.HUD_ITEM))) {
                HUDHandler.renderHUDItem(poseStack, partialTick, screenWidth, screenHeight);
            }
        };
    }
}

