/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api.spell;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.internal.MathHelper;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.CompiledSpell;
import vazkii.psi.api.spell.ISpellImmune;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellRuntimeException;

public final class SpellContext {
    public static final double MAX_DISTANCE = 32.0;
    public Player caster;
    public Entity focalPoint;
    public CompiledSpell cspell;
    public int loopcastIndex = 0;
    public InteractionHand castFrom;
    public ItemStack tool = ItemStack.f_41583_;
    public BlockHitResult positionBroken;
    public LivingEntity attackedEntity;
    public LivingEntity attackingEntity;
    public double damageTaken;
    public int targetSlot = 1;
    public boolean shiftTargetSlot = true;
    public boolean customTargetSlot = false;
    public final Map<String, Object> customData = new HashMap<String, Object>();
    public final Object[][] evaluatedObjects = new Object[9][9];
    public Stack<CompiledSpell.Action> actions = null;
    public boolean stopped = false;
    public int delay = 0;

    public SpellContext setPlayer(Player player) {
        this.caster = player;
        return this.setFocalPoint((Entity)player);
    }

    public SpellContext setFocalPoint(Entity e) {
        this.focalPoint = e;
        return this;
    }

    public SpellContext setCompiledSpell(CompiledSpell spell) {
        this.cspell = spell;
        return this;
    }

    public SpellContext setSpell(Spell spell) {
        this.setCompiledSpell(PsiAPI.internalHandler.getSpellCache().getCompiledSpell(spell));
        return this;
    }

    public SpellContext setLoopcastIndex(int i) {
        this.loopcastIndex = i;
        return this;
    }

    public boolean isValid() {
        return this.cspell != null;
    }

    public boolean shouldSuppressErrors() {
        return this.isValid() && this.cspell.metadata.errorsSuppressed;
    }

    public boolean isInRadius(Vector3 vec) {
        return this.isInRadius(vec.x, vec.y, vec.z);
    }

    public boolean isInRadius(Entity e) {
        if (e == null) {
            return false;
        }
        if (e == this.focalPoint || e == this.caster) {
            return true;
        }
        return this.isInRadius(e.m_20185_(), e.m_20186_(), e.m_20189_());
    }

    public boolean isInRadius(double x, double y, double z) {
        return MathHelper.pointDistanceSpace(x, y, z, this.focalPoint.m_20185_(), this.focalPoint.m_20186_(), this.focalPoint.m_20189_()) <= 32.0;
    }

    public void verifyEntity(Entity e) throws SpellRuntimeException {
        if (e == null) {
            throw new SpellRuntimeException("psi.spellerror.nulltarget");
        }
        if (ISpellImmune.isImmune(e)) {
            throw new SpellRuntimeException("psi.spellerror.immunetarget");
        }
    }

    public int getTargetSlot() throws SpellRuntimeException {
        int slot = this.targetSlot;
        int cadSlot = PsiAPI.getPlayerCADSlot(this.caster);
        if (cadSlot == -1) {
            throw new SpellRuntimeException("psi.spellerror.nocad");
        }
        if (this.customTargetSlot) {
            return this.targetSlot == 36 ? 40 : this.targetSlot % 36;
        }
        if (this.shiftTargetSlot) {
            int originSlot = Inventory.m_36045_((int)cadSlot) ? cadSlot : this.caster.m_150109_().f_35977_;
            slot = originSlot + this.targetSlot;
        }
        if (slot == -1) {
            return 40;
        }
        if (slot < 0) {
            slot = 10 + slot;
        }
        return slot % 9;
    }

    public ItemStack getHarvestTool() throws SpellRuntimeException {
        if (!this.tool.m_41619_()) {
            return this.tool;
        }
        ItemStack cad = PsiAPI.getPlayerCAD(this.caster);
        if (cad.m_41619_()) {
            throw new SpellRuntimeException("psi.spellerror.nocad");
        }
        return cad;
    }
}

