/*
 * Decompiled with CFR 0.152.
 */
package meranha.mekaweapons.items;

import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.gear.IModule;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.api.providers.IModuleDataProvider;
import mekanism.api.radial.RadialData;
import mekanism.api.radial.mode.IRadialMode;
import mekanism.api.radial.mode.NestedRadialMode;
import mekanism.api.text.EnumColor;
import mekanism.client.key.MekKeyHandler;
import mekanism.client.key.MekanismKeyHandler;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.item.RateLimitEnergyHandler;
import mekanism.common.config.value.CachedValue;
import mekanism.common.content.gear.IModuleContainerItem;
import mekanism.common.content.gear.Module;
import mekanism.common.content.gear.shared.ModuleEnergyUnit;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.lib.attribute.AttributeCache;
import mekanism.common.lib.radial.IGenericRadialModeItem;
import mekanism.common.lib.radial.data.NestingRadialData;
import mekanism.common.registries.MekanismModules;
import mekanism.common.util.StorageUtils;
import meranha.mekaweapons.MekaWeapons;
import meranha.mekaweapons.MekaWeaponsUtils;
import meranha.mekaweapons.items.MekaArrowEntity;
import meranha.mekaweapons.items.modules.DrawSpeedUnit;
import meranha.mekaweapons.items.modules.WeaponAttackAmplificationUnit;
import meranha.mekaweapons.items.modules.WeaponsModules;
import net.minecraft.client.KeyMapping;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;

public class ItemMekaBow
extends BowItem
implements IModuleContainerItem,
IGenericRadialModeItem {
    private final Int2ObjectMap<AttributeCache> attributeCaches = new Int2ObjectArrayMap(WeaponAttackAmplificationUnit.AttackDamage.values().length - 2);
    private static final ResourceLocation RADIAL_ID = MekaWeapons.rl("meka_bow");

    public ItemMekaBow(@NotNull Item.Properties properties) {
        super(properties.m_41497_(Rarity.EPIC).setNoRepair().m_41487_(1));
    }

    public void m_7373_(@Nonnull @NotNull ItemStack stack, @Nullable Level world, @Nonnull @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        if (MekKeyHandler.isKeyPressed((KeyMapping)MekanismKeyHandler.detailsKey)) {
            this.addModuleDetails(stack, tooltip);
            return;
        }
        StorageUtils.addStoredEnergy((ItemStack)stack, tooltip, (boolean)true);
        tooltip.add((Component)MekanismLang.HOLD_FOR_MODULES.translateColored(EnumColor.GRAY, new Object[]{EnumColor.INDIGO, MekanismKeyHandler.detailsKey.m_90863_()}));
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@NotNull EquipmentSlot slot, @NotNull ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            long totalDamage = MekaWeaponsUtils.getTotalDamage(stack);
            return (Multimap)((AttributeCache)this.attributeCaches.compute((int)totalDamage, (damage, previous) -> {
                AttributeModifier currentDamage = new AttributeModifier(f_41374_, "Weapon modifier", (double)totalDamage, AttributeModifier.Operation.ADDITION);
                if (previous != null && ((Multimap)previous.get()).containsKey((Object)Attributes.f_22281_) && ((Multimap)previous.get()).get((Object)Attributes.f_22281_).equals(currentDamage)) {
                    return previous;
                }
                return new AttributeCache(builder -> builder.put((Object)Attributes.f_22281_, (Object)currentDamage), new CachedValue[0]);
            })).get();
        }
        return super.getAttributeModifiers(slot, stack);
    }

    public void m_5929_(@Nonnull @NotNull Level world, @Nonnull @NotNull LivingEntity player, @Nonnull @NotNull ItemStack stack, int timeLeft) {
        if (player.m_6084_() && this.isModuleEnabled(stack, (IModuleDataProvider)WeaponsModules.AUTOFIRE_UNIT) && (float)(this.m_8105_(stack) - timeLeft) == this.getUseTick(stack)) {
            player.m_5810_();
            stack.m_41674_(world, player, 0);
            player.m_6672_(player.m_7655_());
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack bow = player.m_21120_(hand);
        if (level.f_46443_ && MekaWeaponsUtils.isEnergyInsufficient(bow)) {
            return InteractionResultHolder.m_19100_((Object)bow);
        }
        return super.m_7203_(level, player, hand);
    }

    public void m_5551_(@Nonnull @NotNull ItemStack bow, @Nonnull @NotNull Level world, @Nonnull @NotNull LivingEntity entity, int timeLeft) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            IEnergyContainer energyContainer = StorageUtils.getEnergyContainer((ItemStack)bow, (int)0);
            if (!player.m_7500_() && MekaWeaponsUtils.isEnergyInsufficient(bow)) {
                return;
            }
            ItemStack potentialAmmo = player.m_6298_(bow);
            boolean hasAmmo = !potentialAmmo.m_41619_() || this.isModuleEnabled(bow, (IModuleDataProvider)WeaponsModules.ARROWENERGY_UNIT);
            boolean arrowGenerated = potentialAmmo.m_41619_();
            int charge = ForgeEventFactory.onArrowLoose((ItemStack)bow, (Level)world, (Player)player, (int)(this.m_8105_(bow) - timeLeft), (boolean)hasAmmo);
            if (charge < 0 || !hasAmmo) {
                return;
            }
            float velocity = ItemMekaBow.m_40661_((int)charge);
            if ((double)velocity < 0.1) {
                return;
            }
            if (potentialAmmo.m_41619_()) {
                potentialAmmo = new ItemStack((ItemLike)Items.f_42412_);
            }
            if (!world.f_46443_) {
                ArrowItem arrowitem = (ArrowItem)(potentialAmmo.m_41720_() instanceof ArrowItem ? potentialAmmo.m_41720_() : Items.f_42412_);
                AbstractArrow arrowEntity = this.customArrow(arrowitem.m_6394_(world, potentialAmmo, (LivingEntity)player));
                int unitMultiplier = 0;
                arrowEntity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, (float)(3 + unitMultiplier) * velocity, 0.0f);
                long totalDamage = MekaWeaponsUtils.getTotalDamage(bow);
                arrowEntity.m_36781_((double)totalDamage);
                if (this.isModuleEnabled(bow, (IModuleDataProvider)WeaponsModules.ARROWENERGY_UNIT) && (potentialAmmo.m_41720_() == Items.f_42737_ || potentialAmmo.m_41720_() == Items.f_42738_)) {
                    arrowEntity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
                if (this.isModuleEnabled(bow, (IModuleDataProvider)WeaponsModules.ARROWENERGY_UNIT) && arrowGenerated) {
                    arrowEntity.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
                }
                world.m_7967_((Entity)arrowEntity);
            }
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (world.f_46441_.m_188501_() * 0.4f + 1.2f) + velocity * 0.5f);
            if (!this.isModuleEnabled(bow, (IModuleDataProvider)WeaponsModules.ARROWENERGY_UNIT)) {
                potentialAmmo.m_41774_(1);
                if (potentialAmmo.m_41619_()) {
                    player.m_150109_().m_36057_(potentialAmmo);
                }
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            if (!player.m_7500_() && energyContainer != null) {
                energyContainer.extract(FloatingLong.create((long)MekaWeaponsUtils.getEnergyNeeded(bow)), Action.EXECUTE, AutomationType.MANUAL);
            }
        }
    }

    @NotNull
    public AbstractArrow customArrow(AbstractArrow arrow) {
        ItemStack itemStack;
        Entity entity = arrow.m_19749_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            itemStack = player.m_21205_();
        } else {
            itemStack = ItemStack.f_41583_;
        }
        ItemStack weapon = itemStack;
        return new MekaArrowEntity(arrow, new ItemStack((ItemLike)Items.f_42412_), weapon);
    }

    public boolean shouldCauseReequipAnimation(@NotNull ItemStack oldStack, @NotNull ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.m_41720_() != newStack.m_41720_();
    }

    public boolean m_142522_(@Nonnull @NotNull ItemStack stack) {
        return true;
    }

    public int m_142158_(@Nonnull @NotNull ItemStack stack) {
        return StorageUtils.getEnergyBarWidth((ItemStack)stack);
    }

    public int m_142159_(@Nonnull @NotNull ItemStack stack) {
        return MekaWeaponsUtils.getBarCustomColor(stack);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        IModule module = this.getModule(stack, (IModuleDataProvider)MekanismModules.ENERGY_UNIT);
        @NotNull FloatingLongSupplier maxEnergy = () -> module == null ? (FloatingLong)MekaWeapons.general.mekaBowBaseEnergyCapacity.get() : ((ModuleEnergyUnit)module.getCustomInstance()).getEnergyCapacity(module);
        return new ItemCapabilityWrapper(stack, new ItemCapabilityWrapper.ItemCapability[]{RateLimitEnergyHandler.create((FloatingLongSupplier)MekaWeapons.general.mekaBowBaseChargeRate, (FloatingLongSupplier)maxEnergy, (Predicate)BasicEnergyContainer.manualOnly, (Predicate)BasicEnergyContainer.alwaysTrue)});
    }

    public boolean shouldCauseBlockBreakReset(@NotNull ItemStack oldStack, @NotNull ItemStack newStack) {
        return oldStack.m_41720_() != newStack.m_41720_();
    }

    public float getUseTick(@NotNull ItemStack stack) {
        float useTick = 20.0f;
        IModule<DrawSpeedUnit> drawSpeedUnit = MekaWeaponsUtils.getEnabledModule(stack, WeaponsModules.DRAWSPEED_UNIT);
        if (drawSpeedUnit != null) {
            useTick -= (float)(5 * ((DrawSpeedUnit)drawSpeedUnit.getCustomInstance()).getDrawSpeed());
        }
        return useTick;
    }

    public boolean m_8120_(@Nonnull @NotNull ItemStack stack) {
        return MekaWeapons.general.mekaBowEnchantments.get();
    }

    public boolean isBookEnchantable(@NotNull ItemStack stack, @NotNull ItemStack book) {
        return this.m_8120_(stack);
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        return false;
    }

    public boolean supportsSlotType(ItemStack stack, @NotNull EquipmentSlot slotType) {
        return super.supportsSlotType(stack, slotType) && this.getModules(stack).stream().anyMatch(Module::handlesAnyModeChange);
    }

    public void changeMode(@NotNull Player player, @NotNull ItemStack stack, int shift, IModeItem.DisplayChange displayChange) {
        for (Module module : this.getModules(stack)) {
            if (!module.handlesModeChange()) continue;
            module.changeMode(player, stack, shift, displayChange);
            return;
        }
    }

    @Nullable
    public RadialData<?> getRadialData(ItemStack stack) {
        ArrayList nestedModes = new ArrayList();
        Consumer<NestedRadialMode> adder = nestedModes::add;
        for (Module module : this.getModules(stack)) {
            if (!module.handlesRadialModeChange()) continue;
            module.addRadialModes(stack, adder);
        }
        if (nestedModes.isEmpty()) {
            return null;
        }
        if (nestedModes.size() == 1) {
            return ((NestedRadialMode)nestedModes.get(0)).nestedData();
        }
        return new NestingRadialData(RADIAL_ID, nestedModes);
    }

    @Nullable
    public <M extends IRadialMode> M getMode(ItemStack stack, RadialData<M> radialData) {
        for (Module module : this.getModules(stack)) {
            IRadialMode mode;
            if (!module.handlesRadialModeChange() || (mode = module.getMode(stack, radialData)) == null) continue;
            return (M)mode;
        }
        return null;
    }

    public <M extends IRadialMode> void setMode(ItemStack stack, Player player, RadialData<M> radialData, M mode) {
        for (Module module : this.getModules(stack)) {
            if (!module.handlesRadialModeChange() || !module.setMode(player, stack, radialData, mode)) continue;
            return;
        }
    }

    @Nullable
    public Component getScrollTextComponent(@NotNull ItemStack stack) {
        return this.getModules(stack).stream().filter(Module::handlesModeChange).findFirst().map(module -> module.getModeScrollComponent(stack)).orElse(null);
    }
}

