/*
 * Decompiled with CFR 0.152.
 */
package meranha.mekaweapons;

import mekanism.api.math.FloatingLong;
import mekanism.common.config.BaseMekanismConfig;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedBooleanValue;
import mekanism.common.config.value.CachedDoubleValue;
import mekanism.common.config.value.CachedFloatingLongValue;
import mekanism.common.config.value.CachedIntValue;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class WeaponsConfig
extends BaseMekanismConfig {
    private final ForgeConfigSpec configSpec;
    public final CachedFloatingLongValue wirelessChargerEnergyRate;
    public final CachedIntValue mekaTanaBaseDamage;
    public final CachedDoubleValue mekaTanaAttackSpeed;
    public final CachedFloatingLongValue mekaTanaEnergyUsage;
    public final CachedFloatingLongValue mekaTanaSweepingEnergyUsage;
    public final CachedFloatingLongValue mekaTanaTeleportUsage;
    public final CachedIntValue mekaTanaMaxTeleportReach;
    public final CachedFloatingLongValue mekaTanaLootingEnergyUsage;
    public final CachedFloatingLongValue mekaTanaBaseEnergyCapacity;
    public final CachedFloatingLongValue mekaTanaBaseChargeRate;
    public final CachedIntValue mekaBowBaseDamage;
    public final CachedFloatingLongValue mekaBowEnergyUsage;
    public final CachedFloatingLongValue mekaBowFireModeEnergyUsage;
    public final CachedFloatingLongValue mekaBowEnergyArrowUsage;
    public final CachedFloatingLongValue mekabowAutoFireEnergyUsage;
    public final CachedFloatingLongValue mekabowDrawSpeedUsage;
    public final CachedFloatingLongValue mekabowGravityDampenerUsage;
    public final CachedFloatingLongValue mekaBowLootingEnergyUsage;
    public final CachedFloatingLongValue mekaBowBaseEnergyCapacity;
    public final CachedFloatingLongValue mekaBowBaseChargeRate;
    public final CachedBooleanValue mekaTanaEnchantments;
    public final CachedBooleanValue mekaBowEnchantments;

    WeaponsConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("MekaWeapons Settings. Joules to FE conversion: 2.5J = 1FE").push("weapons");
        this.wirelessChargerEnergyRate = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Transfer energy rate of the Wireless Charger (Magnetizer), in Joules per tick.", (String)"wirelessChargerEnergyRate", (FloatingLong)FloatingLong.createConst((long)1250000L));
        builder.comment("Meka-tana Settings").push("mekatana");
        this.mekaTanaBaseDamage = CachedIntValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Base damage of the Meka-Tana, multiply it with Attack Amplification Units.").define("baseDamage", (Object)50));
        this.mekaTanaAttackSpeed = CachedDoubleValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Attack speed of the Meka-Tana.").defineInRange("attackSpeed", -2.4, -Attributes.f_22283_.m_22082_(), 100.0));
        this.mekaTanaEnergyUsage = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Cost in Joules of using the Meka-Tana to deal damage.", (String)"energyUsage", (FloatingLong)FloatingLong.createConst((long)625000L));
        this.mekaTanaSweepingEnergyUsage = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Additional cost in Joules of using the Meka-Tana to perform a sweeping attack.", (String)"sweepingAttackEnergyUsage", (FloatingLong)FloatingLong.createConst((long)125000L));
        this.mekaTanaTeleportUsage = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Cost in Joules of using the Meka-Tana to teleport 10 blocks.", (String)"teleportEnergyUsage", (FloatingLong)FloatingLong.createConst((long)5000L));
        this.mekaTanaMaxTeleportReach = CachedIntValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Maximum distance a player can teleport with the Meka-Tana.").defineInRange("maxTeleportReach", 100, 3, 1024));
        this.mekaTanaLootingEnergyUsage = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Cost in Joules of using the Meka-Tana to apply Looting effect to a mob.", (String)"lootingEnergyUsage", (FloatingLong)FloatingLong.createConst((long)125000L));
        this.mekaTanaBaseEnergyCapacity = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Base energy capacity of the Meka-Tana.", (String)"baseEnergyCapacity", (FloatingLong)FloatingLong.createConst((long)16000000L));
        this.mekaTanaBaseChargeRate = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Base charge rate of the Meka-Tana.", (String)"baseChargeRate", (FloatingLong)FloatingLong.createConst((long)350000L));
        this.mekaTanaEnchantments = CachedBooleanValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Whether Meka-Tana can be enchanted. False by default. Use at your own risk.").define("enchantments", false));
        builder.pop();
        builder.comment("Meka-Bow Settings").push("mekabow");
        this.mekaBowBaseDamage = CachedIntValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Attention: The final damage of Meka-Bow is based on how fast the arrow is going when hits, multiply it with Attack Amplification Units.").define("baseDamage", (Object)50));
        this.mekaBowEnergyUsage = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Cost in Joules of using the Meka-Bow.", (String)"energyUsage", (FloatingLong)FloatingLong.createConst((long)625000L));
        this.mekaBowFireModeEnergyUsage = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Cost in Joules of using the Meka-Bow with flame mode active.", (String)"fireModeEnergyUsage", (FloatingLong)FloatingLong.createConst((long)825000L));
        this.mekaBowEnergyArrowUsage = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Additional cost in Joules of firing an arrow with the Meka-Bow when the Arrow Energy Unit module is installed.", (String)"energyArrowUsage", (FloatingLong)FloatingLong.createConst((long)125000L));
        this.mekabowAutoFireEnergyUsage = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Additional cost in Joules of firing an arrow with the Meka-Bow when the Auto-Fire Unit module is installed.", (String)"autoFireEnergyUsage", (FloatingLong)FloatingLong.createConst((long)100000L));
        this.mekabowDrawSpeedUsage = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Additional cost in Joules of firing an arrow with the Meka-Bow per level of Draw Speed Unit installed.", (String)"drawSpeedUsage", (FloatingLong)FloatingLong.createConst((long)50000L));
        this.mekabowGravityDampenerUsage = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Additional cost in Joules of firing an arrow with the Meka-Bow when the Gravity Dampener Unit module is installed.", (String)"gravityDampenerUsage", (FloatingLong)FloatingLong.createConst((long)75000L));
        this.mekaBowLootingEnergyUsage = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Additional cost in Joules of firing an arrow with the Meka-Bow when the Looting Unit module is installed.", (String)"lootingEnergyUsage", (FloatingLong)FloatingLong.createConst((long)125000L));
        this.mekaBowBaseEnergyCapacity = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Base energy capacity of Meka-Bow.", (String)"baseEnergyCapacity", (FloatingLong)FloatingLong.createConst((long)16000000L));
        this.mekaBowBaseChargeRate = CachedFloatingLongValue.define((IMekanismConfig)this, (ForgeConfigSpec.Builder)builder, (String)"Base charge rate of Meka-Bow.", (String)"baseChargeRate", (FloatingLong)FloatingLong.createConst((long)350000L));
        this.mekaBowEnchantments = CachedBooleanValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Whether Meka-Bow can be enchanted. False by default. Use at your own risk.").define("enchantments", false));
        this.configSpec = builder.build();
    }

    public String getFileName() {
        return "mekaweapons";
    }

    public ForgeConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    public ModConfig.Type getConfigType() {
        return ModConfig.Type.SERVER;
    }
}

