/*
 * Decompiled with CFR 0.152.
 */
package meranha.mekaweapons;

import com.mojang.logging.LogUtils;
import mekanism.api.providers.IItemProvider;
import mekanism.api.providers.IModuleDataProvider;
import mekanism.client.ClientRegistrationUtil;
import mekanism.common.Mekanism;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.MekanismConfigHelper;
import mekanism.common.item.ItemModule;
import mekanism.common.registration.impl.ContainerTypeDeferredRegister;
import mekanism.common.registration.impl.ContainerTypeRegistryObject;
import mekanism.common.registration.impl.EntityTypeDeferredRegister;
import mekanism.common.registration.impl.EntityTypeRegistryObject;
import mekanism.common.registration.impl.ItemDeferredRegister;
import mekanism.common.registration.impl.ItemRegistryObject;
import mekanism.common.registries.MekanismCreativeTabs;
import mekanism.common.registries.MekanismModules;
import mekanism.common.util.MekanismUtils;
import meranha.mekaweapons.WeaponsConfig;
import meranha.mekaweapons.WeaponsRenderer;
import meranha.mekaweapons.client.GuiMagnetizer;
import meranha.mekaweapons.client.MagnetizerContainer;
import meranha.mekaweapons.client.MekaArrowRenderer;
import meranha.mekaweapons.items.ItemMagnetizer;
import meranha.mekaweapons.items.ItemMekaBow;
import meranha.mekaweapons.items.ItemMekaTana;
import meranha.mekaweapons.items.MekaArrowEntity;
import meranha.mekaweapons.items.modules.WeaponsModules;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegisterEvent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;

@Mod(value="mekaweapons")
public class MekaWeapons {
    public static final String MODID = "mekaweapons";
    public static final Logger logger = LogUtils.getLogger();
    public static final WeaponsConfig general = new WeaponsConfig();
    public static final ItemDeferredRegister ITEMS = new ItemDeferredRegister("mekaweapons");
    public static final ItemRegistryObject<ItemMekaTana> MEKA_TANA = ITEMS.registerUnburnable("mekatana", ItemMekaTana::new);
    public static final ItemRegistryObject<ItemMekaBow> MEKA_BOW = ITEMS.registerUnburnable("mekabow", ItemMekaBow::new);
    public static final ItemRegistryObject<Item> MAGNETIZER = ITEMS.registerUnburnable("magnetizer", ItemMagnetizer::new);
    public static final ItemRegistryObject<Item> KATANA_BLADE = ITEMS.register("katana_blade");
    public static final ItemRegistryObject<Item> BOW_RISER = ITEMS.register("bow_riser");
    public static final ItemRegistryObject<Item> BOW_LIMB = ITEMS.register("bow_limb");
    public static final ItemRegistryObject<ItemModule> MODULE_LOOTING = ITEMS.registerModule(WeaponsModules.LOOTING_UNIT);
    public static final ItemRegistryObject<ItemModule> MODULE_DRAWSPEED = ITEMS.registerModule(WeaponsModules.DRAWSPEED_UNIT);
    public static final ItemRegistryObject<ItemModule> MODULE_SWEEPING = ITEMS.registerModule(WeaponsModules.SWEEPING_UNIT);
    public static final ItemRegistryObject<ItemModule> MODULE_ARROWENERGY = ITEMS.registerModule(WeaponsModules.ARROWENERGY_UNIT);
    public static final ItemRegistryObject<ItemModule> MODULE_AUTOFIRE = ITEMS.registerModule(WeaponsModules.AUTOFIRE_UNIT);
    public static final ItemRegistryObject<ItemModule> MODULE_GRAVITYDAMPENER = ITEMS.registerModule(WeaponsModules.GRAVITYDAMPENER_UNIT);
    public static final ItemRegistryObject<ItemModule> MODULE_ATTACKAMPLIFICATION = ITEMS.registerModule(WeaponsModules.ATTACKAMPLIFICATION_UNIT);
    public static final EntityTypeDeferredRegister ENTITY_TYPES = new EntityTypeDeferredRegister("mekaweapons");
    public static final EntityTypeRegistryObject<MekaArrowEntity> MEKA_ARROW = ENTITY_TYPES.register("meka_arrow", EntityType.Builder.m_20704_(MekaArrowEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20702_(4).m_20717_(20));
    public static final ContainerTypeDeferredRegister CONTAINER_TYPES = new ContainerTypeDeferredRegister("mekaweapons");
    public static final ContainerTypeRegistryObject<MagnetizerContainer> MAGNETIZER_CONTAINER = CONTAINER_TYPES.register(MAGNETIZER, ItemMagnetizer.class, MagnetizerContainer::new);
    public static final String ADD_MEKA_BOW_MODULES = "add_meka_bow_modules";
    public static final String ADD_MEKATANA_MODULES = "add_mekatana_modules";

    public MekaWeapons() {
        this(FMLJavaModLoadingContext.get().getModEventBus(), ModLoadingContext.get().getActiveContainer());
    }

    public MekaWeapons(IEventBus modEventBus, ModContainer modContainer) {
        ITEMS.register(modEventBus);
        ENTITY_TYPES.register(modEventBus);
        CONTAINER_TYPES.register(modEventBus);
        MekanismConfigHelper.registerConfig((ModContainer)modContainer, (IMekanismConfig)general);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::buildCreativeModeTabContents);
        modEventBus.addListener(this::enqueueIMC);
        modEventBus.addListener(this::registerRenderers);
        MinecraftForge.EVENT_BUS.addListener(this::mekaBowEnergyArrows);
        MinecraftForge.EVENT_BUS.addListener(this::disableMekaBowAttack);
        WeaponsModules.MODULES.register(modEventBus);
    }

    @NotNull
    @Contract(value="_ -> new")
    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MODID, path);
    }

    @NotNull
    @Contract(value="_, _ -> new")
    public static ResourceLocation getResource(@NotNull MekanismUtils.ResourceType guiRadial, String name) {
        return MekaWeapons.rl(guiRadial.getPrefix() + name);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        logger.info("Loaded 'Mekanism: Weapons' module.");
    }

    private void buildCreativeModeTabContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == MekanismCreativeTabs.MEKANISM.get()) {
            ITEMS.getAllItems().forEach(arg_0 -> ((BuildCreativeModeTabContentsEvent)event).m_246326_(arg_0));
        }
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        MekaWeapons.addModules(ADD_MEKA_BOW_MODULES, new IModuleDataProvider[]{MekanismModules.ENERGY_UNIT, WeaponsModules.ATTACKAMPLIFICATION_UNIT, WeaponsModules.AUTOFIRE_UNIT, WeaponsModules.ARROWENERGY_UNIT, WeaponsModules.DRAWSPEED_UNIT, WeaponsModules.GRAVITYDAMPENER_UNIT, WeaponsModules.LOOTING_UNIT});
        MekaWeapons.addModules(ADD_MEKATANA_MODULES, new IModuleDataProvider[]{MekanismModules.ENERGY_UNIT, WeaponsModules.ATTACKAMPLIFICATION_UNIT, MekanismModules.TELEPORTATION_UNIT, WeaponsModules.SWEEPING_UNIT, WeaponsModules.LOOTING_UNIT});
    }

    public static void addModules(String method, IModuleDataProvider<?> ... moduleDataProviders) {
        MekaWeapons.sendModuleIMC(method, moduleDataProviders);
    }

    private static void sendModuleIMC(String method, IModuleDataProvider<?> ... moduleDataProviders) {
        if (moduleDataProviders == null || moduleDataProviders.length == 0) {
            throw new IllegalArgumentException("No module data providers given.");
        }
        InterModComms.sendTo((String)"mekanism", (String)method, () -> moduleDataProviders);
    }

    public void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)MEKA_ARROW.get(), MekaArrowRenderer::new);
    }

    private void mekaBowEnergyArrows(ArrowNockEvent event) {
        ItemMekaBow mekaBow;
        Item item;
        if (!(event.getEntity().m_9236_() instanceof ServerLevel)) {
            return;
        }
        ItemStack stack = event.getBow();
        if (stack.m_41720_() instanceof ProjectileWeaponItem && (item = stack.m_41720_()) instanceof ItemMekaBow && (mekaBow = (ItemMekaBow)item).isModuleEnabled(stack, (IModuleDataProvider)WeaponsModules.ARROWENERGY_UNIT)) {
            event.getEntity().m_6672_(event.getHand());
            event.setAction(InteractionResultHolder.m_19090_((Object)event.getBow()));
        }
    }

    private void disableMekaBowAttack(@NotNull AttackEntityEvent event) {
        Player player = event.getEntity();
        if (!(player.m_9236_() instanceof ServerLevel)) {
            return;
        }
        if (player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof ItemMekaBow) {
            event.setCanceled(true);
        }
    }

    @Mod.EventBusSubscriber(modid="mekaweapons", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            if (ModList.get().isLoaded("curios")) {
                IItemProvider itemProvider = () -> (Item)MAGNETIZER.get();
                CuriosRendererRegistry.register((Item)itemProvider.m_5456_(), WeaponsRenderer::new);
            }
            event.enqueueWork(() -> {
                ClientRegistrationUtil.setPropertyOverride(MEKA_BOW, (ResourceLocation)Mekanism.rl((String)"pull"), (stack, world, entity, seed) -> {
                    Item patt10566$temp;
                    if (entity != null && entity.m_21211_() == stack && (patt10566$temp = stack.m_41720_()) instanceof ItemMekaBow) {
                        ItemMekaBow bow = (ItemMekaBow)patt10566$temp;
                        return (float)(stack.m_41779_() - entity.m_21212_()) / bow.getUseTick(stack);
                    }
                    return 0.0f;
                });
                ClientRegistrationUtil.setPropertyOverride(MEKA_BOW, (ResourceLocation)Mekanism.rl((String)"pulling"), (stack, world, entity, seed) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
            });
        }

        @SubscribeEvent(priority=EventPriority.LOW)
        public static void registerScreens(RegisterEvent event) {
            event.register(Registries.f_256798_, helper -> ClientRegistrationUtil.registerScreen(MAGNETIZER_CONTAINER, GuiMagnetizer::new));
        }
    }
}

