/*
 * Decompiled with CFR 0.152.
 */
package com.fxd927.mekanismelements.common.recipe.lookup.cache;

import com.fxd927.mekanismelements.common.recipe.MSRecipeType;
import com.fxd927.mekanismelements.common.recipe.lookup.cache.MSAbstractInputRecipeCache;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.common.recipe.lookup.cache.type.IInputCache;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class MSEitherSideInputRecipeCache<INPUT, INGREDIENT extends InputIngredient<INPUT>, RECIPE extends MekanismRecipe, CACHE extends IInputCache<INPUT, INGREDIENT, RECIPE>>
extends MSAbstractInputRecipeCache<RECIPE> {
    private final Set<RECIPE> complexRecipes = new HashSet<RECIPE>();
    private final Function<RECIPE, INGREDIENT> inputAExtractor;
    private final Function<RECIPE, INGREDIENT> inputBExtractor;
    private final CACHE cache;

    protected MSEitherSideInputRecipeCache(MSRecipeType<RECIPE, ?> recipeType, Function<RECIPE, INGREDIENT> inputAExtractor, Function<RECIPE, INGREDIENT> inputBExtractor, CACHE cache) {
        super(recipeType);
        this.inputAExtractor = inputAExtractor;
        this.inputBExtractor = inputBExtractor;
        this.cache = cache;
    }

    @Override
    public void clear() {
        super.clear();
        this.cache.clear();
        this.complexRecipes.clear();
    }

    public boolean containsInput(@Nullable Level world, INPUT input) {
        if (this.cache.isEmpty(input)) {
            return false;
        }
        this.initCacheIfNeeded(world);
        return this.cache.contains(input) || this.complexRecipes.stream().anyMatch(recipe -> ((InputIngredient)this.inputAExtractor.apply(recipe)).testType(input) || ((InputIngredient)this.inputBExtractor.apply(recipe)).testType(input));
    }

    public boolean containsInput(@Nullable Level world, INPUT inputA, INPUT inputB) {
        if (this.cache.isEmpty(inputA)) {
            return this.containsInput(world, inputB);
        }
        if (this.cache.isEmpty(inputB)) {
            return true;
        }
        this.initCacheIfNeeded(world);
        if (this.cache.contains(inputA, recipe -> {
            InputIngredient ingredientA = (InputIngredient)this.inputAExtractor.apply(recipe);
            InputIngredient ingredientB = (InputIngredient)this.inputBExtractor.apply(recipe);
            return ingredientB.testType(inputB) && ingredientA.testType(inputA) || ingredientA.testType(inputB) && ingredientB.testType(inputA);
        })) {
            return true;
        }
        return this.complexRecipes.stream().anyMatch(recipe -> {
            InputIngredient ingredientA = (InputIngredient)this.inputAExtractor.apply(recipe);
            InputIngredient ingredientB = (InputIngredient)this.inputBExtractor.apply(recipe);
            return ingredientA.testType(inputA) && ingredientB.testType(inputB) || ingredientB.testType(inputA) && ingredientA.testType(inputB);
        });
    }

    @Nullable
    public RECIPE findFirstRecipe(@Nullable Level world, INPUT inputA, INPUT inputB) {
        if (this.cache.isEmpty(inputA) || this.cache.isEmpty(inputB)) {
            return null;
        }
        this.initCacheIfNeeded(world);
        Predicate<MekanismRecipe> matchPredicate = r -> ((BiPredicate)r).test(inputA, inputB);
        MekanismRecipe recipe = this.cache.findFirstRecipe(inputA, matchPredicate);
        return (RECIPE)(recipe == null ? this.findFirstRecipe(this.complexRecipes, matchPredicate) : recipe);
    }

    @Override
    protected void initCache(List<RECIPE> recipes) {
        for (MekanismRecipe recipe : recipes) {
            boolean complexA = this.cache.mapInputs(recipe, (InputIngredient)this.inputAExtractor.apply(recipe));
            boolean complexB = this.cache.mapInputs(recipe, (InputIngredient)this.inputBExtractor.apply(recipe));
            if (!complexA && !complexB) continue;
            this.complexRecipes.add(recipe);
        }
    }
}

