/*
 * Decompiled with CFR 0.152.
 */
package com.fxd927.mekanismelements.common.item.syringe;

import com.fxd927.mekanismelements.common.registries.MSItems;
import java.util.function.Consumer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public abstract class DrugSyringe
extends Item {
    private static final String USE_COUNT_TAG = "UseCount";
    private final int maxUses;

    public DrugSyringe(Item.Properties properties, int maxUses) {
        super(properties.m_41487_(1));
        this.maxUses = maxUses;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        player.m_6672_(hand);
        player.m_6469_(player.m_269291_().m_269425_(), 1.0f);
        ItemStack itemStack = player.m_21120_(hand);
        if (!level.f_46443_) {
            CompoundTag tag = itemStack.m_41784_();
            int useCount = tag.m_128451_(USE_COUNT_TAG);
            if (useCount < this.maxUses) {
                tag.m_128405_(USE_COUNT_TAG, ++useCount);
                this.applyEffect(level, player, itemStack);
            } else {
                ItemStack filledSyringe = this.getEmptySyringe();
                player.m_21008_(hand, filledSyringe);
            }
        }
        return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.f_46443_);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Level level = target.m_20193_();
        if (!level.f_46443_) {
            CompoundTag tag = stack.m_41784_();
            int useCount = tag.m_128451_(USE_COUNT_TAG);
            if (useCount < this.maxUses) {
                tag.m_128405_(USE_COUNT_TAG, ++useCount);
                this.applyEffectToEntity(level, target, attacker);
                level.m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_12316_, SoundSource.PLAYERS, 1.0f, 1.0f);
            } else {
                ItemStack filledSyringe = this.getEmptySyringe();
                if (attacker instanceof Player) {
                    Player player = (Player)attacker;
                    player.m_21008_(player.m_7655_(), filledSyringe);
                } else {
                    stack.m_41774_(1);
                }
                level.m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_11769_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    protected void applyEffect(Level level, Player player, ItemStack stack) {
        MobEffectInstance currentEffect = player.m_21124_(this.getEffectType());
        int newDuration = this.getBaseDuration();
        if (currentEffect != null) {
            newDuration += currentEffect.m_19557_();
        }
        player.m_7292_(new MobEffectInstance(this.getEffectType(), newDuration, this.getEffectAmplifier()));
    }

    protected void applyEffectToEntity(Level level, LivingEntity target, LivingEntity attacker) {
        MobEffectInstance currentEffect = target.m_21124_(this.getEffectType());
        int newDuration = this.getBaseDuration();
        if (currentEffect != null) {
            newDuration += currentEffect.m_19557_();
        }
        target.m_7292_(new MobEffectInstance(this.getEffectType(), newDuration, this.getEffectAmplifier()));
    }

    protected ItemStack getEmptySyringe() {
        return new ItemStack((ItemLike)MSItems.SYRINGE.get());
    }

    protected abstract MobEffect getEffectType();

    protected abstract int getBaseDuration();

    protected abstract int getEffectAmplifier();

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        ItemProperties.register((Item)this, (ResourceLocation)new ResourceLocation("use_count"), (stack, level, entity, seed) -> {
            if (stack.m_41782_() && stack.m_41783_().m_128441_(USE_COUNT_TAG)) {
                return stack.m_41783_().m_128451_(USE_COUNT_TAG);
            }
            return 0.0f;
        });
    }
}

