/*
 * Decompiled with CFR 0.152.
 */
package com.fxd927.mekanismelements.api.recipes.cache;

import com.fxd927.mekanismelements.api.recipes.RadiationIrradiatingRecipe;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.LongSupplier;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.ILongInputHandler;
import mekanism.api.recipes.outputs.BoxedChemicalOutputHandler;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class RadiationIrradiatingCachedRecipe
extends CachedRecipe<RadiationIrradiatingRecipe> {
    private final BoxedChemicalOutputHandler outputHandler;
    private final IInputHandler<@NotNull ItemStack> itemInputHandler;
    private final ILongInputHandler<@NotNull GasStack> gasInputHandler;
    private final LongSupplier gasUsage;
    private long gasUsageMultiplier;
    private ItemStack recipeItem = ItemStack.f_41583_;
    private GasStack recipeGas = GasStack.EMPTY;
    private BoxedChemicalStack output = BoxedChemicalStack.EMPTY;

    public RadiationIrradiatingCachedRecipe(RadiationIrradiatingRecipe recipe, BooleanSupplier recheckAllErrors, IInputHandler<@NotNull ItemStack> itemInputHandler, ILongInputHandler<@NotNull GasStack> gasInputHandler, LongSupplier gasUsage, BoxedChemicalOutputHandler outputHandler) {
        super((MekanismRecipe)recipe, recheckAllErrors);
        this.itemInputHandler = Objects.requireNonNull(itemInputHandler, "Item input handler cannot be null.");
        this.gasInputHandler = Objects.requireNonNull(gasInputHandler, "Gas input handler cannot be null.");
        this.gasUsage = Objects.requireNonNull(gasUsage, "Gas usage cannot be null.");
        this.outputHandler = Objects.requireNonNull(outputHandler, "Input handler cannot be null.");
    }

    protected void setupVariableValues() {
        this.gasUsageMultiplier = Math.max(this.gasUsage.getAsLong(), 0L);
    }

    protected void calculateOperationsThisTick(CachedRecipe.OperationTracker tracker) {
        super.calculateOperationsThisTick(tracker);
        if (tracker.shouldContinueChecking()) {
            this.recipeItem = (ItemStack)this.itemInputHandler.getRecipeInput((InputIngredient)((RadiationIrradiatingRecipe)this.recipe).getItemInput());
            if (this.recipeItem.m_41619_()) {
                tracker.mismatchedRecipe();
            } else {
                this.recipeGas = (GasStack)this.gasInputHandler.getRecipeInput((InputIngredient)((RadiationIrradiatingRecipe)this.recipe).getGasInput());
                if (this.recipeGas.isEmpty()) {
                    tracker.updateOperations(0);
                    if (!tracker.shouldContinueChecking()) {
                        return;
                    }
                }
                this.itemInputHandler.calculateOperationsCanSupport(tracker, (Object)this.recipeItem);
                if (!this.recipeGas.isEmpty() && tracker.shouldContinueChecking()) {
                    this.gasInputHandler.calculateOperationsCanSupport(tracker, (Object)this.recipeGas, this.gasUsageMultiplier);
                    if (tracker.shouldContinueChecking()) {
                        this.output = ((RadiationIrradiatingRecipe)this.recipe).getOutput(this.recipeItem, this.recipeGas);
                        this.outputHandler.calculateOperationsRoomFor(tracker, this.output);
                    }
                }
            }
        }
    }

    public boolean isInputValid() {
        GasStack gasStack;
        ItemStack itemInput = (ItemStack)this.itemInputHandler.getInput();
        if (!itemInput.m_41619_() && !(gasStack = (GasStack)this.gasInputHandler.getInput()).isEmpty() && ((RadiationIrradiatingRecipe)this.recipe).test(itemInput, gasStack)) {
            GasStack recipeGas = (GasStack)this.gasInputHandler.getRecipeInput((InputIngredient)((RadiationIrradiatingRecipe)this.recipe).getGasInput());
            return !recipeGas.isEmpty() && gasStack.getAmount() >= recipeGas.getAmount();
        }
        return false;
    }

    protected void useResources(int operations) {
        super.useResources(operations);
        if (this.gasUsageMultiplier <= 0L) {
            return;
        }
        if (this.recipeGas.isEmpty()) {
            return;
        }
        this.gasInputHandler.use((Object)this.recipeGas, (long)operations * this.gasUsageMultiplier);
    }

    protected void finishProcessing(int operations) {
        if (!(this.recipeItem.m_41619_() || this.recipeGas.isEmpty() || this.output.isEmpty())) {
            this.itemInputHandler.use((Object)this.recipeItem, operations);
            if (this.gasUsageMultiplier > 0L) {
                this.gasInputHandler.use((Object)this.recipeGas, (long)operations * this.gasUsageMultiplier);
            }
            this.outputHandler.handleOutput(this.output, operations);
        }
    }
}

