/*
 * Decompiled with CFR 0.152.
 */
package com.fxd927.mekanismelements.api.recipes.cache;

import com.fxd927.mekanismelements.api.recipes.AdsorptionRecipe;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.outputs.BoxedChemicalOutputHandler;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class AdsorptionCachedRecipe
extends CachedRecipe<AdsorptionRecipe> {
    private final BoxedChemicalOutputHandler outputHandler;
    private final IInputHandler<@NotNull ItemStack> itemInputHandler;
    private final IInputHandler<@NotNull FluidStack> fluidInputHandler;
    private final IntSupplier fluidUsage;
    private int fluidUsageMultiplier;
    private ItemStack recipeItem = ItemStack.f_41583_;
    private FluidStack recipeFluid = FluidStack.EMPTY;
    private BoxedChemicalStack output = BoxedChemicalStack.EMPTY;

    public AdsorptionCachedRecipe(AdsorptionRecipe recipe, BooleanSupplier recheckAllErrors, IInputHandler<@NotNull ItemStack> itemInputHandler, IInputHandler<@NotNull FluidStack> fluidInputHandler, IntSupplier fluidUsage, BoxedChemicalOutputHandler outputHandler) {
        super((MekanismRecipe)recipe, recheckAllErrors);
        this.itemInputHandler = Objects.requireNonNull(itemInputHandler, "Item input handler cannot be null.");
        this.fluidInputHandler = Objects.requireNonNull(fluidInputHandler, "Gas input handler cannot be null.");
        this.fluidUsage = Objects.requireNonNull(fluidUsage, "Gas usage cannot be null.");
        this.outputHandler = Objects.requireNonNull(outputHandler, "Input handler cannot be null.");
    }

    protected void setupVariableValues() {
        this.fluidUsageMultiplier = Math.max(this.fluidUsage.getAsInt(), 0);
    }

    protected void calculateOperationsThisTick(CachedRecipe.OperationTracker tracker) {
        super.calculateOperationsThisTick(tracker);
        if (tracker.shouldContinueChecking()) {
            this.recipeItem = (ItemStack)this.itemInputHandler.getRecipeInput((InputIngredient)((AdsorptionRecipe)this.recipe).getItemInput());
            if (this.recipeItem.m_41619_()) {
                tracker.mismatchedRecipe();
            } else {
                this.recipeFluid = (FluidStack)this.fluidInputHandler.getRecipeInput((InputIngredient)((AdsorptionRecipe)this.recipe).getFluidInput());
                if (this.recipeFluid.isEmpty()) {
                    tracker.updateOperations(0);
                    if (!tracker.shouldContinueChecking()) {
                        return;
                    }
                }
                this.itemInputHandler.calculateOperationsCanSupport(tracker, (Object)this.recipeItem);
                if (!this.recipeFluid.isEmpty() && tracker.shouldContinueChecking()) {
                    this.fluidInputHandler.calculateOperationsCanSupport(tracker, (Object)this.recipeFluid, this.fluidUsageMultiplier);
                    if (tracker.shouldContinueChecking()) {
                        this.output = ((AdsorptionRecipe)this.recipe).getOutput(this.recipeItem, this.recipeFluid);
                        this.outputHandler.calculateOperationsRoomFor(tracker, this.output);
                    }
                }
            }
        }
    }

    public boolean isInputValid() {
        FluidStack fluidStack;
        ItemStack itemInput = (ItemStack)this.itemInputHandler.getInput();
        if (!itemInput.m_41619_() && !(fluidStack = (FluidStack)this.fluidInputHandler.getInput()).isEmpty() && ((AdsorptionRecipe)this.recipe).test(itemInput, fluidStack)) {
            FluidStack recipeFluid = (FluidStack)this.fluidInputHandler.getRecipeInput((InputIngredient)((AdsorptionRecipe)this.recipe).getFluidInput());
            return !recipeFluid.isEmpty() && fluidStack.getAmount() >= recipeFluid.getAmount();
        }
        return false;
    }

    protected void useResources(int operations) {
        super.useResources(operations);
        if (this.fluidUsageMultiplier <= 0) {
            return;
        }
        if (this.recipeFluid.isEmpty()) {
            return;
        }
        this.fluidInputHandler.use((Object)this.recipeFluid, operations * this.fluidUsageMultiplier);
    }

    protected void finishProcessing(int operations) {
        if (!(this.recipeItem.m_41619_() || this.recipeFluid.isEmpty() || this.output.isEmpty())) {
            if (this.fluidUsageMultiplier > 0) {
                this.fluidInputHandler.use((Object)this.recipeFluid, operations * this.fluidUsageMultiplier);
            }
            this.outputHandler.handleOutput(this.output, operations);
        }
    }
}

