/*
 * Decompiled with CFR 0.152.
 */
package com.fxd927.mekanismelements.api.recipes;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Contract;

@NothingNullByDefault
public abstract class ChemicalDemolitionRecipe
extends MekanismRecipe
implements BiPredicate<ItemStack, GasStack> {
    private final ItemStackIngredient itemInput;
    private final ChemicalStackIngredient.GasStackIngredient gasInput;
    private final ItemStack firstOutput;
    private final ItemStack secondOutput;

    public ChemicalDemolitionRecipe(ResourceLocation id, ItemStackIngredient itemInput, ChemicalStackIngredient.GasStackIngredient gasInput, ItemStack firstOutput, ItemStack secondOutput) {
        super(id);
        this.itemInput = Objects.requireNonNull(itemInput, "Item input cannot be null.");
        this.gasInput = Objects.requireNonNull(gasInput, "Gas input cannot be null.");
        Objects.requireNonNull(firstOutput, "Output cannot be null.");
        if (firstOutput.m_41619_()) {
            throw new IllegalArgumentException("Output cannot be empty.");
        }
        if (secondOutput.m_41619_()) {
            throw new IllegalArgumentException("Output cannot be empty.");
        }
        this.firstOutput = firstOutput.m_41777_();
        this.secondOutput = secondOutput.m_41777_();
    }

    public ItemStackIngredient getItemInput() {
        return this.itemInput;
    }

    public ChemicalStackIngredient.GasStackIngredient getGasInput() {
        return this.gasInput;
    }

    @Contract(value="_, _ -> new", pure=true)
    public ItemStack getFirstOutput(ItemStack inputItem, GasStack inputGas) {
        return this.firstOutput.m_41777_();
    }

    @Contract(value="_, _ -> new", pure=true)
    public ItemStack getSecondOutput(ItemStack inputItem, GasStack inputGas) {
        return this.secondOutput.m_41777_();
    }

    @Override
    public boolean test(ItemStack itemStack, GasStack gasStack) {
        return this.itemInput.test((Object)itemStack) && this.gasInput.test((Object)gasStack);
    }

    public List<ItemStack> getFirstOutputDefinition() {
        return Collections.singletonList(this.firstOutput);
    }

    public List<ItemStack> getSecondOutputDefinition() {
        return Collections.singletonList(this.secondOutput);
    }

    public boolean m_142505_() {
        return this.itemInput.hasNoMatchingInstances() || this.gasInput.hasNoMatchingInstances();
    }

    public void write(FriendlyByteBuf buffer) {
        this.itemInput.write(buffer);
        this.gasInput.write(buffer);
        buffer.m_130055_(this.firstOutput);
        buffer.m_130055_(this.secondOutput);
    }
}

