/*
 * Decompiled with CFR 0.152.
 */
package tech.mcsp.mcsp.entity.projectile;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.entity.projectile.ExplosiveProjectile;
import com.atsuishio.superbwarfare.entity.projectile.FastThrowableProjectile;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.PlayMessages;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;
import tech.mcsp.mcsp.init.ModEntities;

public class McspSmallCannonShellEntity
extends FastThrowableProjectile
implements GeoEntity,
ExplosiveProjectile {
    private float damage = 40.0f;
    private float explosionDamage = 80.0f;
    private float explosionRadius = 5.0f;
    private boolean aa;
    private float gravity = 0.03f;
    private Explosion.BlockInteraction blockInteraction;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public McspSmallCannonShellEntity(EntityType<? extends McspSmallCannonShellEntity> type, Level world) {
        super(type, world);
        this.f_19811_ = true;
    }

    public McspSmallCannonShellEntity(LivingEntity entity, Level level, float damage, float explosionDamage, float explosionRadius, boolean aa) {
        super((EntityType)ModEntities.MCSP_SMALL_CANNON_SHELL.get(), (Entity)entity, level);
        this.f_19811_ = true;
        this.damage = damage;
        this.explosionDamage = explosionDamage;
        this.explosionRadius = explosionRadius;
        this.aa = aa;
        if (aa) {
            this.crushProjectile(this.m_20184_());
        }
    }

    public McspSmallCannonShellEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType<? extends McspSmallCannonShellEntity>)((EntityType)ModEntities.MCSP_SMALL_CANNON_SHELL.get()), level);
    }

    public McspSmallCannonShellEntity setBlockInteraction(Explosion.BlockInteraction blockInteraction) {
        this.blockInteraction = blockInteraction;
        return this;
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128350_("Damage", this.damage);
        pCompound.m_128350_("ExplosionDamage", this.explosionDamage);
        pCompound.m_128350_("Radius", this.explosionRadius);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("Damage")) {
            this.damage = pCompound.m_128457_("Damage");
        }
        if (pCompound.m_128441_("ExplosionDamage")) {
            this.explosionDamage = pCompound.m_128457_("ExplosionDamage");
        }
        if (pCompound.m_128441_("Radius")) {
            this.explosionRadius = pCompound.m_128457_("Radius");
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected Item m_7881_() {
        return (Item)ModItems.SMALL_SHELL.get();
    }

    public boolean m_6783_(double pDistance) {
        return true;
    }

    protected void m_5790_(EntityHitResult result) {
        Entity entity = result.m_82443_();
        if (this.m_19749_() != null && this.m_19749_().m_20202_() != null && entity == this.m_19749_().m_20202_()) {
            return;
        }
        if (this.m_9236_() instanceof ServerLevel) {
            LivingEntity living;
            Entity entity2 = this.m_19749_();
            if (entity2 instanceof LivingEntity && !(living = (LivingEntity)entity2).m_9236_().m_5776_() && living instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)living;
                living.m_9236_().m_5594_(null, living.m_20183_(), (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 1.0f, 1.0f);
                Mod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientIndicatorMessage(0, 5));
            }
            DamageHandler.doDamage((Entity)entity, (DamageSource)ModDamageTypes.causeProjectileHitDamage((RegistryAccess)this.m_9236_().m_9598_(), (Entity)this, (Entity)this.m_19749_()), (float)this.damage);
            if (entity instanceof LivingEntity) {
                entity.f_19802_ = 0;
            }
            if (this.f_19797_ > 0) {
                this.causeExplode(result.m_82450_(), true);
            }
            this.m_146870_();
        }
    }

    public void m_8060_(BlockHitResult blockHitResult) {
        Block block;
        float hardness;
        BlockPos resultPos = blockHitResult.m_82425_();
        BlockState state = this.m_9236_().m_8055_(resultPos);
        if (this.m_9236_() instanceof ServerLevel && (hardness = this.m_9236_().m_8055_(resultPos).m_60734_().m_155943_()) != -1.0f && ((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue() && this.blockInteraction == null) {
            boolean destroy;
            boolean bl = destroy = Math.random() < Mth.m_14008_((double)(1.0f - hardness / 50.0f), (double)0.1, (double)1.0);
            if (destroy) {
                this.m_9236_().m_46961_(resultPos, true);
            }
        }
        if ((block = state.m_60734_()) instanceof BellBlock) {
            BellBlock bell = (BellBlock)block;
            bell.m_49712_(this.m_9236_(), resultPos, blockHitResult.m_82434_());
        }
        if (this.m_9236_() instanceof ServerLevel) {
            this.causeExplode(blockHitResult.m_82450_(), false);
        }
        this.m_146870_();
    }

    private void causeExplode(Vec3 vec3, boolean hitEntity) {
        CustomExplosion explosion = new CustomExplosion(this.m_9236_(), (Entity)this, ModDamageTypes.causeCustomExplosionDamage((RegistryAccess)this.m_9236_().m_9598_(), (Entity)this, (Entity)this.m_19749_()), this.explosionDamage, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, this.explosionRadius, hitEntity ? Explosion.BlockInteraction.KEEP : (((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue() ? (this.blockInteraction != null ? this.blockInteraction : Explosion.BlockInteraction.DESTROY) : Explosion.BlockInteraction.KEEP)).setDamageMultiplier(1.25f);
        explosion.m_46061_();
        ForgeEventFactory.onExplosionStart((Level)this.m_9236_(), (Explosion)explosion);
        explosion.m_46075_(false);
        ParticleTool.spawnSmallExplosionParticles((Level)this.m_9236_(), (Vec3)vec3);
    }

    public void m_8119_() {
        Level level;
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ParticleTool.sendParticle((ServerLevel)serverLevel, (ParticleOptions)ParticleTypes.f_123762_, (double)this.f_19854_, (double)this.f_19855_, (double)this.f_19856_, (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.02, (boolean)true);
        }
        if (this.m_20096_()) {
            this.m_20334_(0.0, 0.0, 0.0);
        }
        if (this.f_19797_ > 200 || this.m_20069_()) {
            if (this.m_9236_() instanceof ServerLevel && !this.m_20096_()) {
                this.causeExplode(this.m_20182_(), false);
            }
            this.m_146870_();
        }
        if (this.aa) {
            this.crushProjectile(this.m_20184_());
        }
    }

    public void crushProjectile(Vec3 velocity) {
        if (this.m_9236_() instanceof ServerLevel) {
            AABB frontBox = this.m_20191_().m_82400_(0.5).m_82369_(velocity);
            Optional<Projectile> target = this.m_9236_().m_142425_(EntityTypeTest.m_156916_(Projectile.class), frontBox, entity -> entity != this).stream().filter(entity -> (double)entity.m_20205_() >= 0.3 || (double)entity.m_20206_() >= 0.3).min(Comparator.comparingDouble(e -> e.m_20182_().m_82554_(this.m_20182_())));
            if (target.isPresent()) {
                this.causeExplode(target.get().m_20182_(), false);
                target.get().m_146870_();
                this.m_146870_();
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public void setExplosionDamage(float explosionDamage) {
        this.explosionDamage = explosionDamage;
    }

    public void setExplosionRadius(float radius) {
        this.explosionRadius = radius;
    }

    public float m_7139_() {
        return this.gravity;
    }

    public void setGravity(float gravity) {
        this.gravity = gravity;
    }
}

