/*
 * Decompiled with CFR 0.152.
 */
package tech.mcsp.mcsp.entity;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.entity.OBBEntity;
import com.atsuishio.superbwarfare.entity.projectile.CannonShellEntity;
import com.atsuishio.superbwarfare.entity.projectile.ProjectileEntity;
import com.atsuishio.superbwarfare.entity.projectile.WgMissileEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ContainerMobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.LandArmorEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ThirdPersonCameraPosition;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.WeaponVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.CannonShellWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.ProjectileWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.VehicleWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.WgMissileWeapon;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.network.message.receive.ShakeClientMessage;
import com.atsuishio.superbwarfare.tools.Ammo;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.atsuishio.superbwarfare.tools.MathTool;
import com.atsuishio.superbwarfare.tools.OBB;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.SoundTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.io.Serializable;
import java.util.List;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import tech.mcsp.mcsp.init.ModEntities;
import tech.mcsp.mcsp.init.ModSounds;

public class SprutEntity
extends ContainerMobileVehicleEntity
implements GeoEntity,
LandArmorEntity,
WeaponVehicleEntity,
OBBEntity {
    public static final EntityDataAccessor<Integer> MG_AMMO = SynchedEntityData.m_135353_(SprutEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> LOADED_AP = SynchedEntityData.m_135353_(SprutEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> LOADED_HE = SynchedEntityData.m_135353_(SprutEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> LOADED_AMMO_TYPE = SynchedEntityData.m_135353_(SprutEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> GUN_FIRE_TIME = SynchedEntityData.m_135353_(SprutEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> LOADED_DRONE = SynchedEntityData.m_135353_(SprutEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> MISSILE_INTER_DELAY = SynchedEntityData.m_135353_(SprutEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int droneReloadCoolDown;
    private int missileDelay;
    public OBB obb = new OBB(this.m_20182_().m_252839_(), new Vector3f(2.0f, 0.469f, 3.969f), new Quaternionf(), OBB.Part.BODY);
    public OBB obb2 = new OBB(this.m_20182_().m_252839_(), new Vector3f(1.438f, 0.375f, 3.688f), new Quaternionf(), OBB.Part.BODY);
    public OBB obb3 = new OBB(this.m_20182_().m_252839_(), new Vector3f(1.813f, 0.344f, 0.438f), new Quaternionf(), OBB.Part.BODY);
    public OBB obb4 = new OBB(this.m_20182_().m_252839_(), new Vector3f(1.4375f, 0.46875f, 1.4375f), new Quaternionf(), OBB.Part.TURRET);
    public OBB obb5 = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.25f, 0.688f, 3.906f), new Quaternionf(), OBB.Part.WHEEL_LEFT);
    public OBB obb6 = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.25f, 0.688f, 3.906f), new Quaternionf(), OBB.Part.WHEEL_RIGHT);
    private static final float MG_OFFSET_X = -0.35f;
    private static final float MG_OFFSET_Y = 0.05f;
    private static final float MG_OFFSET_Z = 0.9f;

    public SprutEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<SprutEntity>)((EntityType)ModEntities.SPRUT.get()), world);
    }

    public SprutEntity(EntityType<SprutEntity> type, Level world) {
        super(type, world);
    }

    public float turretYSpeed() {
        return 6.0f;
    }

    public float turretXSpeed() {
        return 5.0f;
    }

    public static SprutEntity clientSpawn(PlayMessages.SpawnEntity packet, Level world) {
        EntityType entityTypeFromPacket = (EntityType)BuiltInRegistries.f_256780_.m_7942_(packet.getTypeId());
        if (entityTypeFromPacket == null) {
            Mod.LOGGER.error("Failed to create entity from packet: Unknown entity type id: " + packet.getTypeId());
            return null;
        }
        if (!(entityTypeFromPacket instanceof EntityType)) {
            Mod.LOGGER.error("Retrieved EntityType is not an instance of EntityType<?> for id: " + packet.getTypeId());
            return null;
        }
        EntityType castedEntityType = entityTypeFromPacket;
        SprutEntity entity = new SprutEntity((EntityType<SprutEntity>)castedEntityType, world);
        return entity;
    }

    public VehicleWeapon[][] initWeapons() {
        return new VehicleWeapon[][]{{new CannonShellWeapon().hitDamage((float)((Integer)VehicleConfig.YX_100_AP_CANNON_DAMAGE.get()).intValue()).explosionRadius(((Double)VehicleConfig.YX_100_AP_CANNON_EXPLOSION_RADIUS.get()).floatValue()).explosionDamage((float)((Integer)VehicleConfig.YX_100_AP_CANNON_EXPLOSION_DAMAGE.get()).intValue()).fireProbability(0.0f).fireTime(0).durability(100).velocity(40.0f).gravity(0.1f).sound((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.INTO_MISSILE.get()).ammo((Item)ModItems.AP_5_INCHES.get()).icon(new ResourceLocation("mcsp", "textures/icon_gun/ap.png")).sound1p((SoundEvent)ModSounds.M1128_3P.get()).sound3p((SoundEvent)ModSounds.M1128_3P.get()).sound3pFar((SoundEvent)ModSounds.M1128_FAR.get()).sound3pVeryFar((SoundEvent)ModSounds.M1128_VERYFAR.get()), new CannonShellWeapon().hitDamage((float)((Integer)VehicleConfig.YX_100_HE_CANNON_DAMAGE.get()).intValue()).explosionRadius(((Double)VehicleConfig.YX_100_HE_CANNON_EXPLOSION_RADIUS.get()).floatValue()).explosionDamage((float)((Integer)VehicleConfig.YX_100_HE_CANNON_EXPLOSION_DAMAGE.get()).intValue()).fireProbability(0.18f).fireTime(2).durability(1).velocity(25.0f).gravity(0.1f).sound((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.INTO_CANNON.get()).ammo((Item)ModItems.HE_5_INCHES.get()).icon(new ResourceLocation("mcsp", "textures/icon_gun/he.png")).sound1p((SoundEvent)ModSounds.M1128_3P.get()).sound3p((SoundEvent)ModSounds.M1128_3P.get()).sound3pFar((SoundEvent)ModSounds.M1128_FAR.get()).sound3pVeryFar((SoundEvent)ModSounds.M1128_VERYFAR.get()), new ProjectileWeapon().damage(9.5f).headShot(2.0f).zoom(false).ammo((Item)ModItems.HEAVY_AMMO.get()).sound((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.INTO_CANNON.get()).icon(new ResourceLocation("mcsp", "textures/icon_gun/7.62mm.png")).sound1p((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.COAX_FIRE_1P.get()).sound3p((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.M_60_FIRE_3P.get()).sound3pFar((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.M_60_FAR.get()).sound3pVeryFar((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.M_60_VERYFAR.get()), new WgMissileWeapon().damage((float)((Integer)ExplosionConfig.WIRE_GUIDE_MISSILE_DAMAGE.get()).intValue()).explosionDamage((float)((Integer)ExplosionConfig.WIRE_GUIDE_MISSILE_EXPLOSION_DAMAGE.get()).intValue()).explosionRadius((float)((Integer)ExplosionConfig.WIRE_GUIDE_MISSILE_EXPLOSION_RADIUS.get()).intValue()).sound((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.INTO_MISSILE.get()).icon(new ResourceLocation("mcsp", "textures/icon_gun/arkan.png")).sound1p((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.BMP_MISSILE_FIRE_1P.get()).sound3p((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.BMP_MISSILE_FIRE_3P.get())}, new VehicleWeapon[0]};
    }

    public ThirdPersonCameraPosition getThirdPersonCameraPosition(int index) {
        return switch (index) {
            case 0 -> new ThirdPersonCameraPosition(5.0 + ClientMouseHandler.custom3pDistanceLerp, 1.5, -0.8669625);
            case 1 -> new ThirdPersonCameraPosition(-1.0 + 0.5 * ClientMouseHandler.custom3pDistanceLerp, 0.5, 0.0);
            default -> null;
        };
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MG_AMMO, (Object)0);
        this.f_19804_.m_135372_(LOADED_AP, (Object)0);
        this.f_19804_.m_135372_(LOADED_HE, (Object)0);
        this.f_19804_.m_135372_(LOADED_DRONE, (Object)0);
        this.f_19804_.m_135372_(LOADED_AMMO_TYPE, (Object)0);
        this.f_19804_.m_135372_(GUN_FIRE_TIME, (Object)0);
        this.f_19804_.m_135372_(MISSILE_INTER_DELAY, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("LoadedAP", ((Integer)this.f_19804_.m_135370_(LOADED_AP)).intValue());
        compound.m_128405_("LoadedHE", ((Integer)this.f_19804_.m_135370_(LOADED_HE)).intValue());
        compound.m_128405_("LoadedDrone", ((Integer)this.f_19804_.m_135370_(LOADED_DRONE)).intValue());
        compound.m_128405_("LoadedAmmoType", ((Integer)this.f_19804_.m_135370_(LOADED_AMMO_TYPE)).intValue());
        compound.m_128405_("MissileInterDelay", ((Integer)this.f_19804_.m_135370_(MISSILE_INTER_DELAY)).intValue());
        compound.m_128405_("WeaponType", this.getWeaponIndex(0));
        compound.m_128405_("PassengerWeaponType", this.getWeaponIndex(1));
        compound.m_128405_("ThirdPassengerWeaponType", this.getWeaponIndex(2));
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(LOADED_AP, (Object)compound.m_128451_("LoadedAP"));
        this.f_19804_.m_135381_(LOADED_HE, (Object)compound.m_128451_("LoadedHE"));
        this.f_19804_.m_135381_(LOADED_DRONE, (Object)compound.m_128451_("LoadedDrone"));
        this.f_19804_.m_135381_(LOADED_AMMO_TYPE, (Object)compound.m_128451_("LoadedAmmoType"));
        this.f_19804_.m_135381_(MISSILE_INTER_DELAY, (Object)compound.m_128451_("MissileInterDelay"));
        this.setWeaponIndex(0, compound.m_128451_("WeaponType"));
        this.setWeaponIndex(1, compound.m_128451_("PassengerWeaponType"));
        this.setWeaponIndex(2, compound.m_128451_("ThirdPassengerWeaponType"));
    }

    public DamageModifier getDamageModifier() {
        return super.getDamageModifier().custom((source, damage) -> Float.valueOf(this.getSourceAngle((DamageSource)source, 0.4f) * damage.floatValue()));
    }

    protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        this.m_5496_((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.WHEEL_STEP.get(), (float)(this.m_20184_().m_82553_() * 0.15), this.f_19796_.m_188501_() * 0.15f + 1.05f);
    }

    public void m_6075_() {
        Entity entity;
        Entity entity2;
        super.m_6075_();
        this.updateOBB();
        if (this.getLeftTrack() < 0.0f) {
            this.setLeftTrack(80.0f);
        }
        if (this.getLeftTrack() > 80.0f) {
            this.setLeftTrack(0.0f);
        }
        if (this.getRightTrack() < 0.0f) {
            this.setRightTrack(80.0f);
        }
        if (this.getRightTrack() > 80.0f) {
            this.setRightTrack(0.0f);
        }
        if ((Integer)this.f_19804_.m_135370_(GUN_FIRE_TIME) > 0) {
            this.f_19804_.m_135381_(GUN_FIRE_TIME, (Object)((Integer)this.f_19804_.m_135370_(GUN_FIRE_TIME) - 1));
        }
        if (this.reloadCoolDown == 60 && (entity2 = this.m_146895_()) instanceof Player) {
            Player player = (Player)entity2;
            SoundTool.playLocalSound((Player)player, (SoundEvent)((SoundEvent)ModSounds.M1128_RELOAD.get()));
        }
        if (this.m_9236_() instanceof ServerLevel) {
            boolean hasCreativeAmmo = false;
            for (int i = 0; i < this.getMaxPassengers(); ++i) {
                Player pPlayer;
                entity = this.getNthEntity(i);
                if (!(entity instanceof Player) || !InventoryTool.hasCreativeAmmoBox((Entity)(pPlayer = (Player)entity))) continue;
                hasCreativeAmmo = true;
            }
            if (this.reloadCoolDown > 0 && ((Integer)this.f_19804_.m_135370_(LOADED_AMMO_TYPE) == 0 && (hasCreativeAmmo || this.m_18947_((Item)ModItems.AP_5_INCHES.get()) > 0) || (Integer)this.f_19804_.m_135370_(LOADED_AMMO_TYPE) == 1 && (hasCreativeAmmo || this.m_18947_((Item)ModItems.HE_5_INCHES.get()) > 0))) {
                --this.reloadCoolDown;
            }
            this.handleAmmo();
            if (this.missileDelay > 0) {
                --this.missileDelay;
            }
            this.f_19804_.m_135381_(MISSILE_INTER_DELAY, (Object)this.missileDelay);
        }
        double fluidFloat = 0.052 * SprutEntity.getSubmergedHeight((Entity)this);
        this.m_20256_(this.m_20184_().m_82520_(0.0, fluidFloat, 0.0));
        if (this.m_20096_()) {
            float f0 = 0.54f + 0.25f * Mth.m_14154_((float)(90.0f - (float)SprutEntity.calculateAngle((Vec3)this.m_20184_(), (Vec3)this.m_20252_(1.0f)))) / 90.0f;
            this.m_20256_(this.m_20184_().m_82549_(this.m_20252_(1.0f).m_82541_().m_82490_(0.05 * this.m_20184_().m_82526_(this.m_20252_(1.0f)))));
            this.m_20256_(this.m_20184_().m_82542_((double)f0, 0.99, (double)f0));
        } else {
            this.m_20256_(this.m_20184_().m_82542_(0.99, 0.99, 0.99));
        }
        if (this.m_20069_()) {
            float f1 = (float)((double)0.7f - (double)0.04f * Math.min((double)SprutEntity.getSubmergedHeight((Entity)this), (double)this.m_20206_()) + (double)(0.08f * Mth.m_14154_((float)(90.0f - (float)SprutEntity.calculateAngle((Vec3)this.m_20184_(), (Vec3)this.m_20252_(1.0f)))) / 90.0f));
            this.m_20256_(this.m_20184_().m_82549_(this.m_20252_(1.0f).m_82541_().m_82490_(0.04 * this.m_20184_().m_82526_(this.m_20252_(1.0f)))));
            this.m_20256_(this.m_20184_().m_82542_((double)f1, 0.85, (double)f1));
        }
        if ((entity = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)entity;
            if (this.m_20069_() && this.m_20184_().m_82553_() > 0.1) {
                ParticleTool.sendParticle((ServerLevel)serverLevel, (ParticleOptions)ParticleTypes.f_123796_, (double)(this.m_20185_() + 0.5 * this.m_20184_().f_82479_), (double)(this.m_20186_() + SprutEntity.getSubmergedHeight((Entity)this) - 0.2), (double)(this.m_20189_() + 0.5 * this.m_20184_().f_82481_), (int)((int)(2.0 + 4.0 * this.m_20184_().m_82553_())), (double)0.65, (double)0.0, (double)0.65, (double)0.0, (boolean)true);
                ParticleTool.sendParticle((ServerLevel)serverLevel, (ParticleOptions)ParticleTypes.f_123774_, (double)(this.m_20185_() + 0.5 * this.m_20184_().f_82479_), (double)(this.m_20186_() + SprutEntity.getSubmergedHeight((Entity)this) - 0.2), (double)(this.m_20189_() + 0.5 * this.m_20184_().f_82481_), (int)((int)(2.0 + 10.0 * this.m_20184_().m_82553_())), (double)0.65, (double)0.0, (double)0.65, (double)0.0, (boolean)true);
            }
        }
        this.releaseSmokeDecoy(this.getTurretVector(1.0f));
    }

    public boolean canCollideHardBlock() {
        return this.m_20184_().m_165924_() > 0.05 || (double)Mth.m_14154_((float)((Float)this.f_19804_.m_135370_(POWER)).floatValue()) > 0.1;
    }

    public boolean canCollideBlockBeastly() {
        return this.m_20184_().m_165924_() > 0.3;
    }

    private void handleAmmo() {
        if (this.getWeaponIndex(0) == 0 || this.getWeaponIndex(0) == 1) {
            this.f_19804_.m_135381_(LOADED_AMMO_TYPE, (Object)this.getWeaponIndex(0));
        }
        boolean hasCreativeAmmo = false;
        for (int i = 0; i < this.getMaxPassengers(); ++i) {
            Player pPlayer;
            Entity entity = this.getNthEntity(i);
            if (!(entity instanceof Player) || !InventoryTool.hasCreativeAmmoBox((Entity)(pPlayer = (Player)entity))) continue;
            hasCreativeAmmo = true;
        }
        int heavyAmmoCount = this.m_213659_().stream().filter(stack -> {
            if (stack.m_150930_((Item)ModItems.AMMO_BOX.get())) {
                return Ammo.HEAVY.get(stack) > 0;
            }
            return false;
        }).mapToInt(arg_0 -> ((Ammo)Ammo.HEAVY).get(arg_0)).sum() + this.m_18947_((Item)ModItems.HEAVY_AMMO.get());
        this.f_19804_.m_135381_(MG_AMMO, (Object)heavyAmmoCount);
        if (((Integer)this.m_20088_().m_135370_(LOADED_AP) == 0 || (Integer)this.m_20088_().m_135370_(LOADED_HE) == 0) && this.reloadCoolDown <= 0 && (hasCreativeAmmo || (Integer)this.f_19804_.m_135370_(LOADED_AMMO_TYPE) == 0 && this.hasItem((Item)ModItems.AP_5_INCHES.get()) || (Integer)this.f_19804_.m_135370_(LOADED_AMMO_TYPE) == 1 && this.hasItem((Item)ModItems.HE_5_INCHES.get()))) {
            if ((Integer)this.f_19804_.m_135370_(LOADED_AMMO_TYPE) == 0 && (Integer)this.f_19804_.m_135370_(LOADED_AP) == 0) {
                this.f_19804_.m_135381_(LOADED_AP, (Object)1);
                if (!hasCreativeAmmo) {
                    this.consumeItem((Item)ModItems.AP_5_INCHES.get(), 1);
                }
            }
            if ((Integer)this.f_19804_.m_135370_(LOADED_AMMO_TYPE) == 1 && (Integer)this.f_19804_.m_135370_(LOADED_HE) == 0) {
                this.f_19804_.m_135381_(LOADED_HE, (Object)1);
                if (!hasCreativeAmmo) {
                    this.consumeItem((Item)ModItems.HE_5_INCHES.get(), 1);
                }
            }
        }
    }

    public void m_6478_(@NotNull MoverType movementType, @NotNull Vec3 movement) {
        super.m_6478_(movementType, movement);
        if (this.m_20069_() && this.f_19862_) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.07, 0.0));
        }
    }

    public void vehicleShoot(LivingEntity living, int type) {
        boolean hasCreativeAmmo = false;
        for (int i = 0; i < this.getMaxPassengers(); ++i) {
            Player pPlayer;
            Entity entity = this.getNthEntity(i);
            if (!(entity instanceof Player) || !InventoryTool.hasCreativeAmmoBox((Entity)(pPlayer = (Player)entity))) continue;
            hasCreativeAmmo = true;
        }
        if (type == 0) {
            if (this.getWeaponIndex(0) == 3 && this.missileDelay == 0) {
                boolean hasMissileAmmo = this.hasItem((Item)ModItems.WIRE_GUIDE_MISSILE.get());
                if (hasCreativeAmmo || hasMissileAmmo) {
                    Matrix4f transformT = this.getBarrelTransform(1.0f);
                    Vector4f worldPositionT = this.transformPosition(transformT, 0.0f, 0.0f, 0.5f);
                    WgMissileEntity wgMissileEntity = ((WgMissileWeapon)this.getWeapon(0)).create(living);
                    wgMissileEntity.m_6034_((double)worldPositionT.x, (double)worldPositionT.y, (double)worldPositionT.z);
                    wgMissileEntity.m_6686_(this.getBarrelVector((float)1.0f).f_82479_, this.getBarrelVector((float)1.0f).f_82480_, this.getBarrelVector((float)1.0f).f_82481_, 2.0f, 0.0f);
                    this.m_9236_().m_7967_((Entity)wgMissileEntity);
                    if (!this.m_9236_().f_46443_) {
                        this.playShootSound3p(living, 0, 6, 0, 0, new Vec3((double)worldPositionT.x, (double)worldPositionT.y, (double)worldPositionT.z));
                    }
                    if (!hasCreativeAmmo) {
                        this.consumeItem((Item)ModItems.WIRE_GUIDE_MISSILE.get(), 1);
                    }
                    this.missileDelay = 140;
                }
                return;
            }
            if (this.getWeaponIndex(0) == 2) {
                if (this.cannotFireCoax) {
                    return;
                }
                Matrix4f transform = this.getBarrelTransform(1.0f);
                Vector4f worldPosition = this.transformPosition(transform, -0.35f, 0.05f, 0.9f);
                ProjectileWeapon projectile = (ProjectileWeapon)this.getWeapon(0);
                ProjectileEntity projectileEntity = projectile.create(living).setGunItemId(this.m_6095_().m_20675_() + ".2");
                projectileEntity.m_6034_((double)worldPosition.x - 1.1 * this.m_20184_().f_82479_, (double)worldPosition.y, (double)worldPosition.z - 1.1 * this.m_20184_().f_82481_);
                projectileEntity.shoot(living, this.getBarrelVector((float)1.0f).f_82479_, this.getBarrelVector((float)1.0f).f_82480_ + (double)0.005f, this.getBarrelVector((float)1.0f).f_82481_, 20.0f, 0.3f);
                this.m_9236_().m_7967_((Entity)projectileEntity);
                if (!this.m_9236_().f_46443_) {
                    this.playShootSound3p(living, 1, 4, 12, 24, new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z));
                }
                this.f_19804_.m_135381_(GUN_FIRE_TIME, (Object)2);
                this.f_19804_.m_135381_(COAX_HEAT, (Object)((Integer)this.f_19804_.m_135370_(COAX_HEAT) + 3));
                ShakeClientMessage.sendToNearbyPlayers((Entity)this, (double)4.0, (double)6.0, (double)4.0, (double)6.0);
                if (hasCreativeAmmo) {
                    return;
                }
                ItemStack ammoBox = this.m_213659_().stream().filter(stack -> {
                    if (stack.m_150930_((Item)ModItems.AMMO_BOX.get())) {
                        return Ammo.HEAVY.get(stack) > 0;
                    }
                    return false;
                }).findFirst().orElse(ItemStack.f_41583_);
                if (!ammoBox.m_41619_()) {
                    Ammo.HEAVY.add(ammoBox, -1);
                } else {
                    this.m_213659_().stream().filter(stack -> stack.m_150930_((Item)ModItems.HEAVY_AMMO.get())).findFirst().ifPresent(stack -> stack.m_41774_(1));
                }
                return;
            }
            if (this.reloadCoolDown == 0 && (this.getWeaponIndex(0) == 0 || this.getWeaponIndex(0) == 1)) {
                Matrix4f transform = this.getBarrelTransform(1.0f);
                float x1 = 0.0f;
                float y2 = 0.0f;
                float z3 = 6.375f;
                Vector4f worldPosition = this.transformPosition(transform, x1, y2, z3);
                CannonShellWeapon cannonShell = (CannonShellWeapon)this.getWeapon(0);
                CannonShellEntity entityToSpawn = cannonShell.create(living);
                entityToSpawn.m_6034_((double)worldPosition.x - 1.1 * this.m_20184_().f_82479_, (double)worldPosition.y, (double)worldPosition.z - 1.1 * this.m_20184_().f_82481_);
                entityToSpawn.m_6686_(this.getBarrelVector((float)1.0f).f_82479_, this.getBarrelVector((float)1.0f).f_82480_ + (double)0.005f, this.getBarrelVector((float)1.0f).f_82481_, cannonShell.velocity, 0.02f);
                this.m_9236_().m_7967_((Entity)entityToSpawn);
                if (!this.m_9236_().f_46443_) {
                    this.playShootSound3p(living, 0, 8, 16, 32, new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z));
                }
                this.f_19804_.m_135381_(CANNON_RECOIL_TIME, (Object)40);
                if (this.getWeaponIndex(0) == 0) {
                    this.f_19804_.m_135381_(LOADED_AP, (Object)0);
                } else if (this.getWeaponIndex(0) == 1) {
                    this.f_19804_.m_135381_(LOADED_HE, (Object)0);
                }
                this.f_19804_.m_135381_(YAW, (Object)Float.valueOf(this.getTurretYRot()));
                this.reloadCoolDown = 100;
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel server = (ServerLevel)level;
                    server.m_8767_((ParticleOptions)ParticleTypes.f_123777_, this.m_20185_() + 5.0 * this.getBarrelVector((float)1.0f).f_82479_, this.m_20186_() + 0.1, this.m_20189_() + 5.0 * this.getBarrelVector((float)1.0f).f_82481_, 300, 6.0, 0.02, 6.0, 0.005);
                    double x = (double)worldPosition.x + 9.0 * this.getBarrelVector((float)1.0f).f_82479_;
                    double y = (double)worldPosition.y + 9.0 * this.getBarrelVector((float)1.0f).f_82480_;
                    double z = (double)worldPosition.z + 9.0 * this.getBarrelVector((float)1.0f).f_82481_;
                    server.m_8767_((ParticleOptions)ParticleTypes.f_123777_, x, y, z, 10, 0.4, 0.4, 0.4, 0.0075);
                    server.m_8767_((ParticleOptions)ParticleTypes.f_123796_, x, y, z, 10, 0.4, 0.4, 0.4, 0.0075);
                    int count = 6;
                    for (float i = 9.5f; i < 23.0f; i += 0.5f) {
                        server.m_8767_((ParticleOptions)ParticleTypes.f_123777_, (double)worldPosition.x + (double)i * this.getBarrelVector((float)1.0f).f_82479_, (double)worldPosition.y + (double)i * this.getBarrelVector((float)1.0f).f_82480_, (double)worldPosition.z + (double)i * this.getBarrelVector((float)1.0f).f_82481_, Mth.m_14045_((int)count--, (int)1, (int)5), 0.15, 0.15, 0.15, 0.0025);
                    }
                    Vector4f worldPositionL = this.transformPosition(transform, -0.35f, 0.0f, 0.0f);
                    Vector4f worldPositionR = this.transformPosition(transform, 0.35f, 0.0f, 0.0f);
                    for (float i = 3.0f; i < 6.0f; i += 0.5f) {
                        server.m_8767_((ParticleOptions)ParticleTypes.f_123796_, (double)worldPositionL.x + (double)i * this.getBarrelVector((float)1.0f).f_82479_, (double)worldPositionL.y + (double)i * this.getBarrelVector((float)1.0f).f_82480_, (double)worldPositionL.z + (double)i * this.getBarrelVector((float)1.0f).f_82481_, 1, 0.025, 0.025, 0.025, 0.0015);
                        server.m_8767_((ParticleOptions)ParticleTypes.f_123796_, (double)worldPositionR.x + (double)i * this.getBarrelVector((float)1.0f).f_82479_, (double)worldPositionR.y + (double)i * this.getBarrelVector((float)1.0f).f_82480_, (double)worldPositionR.z + (double)i * this.getBarrelVector((float)1.0f).f_82481_, 1, 0.025, 0.025, 0.025, 0.0015);
                    }
                }
                ShakeClientMessage.sendToNearbyPlayers((Entity)this, (double)8.0, (double)10.0, (double)8.0, (double)60.0);
            }
        }
        if (type == 1 && this.getWeaponIndex(0) == 2) {
            if (this.cannotFireCoax) {
                return;
            }
            Matrix4f transform = this.getBarrelTransform(1.0f);
            Vector4f worldPosition = this.transformPosition(transform, -0.35f, 0.05f, 0.9f);
            ProjectileWeapon projectile = (ProjectileWeapon)this.getWeapon(0);
            ProjectileEntity projectileEntity = projectile.create(living).setGunItemId(this.m_6095_().m_20675_() + ".2");
            projectileEntity.m_6034_((double)worldPosition.x - 1.1 * this.m_20184_().f_82479_, (double)worldPosition.y, (double)worldPosition.z - 1.1 * this.m_20184_().f_82481_);
            projectileEntity.shoot(living, this.getBarrelVector((float)1.0f).f_82479_, this.getBarrelVector((float)1.0f).f_82480_ + (double)0.005f, this.getBarrelVector((float)1.0f).f_82481_, 20.0f, 0.3f);
            this.m_9236_().m_7967_((Entity)projectileEntity);
            this.playShootSound3p(living, 1, 4, 12, 24, new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z));
            this.f_19804_.m_135381_(GUN_FIRE_TIME, (Object)2);
            this.f_19804_.m_135381_(COAX_HEAT, (Object)((Integer)this.f_19804_.m_135370_(COAX_HEAT) + 3));
            ShakeClientMessage.sendToNearbyPlayers((Entity)this, (double)4.0, (double)6.0, (double)4.0, (double)6.0);
            if (hasCreativeAmmo) {
                return;
            }
            ItemStack ammoBox = this.m_213659_().stream().filter(stack -> {
                if (stack.m_150930_((Item)ModItems.AMMO_BOX.get())) {
                    return Ammo.HEAVY.get(stack) > 0;
                }
                return false;
            }).findFirst().orElse(ItemStack.f_41583_);
            if (!ammoBox.m_41619_()) {
                Ammo.HEAVY.add(ammoBox, -1);
            } else {
                this.consumeItem(this.getWeapon((int)0).ammo, 1);
            }
        }
    }

    public void travel() {
        Entity passenger0 = this.m_146895_();
        if (this.getEnergy() <= 0) {
            return;
        }
        if (passenger0 == null) {
            this.leftInputDown = false;
            this.rightInputDown = false;
            this.forwardInputDown = false;
            this.backInputDown = false;
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(0.0f));
        }
        if (this.forwardInputDown) {
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.min((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() + (((Float)this.f_19804_.m_135370_(POWER)).floatValue() < 0.0f ? 0.004f : 0.0024f)), (float)0.21f)));
        }
        if (this.backInputDown) {
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.max((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() - (((Float)this.f_19804_.m_135370_(POWER)).floatValue() > 0.0f ? 0.004f : 0.0024f)), (float)-0.16f)));
            if (this.rightInputDown) {
                this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() + 0.1f));
            } else if (this.leftInputDown) {
                this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() - 0.1f));
            }
        } else if (this.rightInputDown) {
            this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() - 0.1f));
        } else if (this.leftInputDown) {
            this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() + 0.1f));
        }
        if (this.forwardInputDown || this.backInputDown) {
            this.consumeEnergy((Integer)VehicleConfig.BMP_2_ENERGY_COST.get());
        }
        this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(POWER)).floatValue() * (this.upInputDown ? 0.5f : (this.rightInputDown || this.leftInputDown ? 0.947f : 0.96f))));
        this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() * (float)Math.max((double)((double)0.76f - (double)0.1f * this.m_20184_().m_165924_()), (double)0.3)));
        double s0 = this.m_20184_().m_82526_(this.m_20252_(1.0f));
        this.setLeftWheelRot((float)((double)this.getLeftWheelRot() - 1.25 * s0 + (double)Mth.m_14036_((float)(0.75f * ((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()), (float)-5.0f, (float)5.0f)));
        this.setRightWheelRot((float)((double)this.getRightWheelRot() - 1.25 * s0 - (double)Mth.m_14036_((float)(0.75f * ((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()), (float)-5.0f, (float)5.0f)));
        this.setLeftTrack((float)((double)this.getLeftTrack() - 5.969026041820607 * s0 + Mth.m_14008_((double)(1.2566370801612687 * (double)((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()), (double)-5.0, (double)5.0)));
        this.setRightTrack((float)((double)this.getRightTrack() - 5.969026041820607 * s0 - Mth.m_14008_((double)(1.2566370801612687 * (double)((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()), (double)-5.0, (double)5.0)));
        if (((Boolean)this.f_19804_.m_135370_(L_WHEEL_DAMAGED)).booleanValue() && ((Boolean)this.f_19804_.m_135370_(R_WHEEL_DAMAGED)).booleanValue()) {
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(POWER)).floatValue() * 0.93f));
            boolean i = false;
        } else if (((Boolean)this.f_19804_.m_135370_(L_WHEEL_DAMAGED)).booleanValue()) {
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(POWER)).floatValue() * 0.975f));
            int i = 3;
        } else if (((Boolean)this.f_19804_.m_135370_(R_WHEEL_DAMAGED)).booleanValue()) {
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(POWER)).floatValue() * 0.975f));
            int i = -3;
        } else {
            boolean i = false;
        }
        if (((Boolean)this.f_19804_.m_135370_(ENGINE1_DAMAGED)).booleanValue()) {
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(POWER)).floatValue() * 0.85f));
        }
        this.m_146922_((float)((double)this.m_146908_() - (this.m_20069_() && !this.m_20096_() ? 2.5 : 6.0) * (double)((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()));
        if (this.m_20069_() || this.m_20096_()) {
            float power = ((Float)this.f_19804_.m_135370_(POWER)).floatValue() * Mth.m_14036_((float)(1.0f + (float)(s0 > 0.0 ? 1 : -1) * this.m_146909_() / 35.0f), (float)0.0f, (float)2.0f);
            this.m_20256_(this.m_20184_().m_82549_(this.m_20252_(1.0f).m_82490_((double)((!this.m_20069_() && !this.m_20096_() ? 0.13f : (this.m_20069_() && !this.m_20096_() ? 2.0f : 2.4f)) * power))));
        }
    }

    public SoundEvent getEngineSound() {
        return (SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.YX_100_ENGINE.get();
    }

    public float getEngineSoundVolume() {
        return Math.max((float)Mth.m_14154_((float)((Float)this.f_19804_.m_135370_(POWER)).floatValue()), (float)Mth.m_14154_((float)(0.1f * ((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()))) * 2.5f;
    }

    public void m_19956_(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (!this.m_20363_(passenger)) {
            return;
        }
        Matrix4f transform = this.getTurretTransform(1.0f);
        int i = this.getOrderedPassengers().indexOf(passenger);
        Vector4f worldPosition = switch (i) {
            case 0 -> this.transformPosition(transform, 0.5f, 0.0f, 0.0f);
            case 1 -> this.transformPosition(transform, 0.5f, 0.0f, 0.0f);
            case 2 -> this.transformPosition(transform, 0.5f, 0.0f, 0.0f);
            default -> throw new IllegalStateException("Unexpected value: " + i);
        };
        passenger.m_6034_((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        callback.m_20372_(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        this.copyEntityData(passenger);
    }

    public void copyEntityData(Entity entity) {
        if (entity == this.getNthEntity(0)) {
            entity.m_5618_(this.getBarrelYRot(1.0f));
        }
    }

    public Vec3 driverZoomPos(float ticks) {
        Matrix4f transform = this.getTurretTransform(ticks);
        Vector4f worldPosition = this.transformPosition(transform, 0.5f, 2.15f, 0.5f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    public int getMaxPassengers() {
        return 3;
    }

    public Vec3 getNewEyePos(float pPartialTicks) {
        Matrix4f transform = this.getTurretTransform(pPartialTicks);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    public Vec3 getBarrelVector(float pPartialTicks) {
        Matrix4f transform = this.getBarrelTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f targetPosition = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z).m_82505_(new Vec3((double)targetPosition.x, (double)targetPosition.y, (double)targetPosition.z));
    }

    public Vec3 getTurretVector(float pPartialTicks) {
        Matrix4f transform = this.getTurretTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f targetPosition = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z).m_82505_(new Vec3((double)targetPosition.x, (double)targetPosition.y, (double)targetPosition.z));
    }

    public Vec3 getGunnerVector(float pPartialTicks) {
        Matrix4f transform = this.getGunnerBarrelTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f targetPosition = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z).m_82505_(new Vec3((double)targetPosition.x, (double)targetPosition.y, (double)targetPosition.z));
    }

    public Matrix4f getBarrelTransform(float ticks) {
        Matrix4f transformT = this.getTurretTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 0.375f, 1.3125f);
        transformT.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        float a = this.getTurretYaw(ticks);
        float r = (Mth.m_14154_((float)a) - 90.0f) / 90.0f;
        float r2 = Mth.m_14154_((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
        float x = Mth.m_14179_((float)ticks, (float)this.turretXRotO, (float)this.getTurretXRot());
        float xV = Mth.m_14179_((float)ticks, (float)this.f_19860_, (float)this.m_146909_());
        float z = Mth.m_14179_((float)ticks, (float)this.prevRoll, (float)this.getRoll());
        transformT.rotate((Quaternionfc)Axis.f_252529_.m_252977_(x + r * xV + r2 * z));
        return transformT;
    }

    public Matrix4f getTurretTransform(float ticks) {
        Matrix4f transformV = this.getVehicleTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 2.125f, 0.0f);
        transformV.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        transformV.rotate((Quaternionfc)Axis.f_252436_.m_252977_(Mth.m_14179_((float)ticks, (float)this.turretYRotO, (float)this.getTurretYRot())));
        return transformV;
    }

    public Matrix4f getGunTransform(float ticks) {
        Matrix4f transformT = this.getTurretTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 1.25f, 0.0f);
        transformT.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        transformT.rotate((Quaternionfc)Axis.f_252436_.m_252977_(Mth.m_14179_((float)ticks, (float)this.gunYRotO, (float)this.getGunYRot()) - Mth.m_14179_((float)ticks, (float)this.turretYRotO, (float)this.getTurretYRot())));
        return transformT;
    }

    public Matrix4f getGunnerBarrelTransform(float ticks) {
        Matrix4f transformG = this.getGunTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 1.0f, 0.0f);
        transformG.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        float a = this.getTurretYaw(ticks);
        float r = (Mth.m_14154_((float)a) - 90.0f) / 90.0f;
        float r2 = Mth.m_14154_((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
        float x = Mth.m_14179_((float)ticks, (float)this.gunXRotO, (float)this.getGunXRot());
        float xV = Mth.m_14179_((float)ticks, (float)this.f_19860_, (float)this.m_146909_());
        float z = Mth.m_14179_((float)ticks, (float)this.prevRoll, (float)this.getRoll());
        transformG.rotate((Quaternionfc)Axis.f_252529_.m_252977_(x + r * xV + r2 * z));
        return transformG;
    }

    public float rotateYOffset() {
        return 3.5f;
    }

    protected void clampRotation(Entity entity) {
        Minecraft mc = Minecraft.m_91087_();
        if (entity.m_9236_().f_46443_ && entity == this.m_146895_()) {
            float a = this.getTurretYaw(1.0f);
            float r = (Mth.m_14154_((float)a) - 90.0f) / 90.0f;
            float r2 = Mth.m_14154_((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
            float min = -15.0f - r * this.m_146909_() - r2 * this.getRoll();
            float max = 5.0f - r * this.m_146909_() - r2 * this.getRoll();
            float f = Mth.m_14177_((float)entity.m_146909_());
            float f1 = Mth.m_14036_((float)f, (float)min, (float)max);
            entity.f_19860_ += f1 - f;
            entity.m_146926_(entity.m_146909_() + f1 - f);
            if (mc.f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
                float f2 = Mth.m_14177_((float)(entity.m_146908_() - this.getBarrelYRot(1.0f)));
                float f3 = Mth.m_14036_((float)f2, (float)-20.0f, (float)20.0f);
                entity.f_19859_ += f3 - f2;
                entity.m_146922_(entity.m_146908_() + f3 - f2);
                entity.m_5618_(this.getBarrelYRot(1.0f));
            }
        } else if (entity == this.getNthEntity(1)) {
            float a = this.getTurretYaw(1.0f);
            float r = (Mth.m_14154_((float)a) - 90.0f) / 90.0f;
            float r2 = Mth.m_14154_((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
            float min = -60.0f - r * this.m_146909_() - r2 * this.getRoll();
            float max = 10.0f - r * this.m_146909_() - r2 * this.getRoll();
            float f = Mth.m_14177_((float)entity.m_146909_());
            float f1 = Mth.m_14036_((float)f, (float)min, (float)max);
            entity.f_19860_ += f1 - f;
            entity.m_146926_(entity.m_146909_() + f1 - f);
            if (mc.f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
                float f2 = Mth.m_14177_((float)(entity.m_146908_() - this.getGunYRot(1.0f)));
                float f3 = Mth.m_14036_((float)f2, (float)-150.0f, (float)150.0f);
                entity.f_19859_ += f3 - f2;
                entity.m_146922_(entity.m_146908_() + f3 - f2);
                entity.m_5618_(entity.m_146908_());
            }
        }
    }

    public void m_7340_(@NotNull Entity entity) {
        this.clampRotation(entity);
    }

    private PlayState cannonShootPredicate(AnimationState<SprutEntity> event) {
        if ((Integer)this.f_19804_.m_135370_(CANNON_RECOIL_TIME) > 0) {
            return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.yx100.fire"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.yx100.idle"));
    }

    private PlayState coaxShootPredicate(AnimationState<SprutEntity> event) {
        if ((Integer)this.f_19804_.m_135370_(FIRE_ANIM) > 0) {
            return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.yx100.fire"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.yx100.idle"));
    }

    private PlayState gunShootPredicate(AnimationState<SprutEntity> event) {
        if ((Integer)this.f_19804_.m_135370_(GUN_FIRE_TIME) > 0) {
            return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.yx100.fire"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.yx100.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public int mainGunRpm(LivingEntity living) {
        if (living == this.getNthEntity(0)) {
            int selectedIndex = this.getWeaponIndex(0);
            if (selectedIndex == 0 || selectedIndex == 1) {
                return 15;
            }
            if (selectedIndex == 2) {
                return 750;
            }
            if (selectedIndex == 3) {
                return 240;
            }
        }
        return 240;
    }

    public boolean canShoot(LivingEntity living) {
        if (living == this.getNthEntity(0)) {
            if (this.getWeaponIndex(0) == 0) {
                return (Integer)this.f_19804_.m_135370_(LOADED_AP) > 0;
            }
            if (this.getWeaponIndex(0) == 1) {
                return (Integer)this.f_19804_.m_135370_(LOADED_HE) > 0;
            }
            if (this.getWeaponIndex(0) == 2) {
                return ((Integer)this.f_19804_.m_135370_(AMMO) > 0 || InventoryTool.hasCreativeAmmoBox((Entity)living)) && !this.cannotFireCoax;
            }
            if (this.getWeaponIndex(0) == 3) {
                return this.reloadCoolDown == 0 && (Integer)this.f_19804_.m_135370_(MISSILE_INTER_DELAY) == 0 && (InventoryTool.hasCreativeAmmoBox((Entity)living) || this.hasItem((Item)ModItems.WIRE_GUIDE_MISSILE.get()));
            }
        }
        return false;
    }

    public int getAmmoCount(LivingEntity living) {
        if (living == this.getNthEntity(0)) {
            if (this.getWeaponIndex(0) == 0) {
                return (Integer)this.f_19804_.m_135370_(LOADED_AP);
            }
            if (this.getWeaponIndex(0) == 1) {
                return (Integer)this.f_19804_.m_135370_(LOADED_HE);
            }
            if (this.getWeaponIndex(0) == 2) {
                return (Integer)this.f_19804_.m_135370_(AMMO);
            }
            if (this.getWeaponIndex(0) == 3) {
                return InventoryTool.hasCreativeAmmoBox((Entity)living) ? 1 : this.m_18947_((Item)ModItems.WIRE_GUIDE_MISSILE.get());
            }
        }
        return 0;
    }

    public boolean banHand(LivingEntity entity) {
        Player player;
        if (entity == this.getNthEntity(0) || entity == this.getNthEntity(1)) {
            return true;
        }
        return entity == this.getNthEntity(2) && entity instanceof Player && !(player = (Player)entity).m_6144_();
    }

    public boolean hidePassenger(Entity entity) {
        return entity == this.getNthEntity(0) || entity == this.getNthEntity(1) || entity == this.getNthEntity(2);
    }

    public int zoomFov() {
        return 3;
    }

    public boolean hasTracks() {
        return true;
    }

    public boolean hasPassengerTurretWeapon() {
        return false;
    }

    public int getWeaponHeat(LivingEntity living) {
        if (living == this.getNthEntity(0)) {
            return (Integer)this.f_19804_.m_135370_(COAX_HEAT);
        }
        if (living == this.getNthEntity(1)) {
            return (Integer)this.f_19804_.m_135370_(HEAT);
        }
        return 0;
    }

    public void changeWeapon(int index, int value, boolean isScroll) {
        int typeIndex;
        if (index != 0) {
            return;
        }
        List weapons = this.getAvailableWeapons(index);
        if (weapons.isEmpty()) {
            return;
        }
        int count = weapons.size();
        int n = typeIndex = isScroll ? (value + this.getWeaponIndex(index) + count) % count : value;
        if (typeIndex == 0 || typeIndex == 1) {
            Entity needAp2;
            Player player;
            Entity entity;
            if ((Integer)this.f_19804_.m_135370_(LOADED_AP) > 0 && typeIndex == 1) {
                entity = this.m_146895_();
                if (entity instanceof Player && !InventoryTool.hasCreativeAmmoBox((Entity)(player = (Player)entity))) {
                    this.insertItem((Item)ModItems.AP_5_INCHES.get(), 1);
                }
                this.f_19804_.m_135381_(LOADED_AP, (Object)0);
            }
            if ((Integer)this.f_19804_.m_135370_(LOADED_HE) > 0 && typeIndex == 0) {
                entity = this.m_146895_();
                if (entity instanceof Player && !InventoryTool.hasCreativeAmmoBox((Entity)(player = (Player)entity))) {
                    this.insertItem((Item)ModItems.HE_5_INCHES.get(), 1);
                }
                this.f_19804_.m_135381_(LOADED_HE, (Object)0);
            }
            if (this.reloadCoolDown <= 0) {
                boolean needHe;
                boolean hasCreativeAmmo = false;
                for (int i = 0; i < this.getMaxPassengers(); ++i) {
                    Player pPlayer;
                    Entity entity2 = this.getNthEntity(i);
                    if (!(entity2 instanceof Player) || !InventoryTool.hasCreativeAmmoBox((Entity)(pPlayer = (Player)entity2))) continue;
                    hasCreativeAmmo = true;
                }
                boolean needAp2 = typeIndex == 0 && (Integer)this.f_19804_.m_135370_(LOADED_AP) == 0 && (hasCreativeAmmo || this.hasItem((Item)ModItems.AP_5_INCHES.get()));
                boolean bl = needHe = typeIndex == 1 && (Integer)this.f_19804_.m_135370_(LOADED_HE) == 0 && (hasCreativeAmmo || this.hasItem((Item)ModItems.HE_5_INCHES.get()));
                if (needAp2 || needHe) {
                    this.reloadCoolDown = 100;
                }
            }
            if ((needAp2 = this.m_146895_()) instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)needAp2;
                ClientboundStopSoundPacket clientboundstopsoundpacket = new ClientboundStopSoundPacket(((SoundEvent)ModSounds.M1128_RELOAD.get()).m_11660_(), SoundSource.PLAYERS);
                player2.f_8906_.m_9829_((Packet)clientboundstopsoundpacket);
            }
        }
        super.changeWeapon(index, value, isScroll);
    }

    public Vec3 getGunVec(float ticks) {
        return this.getGunnerVector(ticks);
    }

    public ResourceLocation getVehicleIcon() {
        return new ResourceLocation("mcsp", "textures/vehicle_icon/sprut_icon.png");
    }

    public int getHudColor() {
        return 16762624;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderFirstPersonOverlay(GuiGraphics guiGraphics, PoseStack poseStack, Font font, Player player, int screenWidth, int screenHeight, float scale, int color) {
        float minWH = Math.min((int)screenWidth, (int)screenHeight);
        float scaledMinWH = Mth.m_14143_((float)(minWH * scale));
        float centerW = ((float)screenWidth - scaledMinWH) / 2.0f;
        float centerH = ((float)screenHeight - scaledMinWH) / 2.0f;
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        if (this.getWeaponIndex(0) == 0) {
            RenderHelper.blit((PoseStack)poseStack, (ResourceLocation)Mod.loc((String)"textures/screens/land/tank_cannon_cross.png"), (float)centerW, (float)centerH, (float)0.0f, (float)0.0f, (float)scaledMinWH, (float)scaledMinWH, (float)scaledMinWH, (float)scaledMinWH, (int)color);
        } else if (this.getWeaponIndex(0) == 1) {
            RenderHelper.blit((PoseStack)poseStack, (ResourceLocation)Mod.loc((String)"textures/screens/land/tank_cannon_cross.png"), (float)centerW, (float)centerH, (float)0.0f, (float)0.0f, (float)scaledMinWH, (float)scaledMinWH, (float)scaledMinWH, (float)scaledMinWH, (int)color);
        } else if (this.getWeaponIndex(0) == 2) {
            RenderHelper.blit((PoseStack)poseStack, (ResourceLocation)Mod.loc((String)"textures/screens/land/lav_gun_cross.png"), (float)centerW, (float)centerH, (float)0.0f, (float)0.0f, (float)scaledMinWH, (float)scaledMinWH, (float)scaledMinWH, (float)scaledMinWH, (int)color);
        } else if (this.getWeaponIndex(0) == 3) {
            RenderHelper.blit((PoseStack)poseStack, (ResourceLocation)Mod.loc((String)"textures/screens/land/lav_missile_cross.png"), (float)centerW, (float)centerH, (float)0.0f, (float)0.0f, (float)scaledMinWH, (float)scaledMinWH, (float)scaledMinWH, (float)scaledMinWH, (int)color);
        }
        if (this.getWeaponIndex(0) == 0) {
            int heat = (Integer)this.m_20088_().m_135370_(HEAT);
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("AP SHELL  " + this.getAmmoCount((LivingEntity)player) + " " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : (Serializable)this.m_20088_().m_135370_(AMMO)))), screenWidth / 2 - 33, screenHeight - 65, MathTool.getGradientColor((int)color, (int)0xFF0000, (int)heat, (int)2), false);
        } else if (this.getWeaponIndex(0) == 1) {
            int heat = (Integer)this.m_20088_().m_135370_(HEAT);
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("HE SHELL  " + this.getAmmoCount((LivingEntity)player) + " " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : (Serializable)this.m_20088_().m_135370_(AMMO)))), screenWidth / 2 - 33, screenHeight - 65, MathTool.getGradientColor((int)color, (int)0xFF0000, (int)heat, (int)2), false);
        } else if (this.getWeaponIndex(0) == 2) {
            int heat = (Integer)this.m_20088_().m_135370_(COAX_HEAT);
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)(" 7.62MM MG " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : Integer.valueOf(this.getAmmoCount((LivingEntity)player))))), screenWidth / 2 - 33, screenHeight - 65, MathTool.getGradientColor((int)color, (int)0xFF0000, (int)heat, (int)2), false);
        } else if (this.getWeaponIndex(0) == 3) {
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)(" ARKAN 9M117M3 " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : Integer.valueOf(this.getAmmoCount((LivingEntity)player))))), screenWidth / 2 - 33, screenHeight - 65, color, false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderThirdPersonOverlay(GuiGraphics guiGraphics, Font font, Player player, int screenWidth, int screenHeight, float scale) {
        if (this.getWeaponIndex(0) == 0) {
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("AP SHELL " + this.getAmmoCount((LivingEntity)player) + " " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : (Serializable)this.m_20088_().m_135370_(AMMO)))), 30, -9, -1, false);
        } else if (this.getWeaponIndex(0) == 1) {
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("HE SHELL " + this.getAmmoCount((LivingEntity)player) + " " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : (Serializable)this.m_20088_().m_135370_(AMMO)))), 30, -9, -1, false);
        } else if (this.getWeaponIndex(0) == 2) {
            double heat2 = (float)((Integer)this.m_20088_().m_135370_(COAX_HEAT)).intValue() / 100.0f;
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("7.62MM MG " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : Integer.valueOf(this.getAmmoCount((LivingEntity)player))))), 30, -9, Mth.m_14169_((float)0.0f, (float)((float)heat2), (float)1.0f), false);
        }
    }

    public boolean hasDecoy() {
        return true;
    }

    public double getSensitivity(double original, boolean zoom, int seatIndex, boolean isOnGround) {
        return zoom ? 0.22 : (Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() ? 0.27 : 0.36);
    }

    public boolean isEnclosed(int index) {
        return index != 2;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vec2 getCameraRotation(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (zoom || isFirstPerson) {
            if (this.getSeatIndex((Entity)player) == 0) {
                return new Vec2((float)(-SprutEntity.getYRotFromVector((Vec3)this.getBarrelVec(partialTicks))), (float)(-SprutEntity.getXRotFromVector((Vec3)this.getBarrelVec(partialTicks))));
            }
            if (this.getSeatIndex((Entity)player) == 1) {
                return new Vec2((float)(-SprutEntity.getYRotFromVector((Vec3)this.getGunnerVector(partialTicks))), (float)(-SprutEntity.getXRotFromVector((Vec3)this.getGunnerVector(partialTicks))));
            }
        }
        return super.getCameraRotation(partialTicks, player, false, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3 getCameraPosition(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (zoom || isFirstPerson) {
            if (this.getSeatIndex((Entity)player) == 0) {
                if (zoom) {
                    return new Vec3(this.driverZoomPos((float)partialTicks).f_82479_, this.driverZoomPos((float)partialTicks).f_82480_, this.driverZoomPos((float)partialTicks).f_82481_);
                }
                return new Vec3(Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()), Mth.m_14139_((double)partialTicks, (double)(player.f_19855_ + (double)player.m_20192_()), (double)player.m_20188_()), Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()));
            }
            if (this.getSeatIndex((Entity)player) == 1) {
                return new Vec3(Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()), Mth.m_14139_((double)partialTicks, (double)(player.f_19855_ + (double)player.m_20192_()), (double)player.m_20188_()), Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()));
            }
        }
        return super.getCameraPosition(partialTicks, player, false, false);
    }

    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return Mod.loc((String)"textures/gui/vehicle/type/land.png");
    }

    public float getTurretMaxHealth() {
        return 100.0f;
    }

    public float getWheelMaxHealth() {
        return 100.0f;
    }

    public float getEngineMaxHealth() {
        return 150.0f;
    }

    public List<OBB> getOBBs() {
        return List.of(this.obb, this.obb2, this.obb3, this.obb4, this.obb5, this.obb6);
    }

    public void updateOBB() {
        Matrix4f transform = this.getVehicleTransform(1.0f);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 1.656f, -0.656f);
        this.obb.center().set((Vector3fc)new Vector3f(worldPosition.x, worldPosition.y, worldPosition.z));
        this.obb.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition2 = this.transformPosition(transform, 0.0f, 0.813f, -0.938f);
        this.obb2.center().set((Vector3fc)new Vector3f(worldPosition2.x, worldPosition2.y, worldPosition2.z));
        this.obb2.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition3 = this.transformPosition(transform, 0.0f, 1.531f, 3.75f);
        this.obb3.center().set((Vector3fc)new Vector3f(worldPosition3.x, worldPosition3.y, worldPosition3.z));
        this.obb3.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition5 = this.transformPosition(transform, 1.75f, 0.688f, -0.594f);
        this.obb5.center().set((Vector3fc)new Vector3f(worldPosition5.x, worldPosition5.y, worldPosition5.z));
        this.obb5.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition6 = this.transformPosition(transform, -1.75f, 0.688f, -0.594f);
        this.obb6.center().set((Vector3fc)new Vector3f(worldPosition6.x, worldPosition6.y, worldPosition6.z));
        this.obb6.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Matrix4f transformT = this.getTurretTransform(1.0f);
        Vector4f worldPosition4 = this.transformPosition(transformT, 0.0f, 0.46875f, 0.0f);
        this.obb4.center().set((Vector3fc)new Vector3f(worldPosition4.x, worldPosition4.y, worldPosition4.z));
        this.obb4.setRotation(VectorTool.combineRotationsTurret((float)1.0f, (VehicleEntity)this));
    }
}

