/*
 * Decompiled with CFR 0.152.
 */
package tech.mcsp.mcsp.entity;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.entity.OBBEntity;
import com.atsuishio.superbwarfare.entity.projectile.ProjectileEntity;
import com.atsuishio.superbwarfare.entity.projectile.SmallCannonShellEntity;
import com.atsuishio.superbwarfare.entity.projectile.WgMissileEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ContainerMobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.LandArmorEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ThirdPersonCameraPosition;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.WeaponVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.ProjectileWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.SmallCannonShellWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.VehicleWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.WgMissileWeapon;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.tools.Ammo;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.atsuishio.superbwarfare.tools.MathTool;
import com.atsuishio.superbwarfare.tools.OBB;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import tech.mcsp.mcsp.init.ModSounds;

public class M3A3Entity
extends ContainerMobileVehicleEntity
implements GeoEntity,
LandArmorEntity,
WeaponVehicleEntity,
OBBEntity {
    public static final EntityDataAccessor<Integer> CANNON_FIRE_TIME = SynchedEntityData.m_135353_(M3A3Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> LOADED_MISSILE = SynchedEntityData.m_135353_(M3A3Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> MISSILE_COUNT = SynchedEntityData.m_135353_(M3A3Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> MISSILE_INTER_DELAY = SynchedEntityData.m_135353_(M3A3Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int reloadCoolDown;
    public OBB obb = new OBB(this.m_20182_().m_252839_(), new Vector3f(1.875f, 0.84375f, 2.6875f), new Quaternionf(), OBB.Part.BODY);
    public OBB obb1 = new OBB(this.m_20182_().m_252839_(), new Vector3f(1.875f, 0.5625f, 0.75f), new Quaternionf(), OBB.Part.BODY);
    public OBB obb2 = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.3125f, 0.59375f, 2.96875f), new Quaternionf(), OBB.Part.WHEEL_LEFT);
    public OBB obb3 = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.3125f, 0.59375f, 2.96875f), new Quaternionf(), OBB.Part.WHEEL_RIGHT);
    public OBB obbTurret1 = new OBB(this.m_20182_().m_252839_(), new Vector3f(1.1875f, 0.375f, 1.1875f), new Quaternionf(), OBB.Part.TURRET);

    public float turretYSpeed() {
        return 5.0f;
    }

    public float turretXSpeed() {
        return 5.0f;
    }

    public static M3A3Entity clientSpawn(PlayMessages.SpawnEntity packet, Level world) {
        EntityType entityTypeFromPacket = (EntityType)BuiltInRegistries.f_256780_.m_7942_(packet.getTypeId());
        if (entityTypeFromPacket == null) {
            Mod.LOGGER.error("Failed to create entity from packet: Unknown entity type id: " + packet.getTypeId());
            return null;
        }
        if (!(entityTypeFromPacket instanceof EntityType)) {
            Mod.LOGGER.error("Retrieved EntityType is not an instance of EntityType<?> for id: " + packet.getTypeId());
            return null;
        }
        EntityType castedEntityType = entityTypeFromPacket;
        return new M3A3Entity((EntityType<M3A3Entity>)castedEntityType, world);
    }

    public M3A3Entity(EntityType<M3A3Entity> type, Level world) {
        super(type, world);
    }

    public VehicleWeapon[][] initWeapons() {
        return new VehicleWeapon[][]{{new SmallCannonShellWeapon().damage((float)((Integer)VehicleConfig.BMP_2_CANNON_DAMAGE.get()).intValue()).explosionDamage((float)((Integer)VehicleConfig.BMP_2_CANNON_EXPLOSION_DAMAGE.get()).intValue()).explosionRadius(((Double)VehicleConfig.BMP_2_CANNON_EXPLOSION_RADIUS.get()).floatValue()).sound((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.INTO_MISSILE.get()).icon(new ResourceLocation("mcsp", "textures/icon_gun/25mm.png")).sound1p((SoundEvent)ModSounds.M242_FIRE_1P.get()).sound3p((SoundEvent)ModSounds.M242_FIRE_3P.get()).sound3pFar((SoundEvent)ModSounds.M242_FIRE_FAR.get()).sound3pVeryFar((SoundEvent)ModSounds.M242_FIRE_FAR.get()), new ProjectileWeapon().damage(9.5f).headShot(2.0f).zoom(false).sound((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.INTO_CANNON.get()).icon(new ResourceLocation("mcsp", "textures/icon_gun/7.62mm.png")).sound1p((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.COAX_FIRE_1P.get()).sound3p((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.M_60_FIRE_3P.get()).sound3pFar((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.M_60_FAR.get()).sound3pVeryFar((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.M_60_VERYFAR.get()), new WgMissileWeapon().damage((float)((Integer)ExplosionConfig.WIRE_GUIDE_MISSILE_DAMAGE.get()).intValue()).explosionDamage((float)((Integer)ExplosionConfig.WIRE_GUIDE_MISSILE_EXPLOSION_DAMAGE.get()).intValue()).explosionRadius((float)((Integer)ExplosionConfig.WIRE_GUIDE_MISSILE_EXPLOSION_RADIUS.get()).intValue()).sound((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.INTO_MISSILE.get()).icon(new ResourceLocation("mcsp", "textures/icon_gun/tow-2.png")).sound1p((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.BMP_MISSILE_FIRE_1P.get()).sound3p((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.BMP_MISSILE_FIRE_3P.get())}};
    }

    public ThirdPersonCameraPosition getThirdPersonCameraPosition(int index) {
        return new ThirdPersonCameraPosition(3.0 + ClientMouseHandler.custom3pDistanceLerp, 1.0, 0.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CANNON_FIRE_TIME, (Object)0);
        this.f_19804_.m_135372_(LOADED_MISSILE, (Object)0);
        this.f_19804_.m_135372_(MISSILE_COUNT, (Object)0);
        this.f_19804_.m_135372_(MISSILE_INTER_DELAY, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("LoadedMissile", ((Integer)this.f_19804_.m_135370_(LOADED_MISSILE)).intValue());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(LOADED_MISSILE, (Object)compound.m_128451_("LoadedMissile"));
    }

    public DamageModifier getDamageModifier() {
        return super.getDamageModifier().custom((source, damage) -> Float.valueOf(this.getSourceAngle((DamageSource)source, 0.4f) * damage.floatValue()));
    }

    @ParametersAreNonnullByDefault
    protected void m_7355_(BlockPos pPos, BlockState pState) {
        this.m_5496_((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.WHEEL_STEP.get(), (float)(this.m_20184_().m_82553_() * 0.15), this.f_19796_.m_188501_() * 0.15f + 1.05f);
    }

    public void m_6075_() {
        Level level;
        super.m_6075_();
        this.updateOBB();
        if (this.m_9236_() instanceof ServerLevel) {
            int missileDelay;
            if (this.reloadCoolDown > 0) {
                --this.reloadCoolDown;
            }
            if ((missileDelay = ((Integer)this.f_19804_.m_135370_(MISSILE_INTER_DELAY)).intValue()) > 0) {
                this.f_19804_.m_135381_(MISSILE_INTER_DELAY, (Object)(missileDelay - 1));
            }
            this.handleAmmo();
            int fire = (Integer)this.f_19804_.m_135370_(FIRE_ANIM);
            if (fire > 0) {
                this.f_19804_.m_135381_(FIRE_ANIM, (Object)(fire - 1));
            }
        }
        if (this.m_20096_()) {
            float f0 = 0.54f + 0.25f * Mth.m_14154_((float)(90.0f - (float)M3A3Entity.calculateAngle((Vec3)this.m_20184_(), (Vec3)this.m_20252_(1.0f)))) / 90.0f;
            this.m_20256_(this.m_20184_().m_82549_(this.m_20252_(1.0f).m_82541_().m_82490_(0.05 * this.m_20184_().m_82526_(this.m_20252_(1.0f)))));
            this.m_20256_(this.m_20184_().m_82542_((double)f0, 0.99, (double)f0));
        } else {
            this.m_20256_(this.m_20184_().m_82542_(0.99, 0.99, 0.99));
        }
        if (this.m_20069_()) {
            float f1 = (float)((double)0.7f - (double)0.04f * Math.min((double)M3A3Entity.getSubmergedHeight((Entity)this), (double)this.m_20206_()) + (double)(0.08f * Mth.m_14154_((float)(90.0f - (float)M3A3Entity.calculateAngle((Vec3)this.m_20184_(), (Vec3)this.m_20252_(1.0f)))) / 90.0f));
            this.m_20256_(this.m_20184_().m_82549_(this.m_20252_(1.0f).m_82541_().m_82490_(0.04 * this.m_20184_().m_82526_(this.m_20252_(1.0f)))));
            this.m_20256_(this.m_20184_().m_82542_((double)f1, 0.85, (double)f1));
        }
        if ((level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.m_20069_() && this.m_20184_().m_82553_() > 0.1) {
                ParticleTool.sendParticle((ServerLevel)serverLevel, (ParticleOptions)ParticleTypes.f_123796_, (double)(this.m_20185_() + 0.5 * this.m_20184_().f_82479_), (double)(this.m_20186_() + M3A3Entity.getSubmergedHeight((Entity)this) - 0.2), (double)(this.m_20189_() + 0.5 * this.m_20184_().f_82481_), (int)((int)(2.0 + 4.0 * this.m_20184_().m_82553_())), (double)0.65, (double)0.0, (double)0.65, (double)0.0, (boolean)true);
                ParticleTool.sendParticle((ServerLevel)serverLevel, (ParticleOptions)ParticleTypes.f_123774_, (double)(this.m_20185_() + 0.5 * this.m_20184_().f_82479_), (double)(this.m_20186_() + M3A3Entity.getSubmergedHeight((Entity)this) - 0.2), (double)(this.m_20189_() + 0.5 * this.m_20184_().f_82481_), (int)((int)(2.0 + 10.0 * this.m_20184_().m_82553_())), (double)0.65, (double)0.0, (double)0.65, (double)0.0, (boolean)true);
            }
        }
        this.releaseSmokeDecoy(this.getTurretVector(1.0f));
    }

    public void terrainCompact(float w, float l) {
        if (this.m_20096_()) {
            float x1 = this.terrainCompactTrackValue(w, l)[0];
            float x2 = this.terrainCompactTrackValue(w, l - 1.0f)[0];
            float x3 = this.terrainCompactTrackValue(w, l - 2.0f)[0];
            float x4 = this.terrainCompactTrackValue(w, l - 3.0f)[0];
            float x5 = this.terrainCompactTrackValue(w, l - 4.0f)[0];
            float x6 = this.terrainCompactTrackValue(w, l - 5.0f)[0];
            List<Float> numbersX = Arrays.asList(Float.valueOf(x1), Float.valueOf(x2), Float.valueOf(x3), Float.valueOf(x4), Float.valueOf(x5), Float.valueOf(x6));
            float maxX = Collections.max(numbersX).floatValue();
            float minX = Collections.min(numbersX).floatValue();
            float z1 = this.terrainCompactTrackValue(w, l)[1];
            float z2 = this.terrainCompactTrackValue(w, l - 1.0f)[1];
            float z3 = this.terrainCompactTrackValue(w, l - 2.0f)[1];
            float z4 = this.terrainCompactTrackValue(w, l - 3.0f)[1];
            float z5 = this.terrainCompactTrackValue(w, l - 4.0f)[1];
            float z6 = this.terrainCompactTrackValue(w, l - 5.0f)[1];
            List<Float> numbersZ = Arrays.asList(Float.valueOf(z1), Float.valueOf(z2), Float.valueOf(z3), Float.valueOf(z4), Float.valueOf(z5), Float.valueOf(z6));
            float maxZ = Collections.max(numbersZ).floatValue();
            float minZ = Collections.min(numbersZ).floatValue();
            float diffX = Math.clamp((float)-15.0f, (float)15.0f, (float)((minX + maxX) / 2.0f));
            this.m_146926_(Mth.m_14036_((float)(this.m_146909_() + 0.15f * diffX), (float)-45.0f, (float)45.0f));
            float diffZ = Math.clamp((float)-15.0f, (float)15.0f, (float)(minZ + maxZ));
            this.setZRot(Mth.m_14036_((float)(this.getRoll() + 0.15f * diffZ), (float)-45.0f, (float)45.0f));
        } else if (this.m_20069_()) {
            this.m_146926_(this.m_146909_() * 0.9f);
            this.setZRot(this.getRoll() * 0.9f);
        }
    }

    public boolean canCollideHardBlock() {
        return this.m_20184_().m_165924_() > 0.07 || (double)Mth.m_14154_((float)((Float)this.f_19804_.m_135370_(POWER)).floatValue()) > 0.12;
    }

    private void handleAmmo() {
        Entity entity = this.m_146895_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int ammoCount = this.m_213659_().stream().filter(stack -> {
            if (stack.m_150930_((Item)ModItems.AMMO_BOX.get())) {
                return Ammo.RIFLE.get(stack) > 0;
            }
            return false;
        }).mapToInt(arg_0 -> ((Ammo)Ammo.RIFLE).get(arg_0)).sum() + this.m_18947_((Item)ModItems.RIFLE_AMMO.get());
        if (this.reloadCoolDown <= 0 && (Integer)this.m_20088_().m_135370_(LOADED_MISSILE) == 0) {
            boolean hasCreativeAmmo = InventoryTool.hasCreativeAmmoBox((Entity)player);
            boolean hasMissileItems = this.hasItem((Item)ModItems.WIRE_GUIDE_MISSILE.get());
            if (hasCreativeAmmo || hasMissileItems) {
                int toLoad = 2;
                if (!hasCreativeAmmo) {
                    int available = this.m_18947_((Item)ModItems.WIRE_GUIDE_MISSILE.get());
                    toLoad = Math.min((int)2, (int)available);
                }
                if (toLoad > 0) {
                    this.f_19804_.m_135381_(LOADED_MISSILE, (Object)toLoad);
                    if (!hasCreativeAmmo) {
                        for (int i = 0; i < toLoad; ++i) {
                            this.m_213659_().stream().filter(stack -> stack.m_150930_((Item)ModItems.WIRE_GUIDE_MISSILE.get()) && !stack.m_41619_()).findFirst().ifPresent(stack -> stack.m_41774_(1));
                        }
                    }
                    this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.BMP_MISSILE_RELOAD.get(), this.m_5720_(), 1.0f, 1.0f);
                }
            }
        }
        if (this.getWeaponIndex(0) == 0) {
            this.f_19804_.m_135381_(AMMO, (Object)this.m_18947_((Item)ModItems.SMALL_SHELL.get()));
        } else if (this.getWeaponIndex(0) == 1) {
            this.f_19804_.m_135381_(AMMO, (Object)ammoCount);
        } else if (this.getWeaponIndex(0) == 2) {
            this.f_19804_.m_135381_(AMMO, (Object)((Integer)this.m_20088_().m_135370_(LOADED_MISSILE)));
        }
    }

    public void vehicleShoot(LivingEntity living, int type) {
        boolean hasCreativeAmmo = false;
        for (int i = 0; i < this.getMaxPassengers() - 1; ++i) {
            Player pPlayer;
            Entity entity = this.getNthEntity(i);
            if (!(entity instanceof Player) || !InventoryTool.hasCreativeAmmoBox((Entity)(pPlayer = (Player)entity))) continue;
            hasCreativeAmmo = true;
        }
        Matrix4f transform = this.getBarrelTransform(1.0f);
        if (this.getWeaponIndex(0) == 0) {
            if (this.cannotFire) {
                return;
            }
            float x = -0.0f;
            float y = 0.0f;
            float z = 2.375f;
            Vector4f worldPosition = this.transformPosition(transform, x, y, z);
            SmallCannonShellEntity smallCannonShell = ((SmallCannonShellWeapon)this.getWeapon(0)).create(living);
            smallCannonShell.m_6034_((double)worldPosition.x - 1.1 * this.m_20184_().f_82479_, (double)worldPosition.y, (double)worldPosition.z - 1.1 * this.m_20184_().f_82481_);
            smallCannonShell.m_6686_(this.getBarrelVector((float)1.0f).f_82479_, this.getBarrelVector((float)1.0f).f_82480_ + (double)0.005f, this.getBarrelVector((float)1.0f).f_82481_, 35.0f, 0.25f);
            this.m_9236_().m_7967_((Entity)smallCannonShell);
            ParticleTool.sendParticle((ServerLevel)((ServerLevel)this.m_9236_()), (ParticleOptions)ParticleTypes.f_123755_, (double)((double)worldPosition.x - 1.1 * this.m_20184_().f_82479_), (double)worldPosition.y, (double)((double)worldPosition.z - 1.1 * this.m_20184_().f_82481_), (int)1, (double)0.02, (double)0.02, (double)0.02, (double)0.0, (boolean)false);
            this.playShootSound3p(living, 0, 4, 12, 24, new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z));
            this.f_19804_.m_135381_(CANNON_RECOIL_TIME, (Object)40);
            this.f_19804_.m_135381_(YAW, (Object)Float.valueOf(this.getTurretYRot()));
            this.f_19804_.m_135381_(HEAT, (Object)((Integer)this.f_19804_.m_135370_(HEAT) + 7));
            this.f_19804_.m_135381_(FIRE_ANIM, (Object)3);
            if (hasCreativeAmmo) {
                return;
            }
            this.reloadCoolDown = 80;
            this.m_213659_().stream().filter(stack -> stack.m_150930_((Item)ModItems.SMALL_SHELL.get())).findFirst().ifPresent(stack -> stack.m_41774_(1));
        } else if (this.getWeaponIndex(0) == 1) {
            if (this.cannotFireCoax) {
                return;
            }
            float x = -0.46875f;
            float y = 0.15625f;
            float z = 0.75f;
            Vector4f worldPosition = this.transformPosition(transform, x, y, z);
            if ((Integer)this.f_19804_.m_135370_(AMMO) > 0 || hasCreativeAmmo) {
                ProjectileEntity projectileRight = ((ProjectileWeapon)this.getWeapon(0)).create(living).setGunItemId(this.m_6095_().m_20675_());
                projectileRight.bypassArmorRate(0.2f);
                projectileRight.m_6034_((double)worldPosition.x - 1.1 * this.m_20184_().f_82479_, (double)worldPosition.y, (double)worldPosition.z - 1.1 * this.m_20184_().f_82481_);
                projectileRight.shoot(living, this.getBarrelVector((float)1.0f).f_82479_, this.getBarrelVector((float)1.0f).f_82480_ + (double)0.002f, this.getBarrelVector((float)1.0f).f_82481_, 36.0f, 0.25f);
                this.m_9236_().m_7967_((Entity)projectileRight);
                if (!hasCreativeAmmo) {
                    ItemStack ammoBox = this.m_213659_().stream().filter(stack -> {
                        if (stack.m_150930_((Item)ModItems.AMMO_BOX.get())) {
                            return Ammo.RIFLE.get(stack) > 0;
                        }
                        return false;
                    }).findFirst().orElse(ItemStack.f_41583_);
                    if (!ammoBox.m_41619_()) {
                        Ammo.RIFLE.add(ammoBox, -1);
                    } else {
                        this.m_213659_().stream().filter(stack -> stack.m_150930_((Item)ModItems.RIFLE_AMMO.get())).findFirst().ifPresent(stack -> stack.m_41774_(1));
                    }
                }
            }
            this.f_19804_.m_135381_(COAX_HEAT, (Object)((Integer)this.f_19804_.m_135370_(COAX_HEAT) + 3));
            this.f_19804_.m_135381_(FIRE_ANIM, (Object)2);
            this.playShootSound3p(living, 0, 3, 6, 12, new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z));
        } else if (this.getWeaponIndex(0) == 2 && (Integer)this.m_20088_().m_135370_(LOADED_MISSILE) > 0 && (Integer)this.f_19804_.m_135370_(MISSILE_INTER_DELAY) <= 0) {
            Matrix4f transformT = this.getBarrelTransform(1.0f);
            float x = 1.46875f;
            float y = 0.5f;
            float z = 0.125f;
            Vector4f worldPosition = this.transformPosition(transformT, x, y, z);
            WgMissileEntity wgMissileEntity = ((WgMissileWeapon)this.getWeapon(0)).create(living);
            wgMissileEntity.m_6034_((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
            wgMissileEntity.m_6686_(this.getBarrelVector((float)1.0f).f_82479_, this.getBarrelVector((float)1.0f).f_82480_, this.getBarrelVector((float)1.0f).f_82481_, 2.0f, 0.0f);
            living.m_9236_().m_7967_((Entity)wgMissileEntity);
            this.playShootSound3p(living, 0, 6, 0, 0, new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z));
            this.f_19804_.m_135381_(LOADED_MISSILE, (Object)((Integer)this.m_20088_().m_135370_(LOADED_MISSILE) - 1));
            this.f_19804_.m_135381_(MISSILE_INTER_DELAY, (Object)100);
            if ((Integer)this.m_20088_().m_135370_(LOADED_MISSILE) <= 0) {
                this.reloadCoolDown = 160;
            }
        }
    }

    public void travel() {
        Entity passenger0 = this.m_146895_();
        if (this.getEnergy() <= 0) {
            return;
        }
        if (passenger0 == null) {
            this.leftInputDown = false;
            this.rightInputDown = false;
            this.forwardInputDown = false;
            this.backInputDown = false;
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(0.0f));
        }
        if (this.forwardInputDown) {
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.min((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() + (((Float)this.f_19804_.m_135370_(POWER)).floatValue() < 0.0f ? 0.004f : 0.0024f)), (float)0.13f)));
        }
        if (this.backInputDown) {
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.max((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() - (((Float)this.f_19804_.m_135370_(POWER)).floatValue() > 0.0f ? 0.004f : 0.0024f)), (float)-0.16f)));
            if (this.rightInputDown) {
                this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() + 0.1f));
            } else if (this.leftInputDown) {
                this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() - 0.1f));
            }
        } else if (this.rightInputDown) {
            this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() - 0.1f));
        } else if (this.leftInputDown) {
            this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() + 0.1f));
        }
        if (this.forwardInputDown || this.backInputDown) {
            this.consumeEnergy((Integer)VehicleConfig.BMP_2_ENERGY_COST.get());
        }
        this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(POWER)).floatValue() * (this.upInputDown ? 0.5f : (this.rightInputDown || this.leftInputDown ? 0.947f : 0.96f))));
        this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() * (float)Math.max((double)((double)0.76f - (double)0.1f * this.m_20184_().m_165924_()), (double)0.3)));
        double s0 = this.m_20184_().m_82526_(this.m_20252_(1.0f));
        this.setLeftWheelRot((float)((double)this.getLeftWheelRot() - 1.25 * s0 + (double)Mth.m_14036_((float)(0.75f * ((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()), (float)-5.0f, (float)5.0f)));
        this.setRightWheelRot((float)((double)this.getRightWheelRot() - 1.25 * s0 - (double)Mth.m_14036_((float)(0.75f * ((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()), (float)-5.0f, (float)5.0f)));
        this.setLeftTrack((float)((double)this.getLeftTrack() - 5.969026041820607 * s0 + Mth.m_14008_((double)(1.2566370801612687 * (double)((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()), (double)-5.0, (double)5.0)));
        this.setRightTrack((float)((double)this.getRightTrack() - 5.969026041820607 * s0 - Mth.m_14008_((double)(1.2566370801612687 * (double)((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()), (double)-5.0, (double)5.0)));
        this.m_146922_((float)((double)this.m_146908_() - (this.m_20069_() && !this.m_20096_() ? 2.5 : 6.0) * (double)((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()));
        if (this.m_20069_() || this.m_20096_()) {
            float power = ((Float)this.f_19804_.m_135370_(POWER)).floatValue() * Mth.m_14036_((float)(1.0f + (float)(s0 > 0.0 ? 1 : -1) * this.m_146909_() / 35.0f), (float)0.0f, (float)2.0f);
            this.m_20256_(this.m_20184_().m_82549_(this.m_20252_(1.0f).m_82490_((double)((!this.m_20069_() && !this.m_20096_() ? 0.13f : (this.m_20069_() && !this.m_20096_() ? 2.0f : 2.2f)) * power))));
        }
    }

    public SoundEvent getEngineSound() {
        return (SoundEvent)ModSounds.BRADLEY_ENGINE.get();
    }

    public float getEngineSoundVolume() {
        return Math.max((float)Mth.m_14154_((float)((Float)this.f_19804_.m_135370_(POWER)).floatValue()), (float)Mth.m_14154_((float)(0.1f * ((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()))) * 2.5f;
    }

    public void m_19956_(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (!this.m_20363_(passenger)) {
            return;
        }
        Matrix4f transform = this.getTurretTransform(1.0f);
        Matrix4f transformV = this.getVehicleTransform(1.0f);
        int i = this.getSeatIndex(passenger);
        Vector4f worldPosition = i == 0 ? this.transformPosition(transform, 0.5f, 0.0f, 0.0f) : this.transformPosition(transformV, 0.0f, 1.0f, 0.0f);
        passenger.m_6034_((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        callback.m_20372_(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        this.copyEntityData(passenger);
    }

    public void copyEntityData(Entity entity) {
        if (entity == this.getNthEntity(0)) {
            entity.m_5618_(this.getBarrelYRot(1.0f));
        }
    }

    public int getMaxPassengers() {
        return 7;
    }

    public Vec3 driverZoomPos(float ticks) {
        Matrix4f transform = this.getTurretTransform(ticks);
        Vector4f worldPosition = this.transformPosition(transform, 0.5f, 0.0f, 0.0f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    public Vec3 getNewEyePos(float pPartialTicks) {
        Matrix4f transform = this.getTurretTransform(pPartialTicks);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    public Vec3 getBarrelVector(float pPartialTicks) {
        Matrix4f transform = this.getBarrelTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f targetPosition = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z).m_82505_(new Vec3((double)targetPosition.x, (double)targetPosition.y, (double)targetPosition.z));
    }

    public Matrix4f getBarrelTransform(float ticks) {
        Matrix4f transformT = this.getTurretTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 0.5f, 0.625f);
        transformT.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        float a = this.getTurretYaw(ticks);
        float r = (Mth.m_14154_((float)a) - 90.0f) / 90.0f;
        float r2 = Mth.m_14154_((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
        float x = Mth.m_14179_((float)ticks, (float)this.turretXRotO, (float)this.getTurretXRot());
        float xV = Mth.m_14179_((float)ticks, (float)this.f_19860_, (float)this.m_146909_());
        float z = Mth.m_14179_((float)ticks, (float)this.prevRoll, (float)this.getRoll());
        transformT.rotate((Quaternionfc)Axis.f_252529_.m_252977_(x + r * xV + r2 * z));
        return transformT;
    }

    public Vec3 getTurretVector(float pPartialTicks) {
        Matrix4f transform = this.getTurretTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f targetPosition = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z).m_82505_(new Vec3((double)targetPosition.x, (double)targetPosition.y, (double)targetPosition.z));
    }

    public Matrix4f getTurretTransform(float ticks) {
        Matrix4f transformV = this.getVehicleTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, -0.25f, 2.25f, -0.25f);
        transformV.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        transformV.rotate((Quaternionfc)Axis.f_252436_.m_252977_(Mth.m_14179_((float)ticks, (float)this.turretYRotO, (float)this.getTurretYRot())));
        return transformV;
    }

    protected void clampRotation(Entity entity) {
        float a = this.getTurretYaw(1.0f);
        float r = (Mth.m_14154_((float)a) - 90.0f) / 90.0f;
        float r2 = Mth.m_14154_((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
        float min = -45.0f - r * this.m_146909_() - r2 * this.getRoll();
        float max = 5.0f - r * this.m_146909_() - r2 * this.getRoll();
        float f = Mth.m_14177_((float)entity.m_146909_());
        float f1 = Mth.m_14036_((float)f, (float)min, (float)max);
        entity.f_19860_ += f1 - f;
        entity.m_146926_(entity.m_146909_() + f1 - f);
        entity.m_5618_(this.getBarrelYRot(1.0f));
    }

    public void m_7340_(@NotNull Entity entity) {
        this.clampRotation(entity);
    }

    public int getFireAnim() {
        return (Integer)this.f_19804_.m_135370_(FIRE_ANIM);
    }

    private PlayState firePredicate(AnimationState<M3A3Entity> event) {
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 0, this::firePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public int mainGunRpm(LivingEntity living) {
        if (this.getWeaponIndex(0) == 0) {
            return 200;
        }
        if (this.getWeaponIndex(0) == 1) {
            return 650;
        }
        return 200;
    }

    public boolean canShoot(LivingEntity living) {
        if (this.getWeaponIndex(0) == 0) {
            return ((Integer)this.f_19804_.m_135370_(AMMO) > 0 || InventoryTool.hasCreativeAmmoBox((Entity)living)) && !this.cannotFire;
        }
        if (this.getWeaponIndex(0) == 1) {
            return ((Integer)this.f_19804_.m_135370_(AMMO) > 0 || InventoryTool.hasCreativeAmmoBox((Entity)living)) && !this.cannotFireCoax;
        }
        if (this.getWeaponIndex(0) == 2) {
            return (Integer)this.m_20088_().m_135370_(LOADED_MISSILE) > 0 && (Integer)this.f_19804_.m_135370_(MISSILE_INTER_DELAY) <= 0;
        }
        return false;
    }

    public int getAmmoCount(LivingEntity living) {
        return (Integer)this.f_19804_.m_135370_(AMMO);
    }

    public boolean banHand(LivingEntity entity) {
        return true;
    }

    public boolean hidePassenger(Entity entity) {
        return true;
    }

    public boolean hasPassengerTurretWeapon() {
        return false;
    }

    public int zoomFov() {
        return 4;
    }

    public int getWeaponHeat(LivingEntity living) {
        if (this.getWeaponIndex(0) == 0) {
            return (Integer)this.f_19804_.m_135370_(HEAT);
        }
        if (this.getWeaponIndex(0) == 1) {
            return (Integer)this.f_19804_.m_135370_(COAX_HEAT);
        }
        return 0;
    }

    public ResourceLocation getVehicleIcon() {
        return new ResourceLocation("mcsp", "textures/vehicle_icon/m3a3_icon.png");
    }

    public int getHudColor() {
        return 16762624;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderFirstPersonOverlay(GuiGraphics guiGraphics, PoseStack poseStack, Font font, Player player, int screenWidth, int screenHeight, float scale, int color) {
        super.renderFirstPersonOverlay(guiGraphics, poseStack, font, player, screenWidth, screenHeight, scale, color);
        float minWH = Math.min((int)screenWidth, (int)screenHeight);
        float scaledMinWH = Mth.m_14143_((float)(minWH * scale));
        float centerW = ((float)screenWidth - scaledMinWH) / 2.0f;
        float centerH = ((float)screenHeight - scaledMinWH) / 2.0f;
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        if (this.getWeaponIndex(0) == 0) {
            int heat = (Integer)this.m_20088_().m_135370_(HEAT);
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)(" 25MM M242 " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : Integer.valueOf(this.getAmmoCount((LivingEntity)player))))), screenWidth / 2 - 33, screenHeight - 65, MathTool.getGradientColor((int)color, (int)0xFF0000, (int)heat, (int)2), false);
        } else if (this.getWeaponIndex(0) == 1) {
            int heat = (Integer)this.m_20088_().m_135370_(COAX_HEAT);
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)(" M240C 7.62MM " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : Integer.valueOf(this.getAmmoCount((LivingEntity)player))))), screenWidth / 2 - 33, screenHeight - 65, MathTool.getGradientColor((int)color, (int)0xFF0000, (int)heat, (int)2), false);
        } else if (this.getWeaponIndex(0) == 2) {
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("  TOW-2  " + String.valueOf(this.m_20088_().m_135370_(LOADED_MISSILE)) + " " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : (Serializable)this.m_20088_().m_135370_(MISSILE_COUNT)))), screenWidth / 2 - 33, screenHeight - 65, color, false);
        }
        if (this.getWeaponIndex(0) == 3) {
            RenderHelper.blit((PoseStack)poseStack, (ResourceLocation)Mod.loc((String)"textures/screens/land/tank_cannon_cross_ap.png"), (float)centerW, (float)centerH, (float)0.0f, (float)0.0f, (float)scaledMinWH, (float)scaledMinWH, (float)scaledMinWH, (float)scaledMinWH, (int)color);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderThirdPersonOverlay(GuiGraphics guiGraphics, Font font, Player player, int screenWidth, int screenHeight, float scale) {
        if (this.getWeaponIndex(0) == 0) {
            double heat = (float)((Integer)this.m_20088_().m_135370_(HEAT)).intValue() / 100.0f;
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)(" 25MM M242 " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : Integer.valueOf(this.getAmmoCount((LivingEntity)player))))), 30, -9, Mth.m_14169_((float)0.0f, (float)((float)heat), (float)1.0f), false);
        } else if (this.getWeaponIndex(0) == 1) {
            double heat2 = (float)((Integer)this.m_20088_().m_135370_(COAX_HEAT)).intValue() / 100.0f;
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)(" M240C 7.62MM " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : Integer.valueOf(this.getAmmoCount((LivingEntity)player))))), 30, -9, Mth.m_14169_((float)0.0f, (float)((float)heat2), (float)1.0f), false);
        } else if (this.getWeaponIndex(0) == 2) {
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("  TOW-2  " + String.valueOf(this.m_20088_().m_135370_(LOADED_MISSILE)) + " " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : (Serializable)this.m_20088_().m_135370_(MISSILE_COUNT)))), 30, -9, -1, false);
        }
    }

    public boolean hasTracks() {
        return true;
    }

    public boolean hasDecoy() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vec2 getCameraRotation(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (zoom || isFirstPerson) {
            if (this.getSeatIndex((Entity)player) == 0) {
                return new Vec2((float)(-M3A3Entity.getYRotFromVector((Vec3)this.getBarrelVec(partialTicks))), (float)(-M3A3Entity.getXRotFromVector((Vec3)this.getBarrelVec(partialTicks))));
            }
            return new Vec2(Mth.m_14179_((float)partialTicks, (float)player.f_20886_, (float)player.m_6080_()), Mth.m_14179_((float)partialTicks, (float)player.f_19860_, (float)player.m_146909_()));
        }
        return super.getCameraRotation(partialTicks, player, false, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3 getCameraPosition(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (zoom || isFirstPerson) {
            if (this.getSeatIndex((Entity)player) == 0) {
                if (zoom) {
                    return new Vec3(this.driverZoomPos((float)partialTicks).f_82479_, Mth.m_14139_((double)partialTicks, (double)(player.f_19855_ + (double)player.m_20192_()), (double)player.m_20188_()), this.driverZoomPos((float)partialTicks).f_82481_);
                }
                return new Vec3(Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()), Mth.m_14139_((double)partialTicks, (double)(player.f_19855_ + (double)player.m_20192_()), (double)player.m_20188_()), Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()));
            }
            return new Vec3(Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()) - 6.0 * player.m_20252_((float)partialTicks).f_82479_, Mth.m_14139_((double)partialTicks, (double)(player.f_19855_ + (double)player.m_20192_() + 1.0), (double)(player.m_20188_() + 1.0)) - 6.0 * player.m_20252_((float)partialTicks).f_82480_, Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()) - 6.0 * player.m_20252_((float)partialTicks).f_82481_);
        }
        return super.getCameraPosition(partialTicks, player, false, false);
    }

    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return Mod.loc((String)"textures/gui/vehicle/type/land.png");
    }

    public List<OBB> getOBBs() {
        return List.of(this.obb, this.obb1, this.obb2, this.obbTurret1, this.obb3);
    }

    public void updateOBB() {
        Matrix4f transform = this.getVehicleTransform(1.0f);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 1.46875f, -0.4375f);
        this.obb.center().set((Vector3fc)new Vector3f(worldPosition.x, worldPosition.y, worldPosition.z));
        this.obb.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition1 = this.transformPosition(transform, 0.0f, 1.1875f, 3.0f);
        this.obb1.center().set((Vector3fc)new Vector3f(worldPosition1.x, worldPosition1.y, worldPosition1.z));
        this.obb1.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition2 = this.transformPosition(transform, 1.4375f, 0.59375f, 0.34375f);
        this.obb2.center().set((Vector3fc)new Vector3f(worldPosition2.x, worldPosition2.y, worldPosition2.z));
        this.obb2.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition3 = this.transformPosition(transform, -1.4375f, 0.59375f, 0.34375f);
        this.obb3.center().set((Vector3fc)new Vector3f(worldPosition3.x, worldPosition3.y, worldPosition3.z));
        this.obb3.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Matrix4f transformT = this.getTurretTransform(1.0f);
        Vector4f worldPositionT1 = this.transformPosition(transformT, 0.0f, 0.5f, 0.0f);
        this.obbTurret1.center().set((Vector3fc)new Vector3f(worldPositionT1.x, worldPositionT1.y, worldPositionT1.z));
        this.obbTurret1.setRotation(VectorTool.combineRotationsTurret((float)1.0f, (VehicleEntity)this));
    }
}

