/*
 * Decompiled with CFR 0.152.
 */
package tech.mcsp.mcsp.entity;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.entity.OBBEntity;
import com.atsuishio.superbwarfare.entity.projectile.ProjectileEntity;
import com.atsuishio.superbwarfare.entity.projectile.SmallCannonShellEntity;
import com.atsuishio.superbwarfare.entity.projectile.WgMissileEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ContainerMobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.LandArmorEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ThirdPersonCameraPosition;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.WeaponVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.ProjectileWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.SmallCannonShellWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.VehicleWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.WgMissileWeapon;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.Ammo;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.atsuishio.superbwarfare.tools.OBB;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import tech.mcsp.mcsp.init.ModEntities;

public class Bmd4Entity
extends ContainerMobileVehicleEntity
implements GeoEntity,
LandArmorEntity,
WeaponVehicleEntity,
OBBEntity {
    public static final EntityDataAccessor<Integer> CANNON_FIRE_TIME = SynchedEntityData.m_135353_(Bmd4Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> LOADED_MISSILE = SynchedEntityData.m_135353_(Bmd4Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> MISSILE_COUNT = SynchedEntityData.m_135353_(Bmd4Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> MG_AMMO = SynchedEntityData.m_135353_(Bmd4Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int reloadCoolDown;
    public OBB obb = new OBB(this.m_20182_().m_252839_(), new Vector3f(2.0f, 0.46875f, 3.28125f), new Quaternionf(), OBB.Part.BODY);
    public OBB obb1 = new OBB(this.m_20182_().m_252839_(), new Vector3f(1.4375f, 0.375f, 3.0f), new Quaternionf(), OBB.Part.BODY);
    public OBB obb2 = new OBB(this.m_20182_().m_252839_(), new Vector3f(1.8125f, 0.34375f, 0.4375f), new Quaternionf(), OBB.Part.BODY);
    public OBB obb3 = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.25f, 0.4375f, 3.2578125f), new Quaternionf(), OBB.Part.WHEEL_LEFT);
    public OBB obb4 = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.25f, 0.4375f, 3.2578125f), new Quaternionf(), OBB.Part.WHEEL_RIGHT);
    public OBB obbTurret1 = new OBB(this.m_20182_().m_252839_(), new Vector3f(1.25f, 0.3125f, 1.25f), new Quaternionf(), OBB.Part.TURRET);

    public static Bmd4Entity clientSpawn(PlayMessages.SpawnEntity packet, Level world) {
        EntityType entityTypeFromPacket = (EntityType)BuiltInRegistries.f_256780_.m_7942_(packet.getTypeId());
        if (entityTypeFromPacket == null) {
            Mod.LOGGER.error("Failed to create entity from packet: Unknown entity type id: " + packet.getTypeId());
            return null;
        }
        if (!(entityTypeFromPacket instanceof EntityType)) {
            Mod.LOGGER.error("Retrieved EntityType is not an instance of EntityType<?> for id: " + packet.getTypeId());
            return null;
        }
        EntityType castedEntityType = entityTypeFromPacket;
        Bmd4Entity entity = new Bmd4Entity((EntityType<Bmd4Entity>)castedEntityType, world);
        return entity;
    }

    public Bmd4Entity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<Bmd4Entity>)((EntityType)ModEntities.BMD_4.get()), world);
    }

    public Bmd4Entity(EntityType<Bmd4Entity> type, Level world) {
        super(type, world);
    }

    public float turretYSpeed() {
        return 6.0f;
    }

    public float turretXSpeed() {
        return 5.0f;
    }

    public VehicleWeapon[][] initWeapons() {
        return new VehicleWeapon[][]{{new SmallCannonShellWeapon().damage((float)((Integer)VehicleConfig.BMP_2_CANNON_DAMAGE.get()).intValue()).explosionDamage((float)((Integer)VehicleConfig.BMP_2_CANNON_EXPLOSION_DAMAGE.get()).intValue()).explosionRadius(((Double)VehicleConfig.BMP_2_CANNON_EXPLOSION_RADIUS.get()).floatValue()).sound((SoundEvent)ModSounds.INTO_MISSILE.get()).icon(new ResourceLocation("mcsp", "textures/icon_gun/30mm.png")).sound1p((SoundEvent)ModSounds.BMP_CANNON_FIRE_1P.get()).sound3p((SoundEvent)ModSounds.BMP_CANNON_FIRE_3P.get()).sound3pFar((SoundEvent)ModSounds.LAV_CANNON_FAR.get()).sound3pVeryFar((SoundEvent)ModSounds.LAV_CANNON_VERYFAR.get()), new ProjectileWeapon().damage(9.5f).headShot(2.0f).zoom(false).sound((SoundEvent)ModSounds.INTO_CANNON.get()).icon(new ResourceLocation("mcsp", "textures/icon_gun/7.62mm.png")).sound1p((SoundEvent)ModSounds.COAX_FIRE_1P.get()).sound3p((SoundEvent)ModSounds.M_60_FIRE_3P.get()).sound3pFar((SoundEvent)ModSounds.M_60_FAR.get()).sound3pVeryFar((SoundEvent)ModSounds.M_60_VERYFAR.get()), new WgMissileWeapon().damage((float)((Integer)ExplosionConfig.WIRE_GUIDE_MISSILE_DAMAGE.get()).intValue()).explosionDamage((float)((Integer)ExplosionConfig.WIRE_GUIDE_MISSILE_EXPLOSION_DAMAGE.get()).intValue()).explosionRadius((float)((Integer)ExplosionConfig.WIRE_GUIDE_MISSILE_EXPLOSION_RADIUS.get()).intValue()).sound((SoundEvent)ModSounds.INTO_MISSILE.get()).icon(new ResourceLocation("mcsp", "textures/icon_gun/arkan.png")).sound1p((SoundEvent)ModSounds.BMP_MISSILE_FIRE_1P.get()).sound3p((SoundEvent)ModSounds.BMP_MISSILE_FIRE_3P.get())}};
    }

    public ThirdPersonCameraPosition getThirdPersonCameraPosition(int index) {
        return new ThirdPersonCameraPosition(3.0 + ClientMouseHandler.custom3pDistanceLerp, 1.0, 0.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CANNON_FIRE_TIME, (Object)0);
        this.f_19804_.m_135372_(LOADED_MISSILE, (Object)0);
        this.f_19804_.m_135372_(MISSILE_COUNT, (Object)0);
        this.f_19804_.m_135372_(MG_AMMO, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("LoadedMissile", ((Integer)this.f_19804_.m_135370_(LOADED_MISSILE)).intValue());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(LOADED_MISSILE, (Object)compound.m_128451_("LoadedMissile"));
    }

    public DamageModifier getDamageModifier() {
        return super.getDamageModifier().custom((source, damage) -> Float.valueOf(this.getSourceAngle((DamageSource)source, 0.4f) * damage.floatValue()));
    }

    @ParametersAreNonnullByDefault
    protected void m_7355_(BlockPos pPos, BlockState pState) {
        this.m_5496_((SoundEvent)ModSounds.WHEEL_STEP.get(), (float)(this.m_20184_().m_82553_() * 0.15), this.f_19796_.m_188501_() * 0.15f + 1.05f);
    }

    public void m_6075_() {
        Level level;
        super.m_6075_();
        this.updateOBB();
        if (this.m_9236_() instanceof ServerLevel) {
            if (this.reloadCoolDown > 0) {
                --this.reloadCoolDown;
            }
            this.handleAmmo();
        }
        double fluidFloat = 0.052 * Bmd4Entity.getSubmergedHeight((Entity)this);
        this.m_20256_(this.m_20184_().m_82520_(0.0, fluidFloat, 0.0));
        if (this.m_20096_()) {
            float f0 = 0.54f + 0.25f * Mth.m_14154_((float)(90.0f - (float)Bmd4Entity.calculateAngle((Vec3)this.m_20184_(), (Vec3)this.m_20252_(1.0f)))) / 90.0f;
            this.m_20256_(this.m_20184_().m_82549_(this.m_20252_(1.0f).m_82541_().m_82490_(0.05 * this.m_20184_().m_82526_(this.m_20252_(1.0f)))));
            this.m_20256_(this.m_20184_().m_82542_((double)f0, 0.99, (double)f0));
        } else {
            this.m_20256_(this.m_20184_().m_82542_(0.99, 0.99, 0.99));
        }
        if (this.m_20069_()) {
            float f1 = (float)((double)0.7f - (double)0.04f * Math.min((double)Bmd4Entity.getSubmergedHeight((Entity)this), (double)this.m_20206_()) + (double)(0.08f * Mth.m_14154_((float)(90.0f - (float)Bmd4Entity.calculateAngle((Vec3)this.m_20184_(), (Vec3)this.m_20252_(1.0f)))) / 90.0f));
            this.m_20256_(this.m_20184_().m_82549_(this.m_20252_(1.0f).m_82541_().m_82490_(0.04 * this.m_20184_().m_82526_(this.m_20252_(1.0f)))));
            this.m_20256_(this.m_20184_().m_82542_((double)f1, 0.85, (double)f1));
        }
        if ((level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.m_20069_() && this.m_20184_().m_82553_() > 0.1) {
                ParticleTool.sendParticle((ServerLevel)serverLevel, (ParticleOptions)ParticleTypes.f_123796_, (double)(this.m_20185_() + 0.5 * this.m_20184_().f_82479_), (double)(this.m_20186_() + Bmd4Entity.getSubmergedHeight((Entity)this) - 0.2), (double)(this.m_20189_() + 0.5 * this.m_20184_().f_82481_), (int)((int)(2.0 + 4.0 * this.m_20184_().m_82553_())), (double)0.65, (double)0.0, (double)0.65, (double)0.0, (boolean)true);
                ParticleTool.sendParticle((ServerLevel)serverLevel, (ParticleOptions)ParticleTypes.f_123774_, (double)(this.m_20185_() + 0.5 * this.m_20184_().f_82479_), (double)(this.m_20186_() + Bmd4Entity.getSubmergedHeight((Entity)this) - 0.2), (double)(this.m_20189_() + 0.5 * this.m_20184_().f_82481_), (int)((int)(2.0 + 10.0 * this.m_20184_().m_82553_())), (double)0.65, (double)0.0, (double)0.65, (double)0.0, (boolean)true);
            }
        }
        this.releaseSmokeDecoy(this.getTurretVector(1.0f));
    }

    public void terrainCompact(float w, float l) {
        if (this.m_20096_()) {
            float x1 = this.terrainCompactTrackValue(w, l)[0];
            float x2 = this.terrainCompactTrackValue(w, l - 1.0f)[0];
            float x3 = this.terrainCompactTrackValue(w, l - 2.0f)[0];
            float x4 = this.terrainCompactTrackValue(w, l - 3.0f)[0];
            float x5 = this.terrainCompactTrackValue(w, l - 4.0f)[0];
            float x6 = this.terrainCompactTrackValue(w, l - 5.0f)[0];
            List<Float> numbersX = Arrays.asList(Float.valueOf(x1), Float.valueOf(x2), Float.valueOf(x3), Float.valueOf(x4), Float.valueOf(x5), Float.valueOf(x6));
            float maxX = Collections.max(numbersX).floatValue();
            float minX = Collections.min(numbersX).floatValue();
            float z1 = this.terrainCompactTrackValue(w, l)[1];
            float z2 = this.terrainCompactTrackValue(w, l - 1.0f)[1];
            float z3 = this.terrainCompactTrackValue(w, l - 2.0f)[1];
            float z4 = this.terrainCompactTrackValue(w, l - 3.0f)[1];
            float z5 = this.terrainCompactTrackValue(w, l - 4.0f)[1];
            float z6 = this.terrainCompactTrackValue(w, l - 5.0f)[1];
            List<Float> numbersZ = Arrays.asList(Float.valueOf(z1), Float.valueOf(z2), Float.valueOf(z3), Float.valueOf(z4), Float.valueOf(z5), Float.valueOf(z6));
            float maxZ = Collections.max(numbersZ).floatValue();
            float minZ = Collections.min(numbersZ).floatValue();
            float diffX = Math.clamp((float)-15.0f, (float)15.0f, (float)((minX + maxX) / 2.0f));
            this.m_146926_(Mth.m_14036_((float)(this.m_146909_() + 0.15f * diffX), (float)-45.0f, (float)45.0f));
            float diffZ = Math.clamp((float)-15.0f, (float)15.0f, (float)(minZ + maxZ));
            this.setZRot(Mth.m_14036_((float)(this.getRoll() + 0.15f * diffZ), (float)-45.0f, (float)45.0f));
        } else if (this.m_20069_()) {
            this.m_146926_(this.m_146909_() * 0.9f);
            this.setZRot(this.getRoll() * 0.9f);
        }
    }

    public boolean canCollideHardBlock() {
        return this.m_20184_().m_165924_() > 0.07 || (double)Mth.m_14154_((float)((Float)this.f_19804_.m_135370_(POWER)).floatValue()) > 0.12;
    }

    private void handleAmmo() {
        boolean hasCreativeAmmo = false;
        for (int i = 0; i < this.getMaxPassengers(); ++i) {
            if (!InventoryTool.hasCreativeAmmoBox((Entity)this.getNthEntity(i))) continue;
            hasCreativeAmmo = true;
        }
        int mgAmmoCount = this.m_213659_().stream().filter(stack -> {
            if (stack.m_150930_((Item)ModItems.AMMO_BOX.get())) {
                return Ammo.RIFLE.get(stack) > 0;
            }
            return false;
        }).mapToInt(arg_0 -> ((Ammo)Ammo.RIFLE).get(arg_0)).sum() + this.m_18947_((Item)ModItems.RIFLE_AMMO.get());
        if ((this.hasItem((Item)ModItems.WIRE_GUIDE_MISSILE.get()) || hasCreativeAmmo) && this.reloadCoolDown <= 0 && (Integer)this.m_20088_().m_135370_(LOADED_MISSILE) < 1) {
            this.f_19804_.m_135381_(LOADED_MISSILE, (Object)((Integer)this.m_20088_().m_135370_(LOADED_MISSILE) + 1));
            this.reloadCoolDown = 160;
            if (!hasCreativeAmmo) {
                this.m_213659_().stream().filter(stack -> stack.m_150930_((Item)ModItems.WIRE_GUIDE_MISSILE.get())).findFirst().ifPresent(stack -> stack.m_41774_(1));
            }
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModSounds.BMP_MISSILE_RELOAD.get(), this.m_5720_(), 1.0f, 1.0f);
        }
        if (this.getWeaponIndex(0) == 0) {
            this.f_19804_.m_135381_(AMMO, (Object)this.m_18947_((Item)ModItems.SMALL_SHELL.get()));
        } else if (this.getWeaponIndex(0) == 1) {
            this.f_19804_.m_135381_(AMMO, (Object)mgAmmoCount);
        } else if (this.getWeaponIndex(0) == 2) {
            this.f_19804_.m_135381_(AMMO, (Object)((Integer)this.m_20088_().m_135370_(LOADED_MISSILE)));
        }
        this.f_19804_.m_135381_(MG_AMMO, (Object)mgAmmoCount);
        this.f_19804_.m_135381_(MISSILE_COUNT, (Object)this.m_18947_((Item)ModItems.WIRE_GUIDE_MISSILE.get()));
    }

    public void vehicleShoot(LivingEntity living, int type) {
        boolean hasCreativeAmmo = false;
        for (int i = 0; i < this.getMaxPassengers() - 1; ++i) {
            Player pPlayer;
            Entity entity = this.getNthEntity(i);
            if (!(entity instanceof Player) || !InventoryTool.hasCreativeAmmoBox((Entity)(pPlayer = (Player)entity))) continue;
            hasCreativeAmmo = true;
        }
        Matrix4f transform = this.getBarrelTransform(1.0f);
        if (this.getWeaponIndex(0) == 0) {
            if (this.cannotFire) {
                return;
            }
            float x = -0.03125f;
            float y = 0.0f;
            float z = 3.125f;
            Vector4f worldPosition = this.transformPosition(transform, x, y, z);
            SmallCannonShellEntity smallCannonShell = ((SmallCannonShellWeapon)this.getWeapon(0)).create(living);
            smallCannonShell.m_6034_((double)worldPosition.x - 1.1 * this.m_20184_().f_82479_, (double)worldPosition.y, (double)worldPosition.z - 1.1 * this.m_20184_().f_82481_);
            smallCannonShell.m_6686_(this.getBarrelVector((float)1.0f).f_82479_, this.getBarrelVector((float)1.0f).f_82480_ + (double)0.005f, this.getBarrelVector((float)1.0f).f_82481_, 35.0f, 0.25f);
            this.m_9236_().m_7967_((Entity)smallCannonShell);
            ParticleTool.sendParticle((ServerLevel)((ServerLevel)this.m_9236_()), (ParticleOptions)ParticleTypes.f_123755_, (double)((double)worldPosition.x - 1.1 * this.m_20184_().f_82479_), (double)worldPosition.y, (double)((double)worldPosition.z - 1.1 * this.m_20184_().f_82481_), (int)1, (double)0.02, (double)0.02, (double)0.02, (double)0.0, (boolean)false);
            ParticleTool.sendParticle((ServerLevel)((ServerLevel)this.m_9236_()), (ParticleOptions)ParticleTypes.f_123755_, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z, (int)1, (double)0.02, (double)0.02, (double)0.02, (double)0.0, (boolean)false);
            this.playShootSound3p(living, 0, 4, 12, 24, new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z));
            this.f_19804_.m_135381_(CANNON_RECOIL_TIME, (Object)40);
            this.f_19804_.m_135381_(YAW, (Object)Float.valueOf(this.getTurretYRot()));
            this.f_19804_.m_135381_(HEAT, (Object)((Integer)this.f_19804_.m_135370_(HEAT) + 7));
            this.f_19804_.m_135381_(FIRE_ANIM, (Object)3);
            if (hasCreativeAmmo) {
                return;
            }
            this.reloadCoolDown = 80;
            this.m_213659_().stream().filter(stack -> stack.m_150930_((Item)ModItems.SMALL_SHELL.get())).findFirst().ifPresent(stack -> stack.m_41774_(1));
        } else if (this.getWeaponIndex(0) == 1) {
            if (this.cannotFireCoax) {
                return;
            }
            float x = 0.40625f;
            float y = 0.34375f;
            float z = 1.125f;
            Vector4f worldPosition = this.transformPosition(transform, x, y, z);
            if ((Integer)this.f_19804_.m_135370_(MG_AMMO) > 0 || hasCreativeAmmo) {
                ProjectileEntity projectileRight = ((ProjectileWeapon)this.getWeapon(0)).create(living).setGunItemId(this.m_6095_().m_20675_());
                projectileRight.bypassArmorRate(0.2f);
                projectileRight.m_6034_((double)worldPosition.x - 1.1 * this.m_20184_().f_82479_, (double)worldPosition.y, (double)worldPosition.z - 1.1 * this.m_20184_().f_82481_);
                projectileRight.shoot(living, this.getBarrelVector((float)1.0f).f_82479_, this.getBarrelVector((float)1.0f).f_82480_ + (double)0.002f, this.getBarrelVector((float)1.0f).f_82481_, 36.0f, 0.25f);
                this.m_9236_().m_7967_((Entity)projectileRight);
                if (!hasCreativeAmmo) {
                    ItemStack ammoBox = this.m_213659_().stream().filter(stack -> {
                        if (stack.m_150930_((Item)ModItems.AMMO_BOX.get())) {
                            return Ammo.RIFLE.get(stack) > 0;
                        }
                        return false;
                    }).findFirst().orElse(ItemStack.f_41583_);
                    if (!ammoBox.m_41619_()) {
                        Ammo.RIFLE.add(ammoBox, -1);
                    } else {
                        this.m_213659_().stream().filter(stack -> stack.m_150930_((Item)ModItems.RIFLE_AMMO.get())).findFirst().ifPresent(stack -> stack.m_41774_(1));
                    }
                }
            }
            this.f_19804_.m_135381_(COAX_HEAT, (Object)((Integer)this.f_19804_.m_135370_(COAX_HEAT) + 3));
            this.f_19804_.m_135381_(FIRE_ANIM, (Object)2);
            this.playShootSound3p(living, 0, 3, 6, 12, new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z));
        } else if (this.getWeaponIndex(0) == 2 && (Integer)this.m_20088_().m_135370_(LOADED_MISSILE) > 0) {
            Matrix4f transformT = this.getBarrelTransform(1.0f);
            float x = 0.15625f;
            float y = 0.0f;
            float z = 4.3125f;
            Vector4f worldPosition = this.transformPosition(transformT, x, y, z);
            WgMissileEntity wgMissileEntity = ((WgMissileWeapon)this.getWeapon(0)).create(living);
            wgMissileEntity.m_6034_((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
            wgMissileEntity.m_6686_(this.getBarrelVector((float)1.0f).f_82479_, this.getBarrelVector((float)1.0f).f_82480_, this.getBarrelVector((float)1.0f).f_82481_, 2.0f, 0.0f);
            living.m_9236_().m_7967_((Entity)wgMissileEntity);
            this.playShootSound3p(living, 0, 6, 0, 0, new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z));
            this.f_19804_.m_135381_(LOADED_MISSILE, (Object)((Integer)this.m_20088_().m_135370_(LOADED_MISSILE) - 1));
            this.reloadCoolDown = 160;
        }
    }

    public void travel() {
        Entity passenger0 = this.m_146895_();
        if (this.getEnergy() <= 0) {
            return;
        }
        if (passenger0 == null) {
            this.leftInputDown = false;
            this.rightInputDown = false;
            this.forwardInputDown = false;
            this.backInputDown = false;
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(0.0f));
        }
        if (this.forwardInputDown) {
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.min((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() + (((Float)this.f_19804_.m_135370_(POWER)).floatValue() < 0.0f ? 0.004f : 0.0024f)), (float)0.21f)));
        }
        if (this.backInputDown) {
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.max((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() - (((Float)this.f_19804_.m_135370_(POWER)).floatValue() > 0.0f ? 0.004f : 0.0024f)), (float)-0.16f)));
            if (this.rightInputDown) {
                this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() + 0.1f));
            } else if (this.leftInputDown) {
                this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() - 0.1f));
            }
        } else if (this.rightInputDown) {
            this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() - 0.1f));
        } else if (this.leftInputDown) {
            this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() + 0.1f));
        }
        if (this.forwardInputDown || this.backInputDown) {
            this.consumeEnergy((Integer)VehicleConfig.BMP_2_ENERGY_COST.get());
        }
        this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(POWER)).floatValue() * (this.upInputDown ? 0.5f : (this.rightInputDown || this.leftInputDown ? 0.947f : 0.96f))));
        this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() * (float)Math.max((double)((double)0.76f - (double)0.1f * this.m_20184_().m_165924_()), (double)0.3)));
        double s0 = this.m_20184_().m_82526_(this.m_20252_(1.0f));
        this.setLeftWheelRot((float)((double)this.getLeftWheelRot() - 1.25 * s0 + (double)Mth.m_14036_((float)(0.75f * ((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()), (float)-5.0f, (float)5.0f)));
        this.setRightWheelRot((float)((double)this.getRightWheelRot() - 1.25 * s0 - (double)Mth.m_14036_((float)(0.75f * ((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()), (float)-5.0f, (float)5.0f)));
        this.setLeftTrack((float)((double)this.getLeftTrack() - 5.969026041820607 * s0 + Mth.m_14008_((double)(1.2566370801612687 * (double)((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()), (double)-5.0, (double)5.0)));
        this.setRightTrack((float)((double)this.getRightTrack() - 5.969026041820607 * s0 - Mth.m_14008_((double)(1.2566370801612687 * (double)((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()), (double)-5.0, (double)5.0)));
        this.m_146922_((float)((double)this.m_146908_() - (this.m_20069_() && !this.m_20096_() ? 2.5 : 6.0) * (double)((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()));
        if (this.m_20069_() || this.m_20096_()) {
            float power = ((Float)this.f_19804_.m_135370_(POWER)).floatValue() * Mth.m_14036_((float)(1.0f + (float)(s0 > 0.0 ? 1 : -1) * this.m_146909_() / 35.0f), (float)0.0f, (float)2.0f);
            this.m_20256_(this.m_20184_().m_82549_(this.m_20252_(1.0f).m_82490_((double)((!this.m_20069_() && !this.m_20096_() ? 0.13f : (this.m_20069_() && !this.m_20096_() ? 2.0f : 2.4f)) * power))));
        }
    }

    public SoundEvent getEngineSound() {
        return (SoundEvent)ModSounds.BMP_ENGINE.get();
    }

    public float getEngineSoundVolume() {
        return Math.max((float)Mth.m_14154_((float)((Float)this.f_19804_.m_135370_(POWER)).floatValue()), (float)Mth.m_14154_((float)(0.1f * ((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()))) * 2.5f;
    }

    public void m_19956_(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (!this.m_20363_(passenger)) {
            return;
        }
        Matrix4f transform = this.getTurretTransform(1.0f);
        Matrix4f transformV = this.getVehicleTransform(1.0f);
        int i = this.getSeatIndex(passenger);
        Vector4f worldPosition = i == 0 ? this.transformPosition(transform, 0.5f, 0.0f, 0.0f) : this.transformPosition(transformV, 0.0f, 1.0f, 0.0f);
        passenger.m_6034_((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        callback.m_20372_(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        this.copyEntityData(passenger);
    }

    public void copyEntityData(Entity entity) {
        if (entity == this.getNthEntity(0)) {
            entity.m_5618_(this.getBarrelYRot(1.0f));
        }
    }

    public int getMaxPassengers() {
        return 7;
    }

    public Vec3 driverZoomPos(float ticks) {
        Matrix4f transform = this.getTurretTransform(ticks);
        Vector4f worldPosition = this.transformPosition(transform, 0.5f, 0.0f, 0.0f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    public Vec3 getNewEyePos(float pPartialTicks) {
        Matrix4f transform = this.getTurretTransform(pPartialTicks);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    public Vec3 getBarrelVector(float pPartialTicks) {
        Matrix4f transform = this.getBarrelTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f targetPosition = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z).m_82505_(new Vec3((double)targetPosition.x, (double)targetPosition.y, (double)targetPosition.z));
    }

    public Matrix4f getBarrelTransform(float ticks) {
        Matrix4f transformT = this.getTurretTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 0.28125f, 1.3125f);
        transformT.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        float a = this.getTurretYaw(ticks);
        float r = (Mth.m_14154_((float)a) - 90.0f) / 90.0f;
        float r2 = Mth.m_14154_((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
        float x = Mth.m_14179_((float)ticks, (float)this.turretXRotO, (float)this.getTurretXRot());
        float xV = Mth.m_14179_((float)ticks, (float)this.f_19860_, (float)this.m_146909_());
        float z = Mth.m_14179_((float)ticks, (float)this.prevRoll, (float)this.getRoll());
        transformT.rotate((Quaternionfc)Axis.f_252529_.m_252977_(x + r * xV + r2 * z));
        return transformT;
    }

    public Vec3 getTurretVector(float pPartialTicks) {
        Matrix4f transform = this.getTurretTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f targetPosition = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z).m_82505_(new Vec3((double)targetPosition.x, (double)targetPosition.y, (double)targetPosition.z));
    }

    public Matrix4f getTurretTransform(float ticks) {
        Matrix4f transformV = this.getVehicleTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 2.125f, 0.0f);
        transformV.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        transformV.rotate((Quaternionfc)Axis.f_252436_.m_252977_(Mth.m_14179_((float)ticks, (float)this.turretYRotO, (float)this.getTurretYRot())));
        return transformV;
    }

    protected void clampRotation(Entity entity) {
        float a = this.getTurretYaw(1.0f);
        float r = (Mth.m_14154_((float)a) - 90.0f) / 90.0f;
        float r2 = Mth.m_14154_((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
        float min = -45.0f - r * this.m_146909_() - r2 * this.getRoll();
        float max = 5.0f - r * this.m_146909_() - r2 * this.getRoll();
        float f = Mth.m_14177_((float)entity.m_146909_());
        float f1 = Mth.m_14036_((float)f, (float)min, (float)max);
        entity.f_19860_ += f1 - f;
        entity.m_146926_(entity.m_146909_() + f1 - f);
        entity.m_5618_(this.getBarrelYRot(1.0f));
    }

    public void m_7340_(@NotNull Entity entity) {
        this.clampRotation(entity);
    }

    private PlayState firePredicate(AnimationState<Bmd4Entity> event) {
        if ((Integer)this.f_19804_.m_135370_(FIRE_ANIM) > 1 && this.getWeaponIndex(0) == 0) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.lav.fire"));
        }
        if ((Integer)this.f_19804_.m_135370_(FIRE_ANIM) > 0 && this.getWeaponIndex(0) == 1) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.lav.fire2"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.lav.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 0, this::firePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public int mainGunRpm(LivingEntity living) {
        if (this.getWeaponIndex(0) == 0) {
            return 250;
        }
        if (this.getWeaponIndex(0) == 1) {
            return 750;
        }
        return 250;
    }

    public boolean canShoot(LivingEntity living) {
        if (this.getWeaponIndex(0) == 0) {
            return ((Integer)this.f_19804_.m_135370_(AMMO) > 0 || InventoryTool.hasCreativeAmmoBox((Entity)living)) && !this.cannotFire;
        }
        if (this.getWeaponIndex(0) == 1) {
            return ((Integer)this.f_19804_.m_135370_(MG_AMMO) > 0 || InventoryTool.hasCreativeAmmoBox((Entity)living)) && !this.cannotFireCoax;
        }
        if (this.getWeaponIndex(0) == 2) {
            return (Integer)this.f_19804_.m_135370_(LOADED_MISSILE) > 0;
        }
        return false;
    }

    public int getAmmoCount(LivingEntity living) {
        if (this.getWeaponIndex(0) == 1) {
            return (Integer)this.f_19804_.m_135370_(MG_AMMO);
        }
        return (Integer)this.f_19804_.m_135370_(AMMO);
    }

    public boolean banHand(LivingEntity entity) {
        return true;
    }

    public boolean hidePassenger(Entity entity) {
        return true;
    }

    public int zoomFov() {
        return 4;
    }

    public int getWeaponHeat(LivingEntity living) {
        if (this.getWeaponIndex(0) == 0) {
            return (Integer)this.f_19804_.m_135370_(HEAT);
        }
        if (this.getWeaponIndex(0) == 1) {
            return (Integer)this.f_19804_.m_135370_(COAX_HEAT);
        }
        return 0;
    }

    public ResourceLocation getVehicleIcon() {
        return new ResourceLocation("mcsp", "textures/vehicle_icon/bmd_4_icon.png");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderFirstPersonOverlay(GuiGraphics guiGraphics, PoseStack poseStack, Font font, Player player, int screenWidth, int screenHeight, float scale, int color) {
        super.renderFirstPersonOverlay(guiGraphics, poseStack, font, player, screenWidth, screenHeight, scale, color);
        float minWH = Math.min((int)screenWidth, (int)screenHeight);
        float scaledMinWH = Mth.m_14143_((float)(minWH * scale));
        float centerW = ((float)screenWidth - scaledMinWH) / 2.0f;
        float centerH = ((float)screenHeight - scaledMinWH) / 2.0f;
        if (this.getWeaponIndex(0) == 0) {
            double heat = 1.0f - (float)((Integer)this.m_20088_().m_135370_(HEAT)).intValue() / 100.0f;
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)(" 30MM 2A42 " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : Integer.valueOf(this.getAmmoCount((LivingEntity)player))))), screenWidth / 2 - 33, screenHeight - 65, Mth.m_14169_((float)((float)heat / 3.7453184f), (float)1.0f, (float)1.0f), false);
        } else if (this.getWeaponIndex(0) == 1) {
            double heat = 1.0f - (float)((Integer)this.m_20088_().m_135370_(COAX_HEAT)).intValue() / 100.0f;
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)(" 7.62MM \u041f\u041a\u0422 " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : Integer.valueOf(this.getAmmoCount((LivingEntity)player))))), screenWidth / 2 - 33, screenHeight - 65, Mth.m_14169_((float)((float)heat / 3.7453184f), (float)1.0f, (float)1.0f), false);
        } else if (this.getWeaponIndex(0) == 2) {
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("ARKAN 9M117M3  " + String.valueOf(this.m_20088_().m_135370_(LOADED_MISSILE)) + " " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : (Serializable)this.m_20088_().m_135370_(MISSILE_COUNT)))), screenWidth / 2 - 33, screenHeight - 65, 0x66FF00, false);
        } else if (this.getWeaponIndex(0) == 3) {
            double heat = 1.0f - (float)((Integer)this.m_20088_().m_135370_(HEAT)).intValue() / 100.0f;
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("     2\u041072 " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : Integer.valueOf(this.getAmmoCount((LivingEntity)player))))), screenWidth / 2 - 33, screenHeight - 65, Mth.m_14169_((float)((float)heat / 3.7453184f), (float)1.0f, (float)1.0f), false);
        }
        if (this.getWeaponIndex(0) == 3) {
            RenderHelper.preciseBlit((GuiGraphics)guiGraphics, (ResourceLocation)Mod.loc((String)"textures/screens/land/tank_cannon_cross.png"), (float)centerW, (float)centerH, (float)0.0f, (float)0.0f, (float)scaledMinWH, (float)scaledMinWH, (float)scaledMinWH, (float)scaledMinWH);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderThirdPersonOverlay(GuiGraphics guiGraphics, Font font, Player player, int screenWidth, int screenHeight, float scale) {
        if (this.getWeaponIndex(0) == 0) {
            double heat = (float)((Integer)this.m_20088_().m_135370_(HEAT)).intValue() / 100.0f;
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("30MM 2A42 " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : Integer.valueOf(this.getAmmoCount((LivingEntity)player))))), 30, -9, Mth.m_14169_((float)0.0f, (float)((float)heat), (float)1.0f), false);
        } else if (this.getWeaponIndex(0) == 1) {
            double heat2 = (float)((Integer)this.m_20088_().m_135370_(COAX_HEAT)).intValue() / 100.0f;
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("7.62MM \u041f\u041a\u0422 " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : Integer.valueOf(this.getAmmoCount((LivingEntity)player))))), 30, -9, Mth.m_14169_((float)0.0f, (float)((float)heat2), (float)1.0f), false);
        } else if (this.getWeaponIndex(0) == 2) {
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("ARKAN 9M117M3 " + String.valueOf(this.m_20088_().m_135370_(LOADED_MISSILE)) + " " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : (Serializable)this.m_20088_().m_135370_(MISSILE_COUNT)))), 30, -9, -1, false);
        } else if (this.getWeaponIndex(0) == 3) {
            double heat = (float)((Integer)this.m_20088_().m_135370_(HEAT)).intValue() / 100.0f;
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("2\u041072 " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : Integer.valueOf(this.getAmmoCount((LivingEntity)player))))), 30, -9, Mth.m_14169_((float)0.0f, (float)((float)heat), (float)1.0f), false);
        }
    }

    public boolean hasTracks() {
        return true;
    }

    public boolean hasDecoy() {
        return true;
    }

    public double getSensitivity(double original, boolean zoom, int seatIndex, boolean isOnGround) {
        return zoom ? 0.22 : (Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() ? 0.27 : 0.36);
    }

    public boolean isEnclosed(int index) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vec2 getCameraRotation(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (zoom || isFirstPerson) {
            if (this.getSeatIndex((Entity)player) == 0) {
                return new Vec2((float)(-Bmd4Entity.getYRotFromVector((Vec3)this.getBarrelVec(partialTicks))), (float)(-Bmd4Entity.getXRotFromVector((Vec3)this.getBarrelVec(partialTicks))));
            }
            return new Vec2(Mth.m_14179_((float)partialTicks, (float)player.f_20886_, (float)player.m_6080_()), Mth.m_14179_((float)partialTicks, (float)player.f_19860_, (float)player.m_146909_()));
        }
        return super.getCameraRotation(partialTicks, player, false, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3 getCameraPosition(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (zoom || isFirstPerson) {
            if (this.getSeatIndex((Entity)player) == 0) {
                if (zoom) {
                    return new Vec3(this.driverZoomPos((float)partialTicks).f_82479_, Mth.m_14139_((double)partialTicks, (double)(player.f_19855_ + (double)player.m_20192_()), (double)player.m_20188_()), this.driverZoomPos((float)partialTicks).f_82481_);
                }
                return new Vec3(Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()), Mth.m_14139_((double)partialTicks, (double)(player.f_19855_ + (double)player.m_20192_()), (double)player.m_20188_()), Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()));
            }
            return new Vec3(Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()) - 6.0 * player.m_20252_((float)partialTicks).f_82479_, Mth.m_14139_((double)partialTicks, (double)(player.f_19855_ + (double)player.m_20192_() + 1.0), (double)(player.m_20188_() + 1.0)) - 6.0 * player.m_20252_((float)partialTicks).f_82480_, Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()) - 6.0 * player.m_20252_((float)partialTicks).f_82481_);
        }
        return super.getCameraPosition(partialTicks, player, false, false);
    }

    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return Mod.loc((String)"textures/gui/vehicle/type/land.png");
    }

    public List<OBB> getOBBs() {
        return List.of(this.obb, this.obb1, this.obb2, this.obbTurret1, this.obb3, this.obb4);
    }

    public void updateOBB() {
        Matrix4f transform = this.getVehicleTransform(1.0f);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 1.65625f, -0.75f);
        this.obb.center().set((Vector3fc)new Vector3f(worldPosition.x, worldPosition.y, worldPosition.z));
        this.obb.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition1 = this.transformPosition(transform, 0.0f, 0.8125f, -0.75f);
        this.obb1.center().set((Vector3fc)new Vector3f(worldPosition1.x, worldPosition1.y, worldPosition1.z));
        this.obb1.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition2 = this.transformPosition(transform, 0.0f, 1.53125f, 2.75f);
        this.obb2.center().set((Vector3fc)new Vector3f(worldPosition2.x, worldPosition2.y, worldPosition2.z));
        this.obb2.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition3 = this.transformPosition(transform, 1.71875f, 0.4375f, -0.75f);
        this.obb3.center().set((Vector3fc)new Vector3f(worldPosition3.x, worldPosition3.y, worldPosition3.z));
        this.obb3.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition4 = this.transformPosition(transform, -1.71875f, 0.4375f, -0.75f);
        this.obb4.center().set((Vector3fc)new Vector3f(worldPosition4.x, worldPosition4.y, worldPosition4.z));
        this.obb4.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Matrix4f transformT = this.getTurretTransform(1.0f);
        Vector4f worldPositionT1 = this.transformPosition(transformT, 0.0f, 0.34375f, 0.0f);
        this.obbTurret1.center().set((Vector3fc)new Vector3f(worldPositionT1.x, worldPositionT1.y, worldPositionT1.z));
        this.obbTurret1.setRotation(VectorTool.combineRotationsTurret((float)1.0f, (VehicleEntity)this));
    }

    public boolean hasPassengerTurretWeapon() {
        return false;
    }
}

