/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.server.player;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.PacketListener;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockChangedAckPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundTagQueryPacket;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.network.protocol.game.ServerboundAcceptTeleportationPacket;
import net.minecraft.network.protocol.game.ServerboundBlockEntityTagQuery;
import net.minecraft.network.protocol.game.ServerboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ServerboundChatAckPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandPacket;
import net.minecraft.network.protocol.game.ServerboundChatPacket;
import net.minecraft.network.protocol.game.ServerboundChatSessionUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.network.protocol.game.ServerboundClientInformationPacket;
import net.minecraft.network.protocol.game.ServerboundCommandSuggestionPacket;
import net.minecraft.network.protocol.game.ServerboundContainerButtonClickPacket;
import net.minecraft.network.protocol.game.ServerboundContainerClickPacket;
import net.minecraft.network.protocol.game.ServerboundContainerClosePacket;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.game.ServerboundEditBookPacket;
import net.minecraft.network.protocol.game.ServerboundEntityTagQuery;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.network.protocol.game.ServerboundJigsawGeneratePacket;
import net.minecraft.network.protocol.game.ServerboundKeepAlivePacket;
import net.minecraft.network.protocol.game.ServerboundLockDifficultyPacket;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.network.protocol.game.ServerboundMoveVehiclePacket;
import net.minecraft.network.protocol.game.ServerboundPaddleBoatPacket;
import net.minecraft.network.protocol.game.ServerboundPickItemPacket;
import net.minecraft.network.protocol.game.ServerboundPlaceRecipePacket;
import net.minecraft.network.protocol.game.ServerboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerCommandPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerInputPacket;
import net.minecraft.network.protocol.game.ServerboundPongPacket;
import net.minecraft.network.protocol.game.ServerboundRecipeBookChangeSettingsPacket;
import net.minecraft.network.protocol.game.ServerboundRecipeBookSeenRecipePacket;
import net.minecraft.network.protocol.game.ServerboundRenameItemPacket;
import net.minecraft.network.protocol.game.ServerboundResourcePackPacket;
import net.minecraft.network.protocol.game.ServerboundSeenAdvancementsPacket;
import net.minecraft.network.protocol.game.ServerboundSelectTradePacket;
import net.minecraft.network.protocol.game.ServerboundSetBeaconPacket;
import net.minecraft.network.protocol.game.ServerboundSetCarriedItemPacket;
import net.minecraft.network.protocol.game.ServerboundSetCommandBlockPacket;
import net.minecraft.network.protocol.game.ServerboundSetCommandMinecartPacket;
import net.minecraft.network.protocol.game.ServerboundSetCreativeModeSlotPacket;
import net.minecraft.network.protocol.game.ServerboundSetJigsawBlockPacket;
import net.minecraft.network.protocol.game.ServerboundSetStructureBlockPacket;
import net.minecraft.network.protocol.game.ServerboundSignUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundSwingPacket;
import net.minecraft.network.protocol.game.ServerboundTeleportToEntityPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemOnPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RunningOnDifferentThreadException;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BaseCommandBlock;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.Logger;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.level.little.LittleLevel;
import team.creative.littletiles.common.packet.entity.LittleVanillaPacket;
import team.creative.littletiles.mixin.server.network.ServerGamePacketListenerImplAccessor;
import team.creative.littletiles.server.player.LittleServerPlayerConnection;

public class LittleServerPlayerHandler
implements ServerPlayerConnection,
TickablePacketListener,
ServerGamePacketListener {
    private static final Logger LOGGER = LittleTiles.LOGGER;
    private final MinecraftServer server;
    public final ServerPlayer player;
    public Level level;
    private boolean isDestroyingBlock;
    private int destroyProgressStart;
    private BlockPos destroyPos = BlockPos.f_121853_;
    private Level destroyLevel;
    private int gameTicks;
    private boolean hasDelayedDestroy;
    private BlockPos delayedDestroyPos = BlockPos.f_121853_;
    private int delayedTickStart;
    private int lastSentState = -1;
    private Object2IntMap<Level> ackBlockChanges = new Object2IntArrayMap();

    LittleServerPlayerHandler(ServerPlayer player) {
        this.server = player.m_20194_();
        this.player = player;
    }

    public void ensureRunningOnSameThread(Packet packet) throws RunningOnDifferentThreadException {
        if (!this.server.m_18695_()) {
            this.server.m_201446_(() -> LittleServerPlayerConnection.runInContext((LittleLevel)this.level, this.player, x -> packet.m_5797_((PacketListener)x)));
            throw RunningOnDifferentThreadException.f_136017_;
        }
    }

    public ServerLevel requiresServerLevel() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel s = (ServerLevel)level;
            return s;
        }
        throw new RuntimeException("Cannot run this packet on this level " + this.level);
    }

    public ServerPlayer m_142253_() {
        return this.player;
    }

    public ServerGamePacketListenerImpl getVanilla() {
        return this.player.f_8906_;
    }

    public void m_5918_(ServerboundPlayerInputPacket packet) {
        this.getVanilla().m_5918_(packet);
    }

    public void m_5659_(ServerboundMoveVehiclePacket packet) {
        this.getVanilla().m_5659_(packet);
    }

    public void m_7376_(ServerboundAcceptTeleportationPacket packet) {
        this.getVanilla().m_7376_(packet);
    }

    public void m_7411_(ServerboundRecipeBookSeenRecipePacket packet) {
        this.getVanilla().m_7411_(packet);
    }

    public void m_7982_(ServerboundRecipeBookChangeSettingsPacket packet) {
        this.getVanilla().m_7982_(packet);
    }

    public void m_6947_(ServerboundSeenAdvancementsPacket packet) {
        this.getVanilla().m_6947_(packet);
    }

    public void m_7741_(ServerboundCommandSuggestionPacket packet) {
        this.getVanilla().m_7741_(packet);
    }

    public void m_7192_(ServerboundSetCommandBlockPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        if (!this.server.m_6993_()) {
            this.player.m_213846_((Component)Component.m_237115_((String)"advMode.notEnabled"));
        } else if (!this.player.m_36337_()) {
            this.player.m_213846_((Component)Component.m_237115_((String)"advMode.notAllowed"));
        } else {
            BaseCommandBlock basecommandblock = null;
            CommandBlockEntity commandblockentity = null;
            BlockPos blockpos = packet.m_134521_();
            BlockEntity blockentity = this.level.m_7702_(blockpos);
            if (blockentity instanceof CommandBlockEntity) {
                commandblockentity = (CommandBlockEntity)blockentity;
                basecommandblock = commandblockentity.m_59141_();
            }
            String s = packet.m_134524_();
            boolean flag = packet.m_134525_();
            if (basecommandblock != null) {
                CommandBlockEntity.Mode commandblockentity$mode = commandblockentity.m_59148_();
                BlockState blockstate = this.level.m_8055_(blockpos);
                Direction direction = (Direction)blockstate.m_61143_((Property)CommandBlock.f_51793_);
                BlockState blockstate1 = switch (packet.m_134528_()) {
                    case CommandBlockEntity.Mode.SEQUENCE -> Blocks.f_50448_.m_49966_();
                    case CommandBlockEntity.Mode.AUTO -> Blocks.f_50447_.m_49966_();
                    default -> Blocks.f_50272_.m_49966_();
                };
                BlockState blockstate2 = (BlockState)((BlockState)blockstate1.m_61124_((Property)CommandBlock.f_51793_, (Comparable)direction)).m_61124_((Property)CommandBlock.f_51794_, (Comparable)Boolean.valueOf(packet.m_134526_()));
                if (blockstate2 != blockstate) {
                    this.level.m_7731_(blockpos, blockstate2, 2);
                    blockentity.m_155250_(blockstate2);
                    this.level.m_46745_(blockpos).m_142169_(blockentity);
                }
                basecommandblock.m_6590_(s);
                basecommandblock.m_45428_(flag);
                if (!flag) {
                    basecommandblock.m_45433_((Component)null);
                }
                commandblockentity.m_59137_(packet.m_134527_());
                if (commandblockentity$mode != packet.m_134528_()) {
                    commandblockentity.m_59144_();
                }
                basecommandblock.m_7368_();
                if (!StringUtil.m_14408_((String)s)) {
                    this.player.m_213846_((Component)Component.m_237110_((String)"advMode.setCommand.success", (Object[])new Object[]{s}));
                }
            }
        }
    }

    public void m_6629_(ServerboundSetCommandMinecartPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        if (!this.server.m_6993_()) {
            this.player.m_213846_((Component)Component.m_237115_((String)"advMode.notEnabled"));
        } else if (!this.player.m_36337_()) {
            this.player.m_213846_((Component)Component.m_237115_((String)"advMode.notAllowed"));
        } else {
            BaseCommandBlock basecommandblock = packet.m_134537_(this.level);
            if (basecommandblock != null) {
                basecommandblock.m_6590_(packet.m_134545_());
                basecommandblock.m_45428_(packet.m_134548_());
                if (!packet.m_134548_()) {
                    basecommandblock.m_45433_((Component)null);
                }
                basecommandblock.m_7368_();
                this.player.m_213846_((Component)Component.m_237110_((String)"advMode.setCommand.success", (Object[])new Object[]{packet.m_134545_()}));
            }
        }
    }

    public void m_7965_(ServerboundPickItemPacket packet) {
        this.getVanilla().m_7965_(packet);
    }

    public void m_5591_(ServerboundRenameItemPacket packet) {
        this.getVanilla().m_5591_(packet);
    }

    public void m_5712_(ServerboundSetBeaconPacket packet) {
        this.getVanilla().m_5712_(packet);
    }

    public void m_7424_(ServerboundSetStructureBlockPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        ServerLevel level = this.requiresServerLevel();
        if (this.player.m_36337_()) {
            BlockPos blockpos = packet.m_134629_();
            BlockState blockstate = level.m_8055_(blockpos);
            BlockEntity blockentity = level.m_7702_(blockpos);
            if (blockentity instanceof StructureBlockEntity) {
                StructureBlockEntity structure = (StructureBlockEntity)blockentity;
                structure.m_59860_(packet.m_134633_());
                structure.m_59868_(packet.m_134634_());
                structure.m_59885_(packet.m_134635_());
                structure.m_155797_(packet.m_179787_());
                structure.m_59881_(packet.m_134637_());
                structure.m_59883_(packet.m_134638_());
                structure.m_59887_(packet.m_134639_());
                structure.m_59876_(packet.m_134640_());
                structure.m_59896_(packet.m_134641_());
                structure.m_59898_(packet.m_134642_());
                structure.m_59838_(packet.m_134643_());
                structure.m_59840_(packet.m_134644_());
                if (structure.m_59901_()) {
                    String s = structure.m_59895_();
                    if (packet.m_134632_() == StructureBlockEntity.UpdateType.SAVE_AREA) {
                        if (structure.m_59830_()) {
                            this.player.m_5661_((Component)Component.m_237110_((String)"structure_block.save_success", (Object[])new Object[]{s}), false);
                        } else {
                            this.player.m_5661_((Component)Component.m_237110_((String)"structure_block.save_failure", (Object[])new Object[]{s}), false);
                        }
                    } else if (packet.m_134632_() == StructureBlockEntity.UpdateType.LOAD_AREA) {
                        if (!structure.m_59832_()) {
                            this.player.m_5661_((Component)Component.m_237110_((String)"structure_block.load_not_found", (Object[])new Object[]{s}), false);
                        } else if (structure.m_59842_(level)) {
                            this.player.m_5661_((Component)Component.m_237110_((String)"structure_block.load_success", (Object[])new Object[]{s}), false);
                        } else {
                            this.player.m_5661_((Component)Component.m_237110_((String)"structure_block.load_prepare", (Object[])new Object[]{s}), false);
                        }
                    } else if (packet.m_134632_() == StructureBlockEntity.UpdateType.SCAN_AREA) {
                        if (structure.m_59829_()) {
                            this.player.m_5661_((Component)Component.m_237110_((String)"structure_block.size_success", (Object[])new Object[]{s}), false);
                        } else {
                            this.player.m_5661_((Component)Component.m_237115_((String)"structure_block.size_failure"), false);
                        }
                    }
                } else {
                    this.player.m_5661_((Component)Component.m_237110_((String)"structure_block.invalid_structure_name", (Object[])new Object[]{packet.m_134634_()}), false);
                }
                structure.m_6596_();
                level.m_7260_(blockpos, blockstate, blockstate, 3);
            }
        }
    }

    public void m_8019_(ServerboundSetJigsawBlockPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        if (this.player.m_36337_()) {
            BlockPos blockpos = packet.m_134585_();
            BlockState blockstate = this.level.m_8055_(blockpos);
            BlockEntity blockentity = this.level.m_7702_(blockpos);
            if (blockentity instanceof JigsawBlockEntity) {
                JigsawBlockEntity jigsaw = (JigsawBlockEntity)blockentity;
                jigsaw.m_59435_(packet.m_134588_());
                jigsaw.m_59438_(packet.m_134589_());
                jigsaw.m_222763_(ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)packet.m_134590_()));
                jigsaw.m_59431_(packet.m_134591_());
                jigsaw.m_59424_(packet.m_134592_());
                jigsaw.m_6596_();
                this.level.m_7260_(blockpos, blockstate, blockstate, 3);
            }
        }
    }

    public void m_6449_(ServerboundJigsawGeneratePacket packet) {
        BlockEntity blockentity;
        this.ensureRunningOnSameThread((Packet)packet);
        ServerLevel level = this.requiresServerLevel();
        if (this.player.m_36337_() && (blockentity = level.m_7702_(packet.m_134087_())) instanceof JigsawBlockEntity) {
            JigsawBlockEntity jigsawblockentity = (JigsawBlockEntity)blockentity;
            jigsawblockentity.m_59420_(level, packet.m_134090_(), packet.m_134091_());
        }
    }

    public void m_6321_(ServerboundSelectTradePacket packet) {
        this.getVanilla().m_6321_(packet);
    }

    public void m_6829_(ServerboundEditBookPacket packet) {
        this.getVanilla().m_6829_(packet);
    }

    public void m_7548_(ServerboundEntityTagQuery packet) {
        Entity entity;
        this.ensureRunningOnSameThread((Packet)packet);
        if (this.player.m_20310_(2) && (entity = this.level.m_6815_(packet.m_134029_())) != null) {
            this.m_9829_((Packet<?>)new ClientboundTagQueryPacket(packet.m_134026_(), entity.m_20240_(new CompoundTag())));
        }
    }

    public void m_6780_(ServerboundBlockEntityTagQuery packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        if (this.player.m_20310_(2)) {
            BlockEntity blockentity = this.level.m_7702_(packet.m_133813_());
            CompoundTag compoundtag = blockentity != null ? blockentity.m_187482_() : null;
            this.m_9829_((Packet<?>)new ClientboundTagQueryPacket(packet.m_133810_(), compoundtag));
        }
    }

    public void m_7185_(ServerboundMovePlayerPacket packet) {
        this.getVanilla().m_7185_(packet);
    }

    public void m_7502_(ServerboundPlayerActionPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        BlockPos blockpos = packet.m_134281_();
        this.player.m_9243_();
        switch (packet.m_134285_()) {
            case SWAP_ITEM_WITH_OFFHAND: 
            case DROP_ITEM: 
            case DROP_ALL_ITEMS: 
            case RELEASE_USE_ITEM: {
                this.getVanilla().m_7502_(packet);
                return;
            }
            case START_DESTROY_BLOCK: 
            case ABORT_DESTROY_BLOCK: 
            case STOP_DESTROY_BLOCK: {
                this.handleBlockBreakAction(blockpos, packet.m_134285_(), packet.m_134284_(), this.level.m_151558_(), packet.m_237987_());
                this.ackBlockChangesUpTo(this.level, packet.m_237987_());
                return;
            }
        }
        throw new IllegalArgumentException("Invalid player action");
    }

    private static boolean wasBlockPlacementAttempt(ServerPlayer player, ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        Item item = stack.m_41720_();
        return (item instanceof BlockItem || item instanceof BucketItem) && !player.m_36335_().m_41519_(item);
    }

    public void m_6371_(ServerboundUseItemOnPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        this.ackBlockChangesUpTo(this.level, packet.m_238008_());
        this.player.f_8906_.m_215201_(packet.m_238008_());
        InteractionHand interactionhand = packet.m_134703_();
        ItemStack itemstack = this.player.m_21120_(interactionhand);
        if (itemstack.m_246617_(this.level.m_246046_())) {
            BlockHitResult blockhitresult = packet.m_134706_();
            Vec3 vec3 = blockhitresult.m_82450_();
            BlockPos blockpos = blockhitresult.m_82425_();
            Vec3 vec31 = Vec3.m_82512_((Vec3i)blockpos);
            if (this.player.canReach(blockpos, 1.5)) {
                Vec3 vec32 = vec3.m_82546_(vec31);
                if (Math.abs(vec32.m_7096_()) < 1.0000001 && Math.abs(vec32.m_7098_()) < 1.0000001 && Math.abs(vec32.m_7094_()) < 1.0000001) {
                    Direction direction = blockhitresult.m_82434_();
                    this.player.m_9243_();
                    int i = this.level.m_151558_();
                    if (blockpos.m_123342_() < i) {
                        if (((ServerGamePacketListenerImplAccessor)this.getVanilla()).getAwaitingPositionFromClient() == null && this.level.m_7966_((Player)this.player, blockpos)) {
                            InteractionResult interactionresult = this.player.f_8941_.m_7179_(this.player, this.level, itemstack, interactionhand, blockhitresult);
                            if (direction == Direction.UP && !interactionresult.m_19077_() && blockpos.m_123342_() >= i - 1 && LittleServerPlayerHandler.wasBlockPlacementAttempt(this.player, itemstack)) {
                                MutableComponent component = Component.m_237110_((String)"build.tooHigh", (Object[])new Object[]{i - 1}).m_130940_(ChatFormatting.RED);
                                this.player.m_240418_((Component)component, true);
                            } else if (interactionresult.m_19080_()) {
                                this.player.m_21011_(interactionhand, true);
                            }
                        }
                    } else {
                        MutableComponent component1 = Component.m_237110_((String)"build.tooHigh", (Object[])new Object[]{i - 1}).m_130940_(ChatFormatting.RED);
                        this.player.m_240418_((Component)component1, true);
                    }
                    this.send(this.level, (Packet<?>)new ClientboundBlockUpdatePacket((BlockGetter)this.level, blockpos));
                    this.send(this.level, (Packet<?>)new ClientboundBlockUpdatePacket((BlockGetter)this.level, blockpos.m_121945_(direction)));
                } else {
                    LOGGER.warn("Rejecting UseItemOnPacket from {}: Location {} too far away from hit block {}.", (Object)this.player.m_36316_().getName(), (Object)vec3, (Object)blockpos);
                }
            }
        }
    }

    public void m_5760_(ServerboundUseItemPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        this.ackBlockChangesUpTo(this.level, packet.m_238013_());
        InteractionHand interactionhand = packet.m_134717_();
        ItemStack itemstack = this.player.m_21120_(interactionhand);
        this.player.m_9243_();
        if (!itemstack.m_41619_() && itemstack.m_246617_(this.level.m_246046_()) && this.useItem(this.level, itemstack, interactionhand).m_19080_()) {
            this.player.m_21011_(interactionhand, true);
        }
    }

    public void m_6936_(ServerboundTeleportToEntityPacket packet) {
        this.getVanilla().m_6936_(packet);
    }

    public void m_7529_(ServerboundResourcePackPacket packet) {
        this.getVanilla().m_7529_(packet);
    }

    public void m_5938_(ServerboundPaddleBoatPacket packet) {
        this.getVanilla().m_5938_(packet);
    }

    public void m_142110_(ServerboundPongPacket packet) {
        this.getVanilla().m_142110_(packet);
    }

    public void m_7026_(Component component) {
        this.getVanilla().m_7026_(component);
    }

    public void ackBlockChangesUpTo(Level level, int sequence) {
        if (sequence < 0) {
            throw new IllegalArgumentException("Expected packet sequence nr >= 0");
        }
        this.ackBlockChanges.put((Object)level, Math.max(sequence, this.ackBlockChanges.getOrDefault((Object)level, -1)));
    }

    public void m_9829_(Packet<?> packet) {
        this.send(this.level, packet);
    }

    public void send(Level level, Packet<?> packet) {
        this.send(level, packet, null);
    }

    public void send(Level level, Packet<?> packet, @Nullable PacketSendListener listener) {
        try {
            LittleTiles.NETWORK.sendToClient((CreativePacket)new LittleVanillaPacket((LittleLevel)level, packet), this.player);
            if (listener != null) {
                listener.m_243096_();
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Sending packet");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Packet being sent");
            crashreportcategory.m_128165_("Packet class", () -> packet.getClass().getCanonicalName());
            throw new ReportedException(crashreport);
        }
    }

    public void m_7798_(ServerboundSetCarriedItemPacket packet) {
        this.getVanilla().m_7798_(packet);
    }

    public void m_7388_(ServerboundChatPacket packet) {
        this.getVanilla().m_7388_(packet);
    }

    public void m_214047_(ServerboundChatCommandPacket packet) {
        this.getVanilla().m_214047_(packet);
    }

    public void m_241885_(ServerboundChatAckPacket packet) {
        this.getVanilla().m_241885_(packet);
    }

    public void m_7953_(ServerboundSwingPacket packet) {
        this.getVanilla().m_7953_(packet);
    }

    public void m_5681_(ServerboundPlayerCommandPacket packet) {
        this.getVanilla().m_5681_(packet);
    }

    public void m_6946_(ServerboundInteractPacket packet) {
        this.getVanilla().m_6946_(packet);
    }

    public void m_6272_(ServerboundClientCommandPacket packet) {
        this.getVanilla().m_6272_(packet);
    }

    public void m_7951_(ServerboundContainerClosePacket packet) {
        this.getVanilla().m_7951_(packet);
    }

    public void m_5914_(ServerboundContainerClickPacket packet) {
        this.getVanilla().m_5914_(packet);
    }

    public void m_7191_(ServerboundPlaceRecipePacket packet) {
        this.getVanilla().m_7191_(packet);
    }

    public void m_6557_(ServerboundContainerButtonClickPacket packet) {
        this.getVanilla().m_6557_(packet);
    }

    public void m_5964_(ServerboundSetCreativeModeSlotPacket packet) {
        this.getVanilla().m_5964_(packet);
    }

    public void m_5527_(ServerboundSignUpdatePacket packet) {
        List<String> list = Stream.of(packet.m_134663_()).map(ChatFormatting::m_126649_).collect(Collectors.toList());
        ((ServerGamePacketListenerImplAccessor)this.getVanilla()).callFilterTextPacket(list).thenAcceptAsync(lines -> this.updateSignText(packet, (List<FilteredText>)lines), (Executor)this.server);
    }

    private void updateSignText(ServerboundSignUpdatePacket packet, List<FilteredText> lines) {
        this.player.m_9243_();
        BlockPos blockpos = packet.m_134660_();
        if (this.level.m_46805_(blockpos)) {
            BlockEntity blockentity = this.level.m_7702_(blockpos);
            if (!(blockentity instanceof SignBlockEntity)) {
                return;
            }
            SignBlockEntity signblockentity = (SignBlockEntity)blockentity;
            signblockentity.m_277134_((Player)this.player, packet.m_276788_(), lines);
        }
    }

    public void m_5683_(ServerboundKeepAlivePacket packet) {
        this.getVanilla().m_5683_(packet);
    }

    public void m_6828_(ServerboundPlayerAbilitiesPacket packet) {
        this.getVanilla().m_6828_(packet);
    }

    public void m_5617_(ServerboundClientInformationPacket packet) {
        this.getVanilla().m_5617_(packet);
    }

    public void m_7423_(ServerboundCustomPayloadPacket packet) {
        this.getVanilla().m_7423_(packet);
    }

    public void m_7477_(ServerboundChangeDifficultyPacket packet) {
        this.getVanilla().m_7477_(packet);
    }

    public void m_7728_(ServerboundLockDifficultyPacket packet) {
        this.getVanilla().m_7728_(packet);
    }

    public void m_252797_(ServerboundChatSessionUpdatePacket packet) {
        this.getVanilla().m_252797_(packet);
    }

    public void m_9933_() {
        if (!this.ackBlockChanges.isEmpty()) {
            for (Object2IntMap.Entry entry : this.ackBlockChanges.object2IntEntrySet()) {
                this.send((Level)entry.getKey(), (Packet<?>)new ClientboundBlockChangedAckPacket(entry.getIntValue()));
            }
            this.ackBlockChanges.clear();
        }
        ++this.gameTicks;
        if (this.hasDelayedDestroy) {
            BlockState blockstate = this.destroyLevel.m_8055_(this.delayedDestroyPos);
            if (blockstate.m_60795_()) {
                this.hasDelayedDestroy = false;
            } else {
                float f = this.incrementDestroyProgress(this.destroyLevel, blockstate, this.delayedDestroyPos, this.delayedTickStart);
                if (f >= 1.0f) {
                    this.hasDelayedDestroy = false;
                    this.destroyBlock(this.destroyLevel, this.delayedDestroyPos);
                    this.destroyLevel = null;
                }
            }
        } else if (this.isDestroyingBlock) {
            BlockState blockstate1 = this.destroyLevel.m_8055_(this.destroyPos);
            if (blockstate1.m_60795_()) {
                this.destroyLevel.m_6801_(this.player.m_19879_(), this.destroyPos, -1);
                this.lastSentState = -1;
                this.isDestroyingBlock = false;
                this.destroyLevel = null;
            } else {
                this.incrementDestroyProgress(this.destroyLevel, blockstate1, this.destroyPos, this.destroyProgressStart);
            }
        }
    }

    private float incrementDestroyProgress(Level level, BlockState state, BlockPos pos, int ticks) {
        int i = this.gameTicks - ticks;
        float f = state.m_60625_((Player)this.player, (BlockGetter)level, pos) * (float)(i + 1);
        int j = (int)(f * 10.0f);
        if (j != this.lastSentState) {
            level.m_6801_(this.player.m_19879_(), pos, j);
            this.lastSentState = j;
        }
        return f;
    }

    private void debugLogging(BlockPos pos, boolean p_215127_, int sequence, String message) {
    }

    public boolean isCreative() {
        return this.player.m_7500_();
    }

    public GameType getGameMode() {
        return this.player.f_8941_.m_9290_();
    }

    public void handleBlockBreakAction(BlockPos pos, ServerboundPlayerActionPacket.Action action, Direction direction, int buildHeight, int sequence) {
        PlayerInteractEvent.LeftClickBlock event = ForgeHooks.onLeftClickBlock((Player)this.player, (BlockPos)pos, (Direction)direction);
        if (event.isCanceled() || !this.isCreative() && event.getResult() == Event.Result.DENY) {
            return;
        }
        if (!this.player.canReach(pos, 1.5)) {
            this.debugLogging(pos, false, sequence, "too far");
        } else if (pos.m_123342_() >= buildHeight) {
            this.m_9829_((Packet<?>)new ClientboundBlockUpdatePacket(pos, this.level.m_8055_(pos)));
            this.debugLogging(pos, false, sequence, "too high");
        } else if (action == ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK) {
            if (!this.level.m_7966_((Player)this.player, pos)) {
                this.m_9829_((Packet<?>)new ClientboundBlockUpdatePacket(pos, this.level.m_8055_(pos)));
                this.debugLogging(pos, false, sequence, "may not interact");
                return;
            }
            if (this.isCreative()) {
                this.destroyAndAck(this.level, pos, sequence, "creative destroy");
                return;
            }
            if (this.player.m_36187_(this.level, pos, this.getGameMode())) {
                this.m_9829_((Packet<?>)new ClientboundBlockUpdatePacket(pos, this.level.m_8055_(pos)));
                this.debugLogging(pos, false, sequence, "block action restricted");
                return;
            }
            this.destroyProgressStart = this.gameTicks;
            float f = 1.0f;
            BlockState blockstate = this.level.m_8055_(pos);
            if (!blockstate.m_60795_()) {
                if (event.getUseBlock() != Event.Result.DENY) {
                    blockstate.m_60686_(this.level, pos, (Player)this.player);
                }
                f = blockstate.m_60625_((Player)this.player, (BlockGetter)this.level, pos);
            }
            if (!blockstate.m_60795_() && f >= 1.0f) {
                this.destroyAndAck(this.level, pos, sequence, "insta mine");
            } else {
                if (this.isDestroyingBlock) {
                    this.m_9829_((Packet<?>)new ClientboundBlockUpdatePacket(this.destroyPos, this.level.m_8055_(this.destroyPos)));
                    this.debugLogging(pos, false, sequence, "abort destroying since another started (client insta mine, server disagreed)");
                }
                this.isDestroyingBlock = true;
                this.destroyPos = pos.m_7949_();
                this.destroyLevel = this.level;
                int i = (int)(f * 10.0f);
                this.level.m_6801_(this.player.m_19879_(), pos, i);
                this.debugLogging(pos, true, sequence, "actual start of destroying");
                this.lastSentState = i;
            }
        } else if (action == ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK) {
            if (pos.equals((Object)this.destroyPos) && this.destroyLevel == this.level) {
                int j = this.gameTicks - this.destroyProgressStart;
                BlockState blockstate1 = this.level.m_8055_(pos);
                if (!blockstate1.m_60795_()) {
                    float f1 = blockstate1.m_60625_((Player)this.player, (BlockGetter)this.level, pos) * (float)(j + 1);
                    if (f1 >= 0.7f) {
                        this.isDestroyingBlock = false;
                        this.level.m_6801_(this.player.m_19879_(), pos, -1);
                        this.destroyAndAck(this.level, pos, sequence, "destroyed");
                        this.destroyLevel = null;
                        return;
                    }
                    if (!this.hasDelayedDestroy) {
                        this.isDestroyingBlock = false;
                        this.hasDelayedDestroy = true;
                        this.delayedDestroyPos = pos;
                        this.delayedTickStart = this.destroyProgressStart;
                        this.destroyLevel = null;
                    }
                }
            }
            this.debugLogging(pos, true, sequence, "stopped destroying");
        } else if (action == ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK) {
            this.isDestroyingBlock = false;
            if (!Objects.equals(this.destroyPos, pos)) {
                LOGGER.warn("Mismatch in destroy block pos: {} {}", (Object)this.destroyPos, (Object)pos);
                this.destroyLevel.m_6801_(this.player.m_19879_(), this.destroyPos, -1);
                this.debugLogging(pos, true, sequence, "aborted mismatched destroying");
            }
            if (!Objects.equals(this.destroyLevel, this.level)) {
                LOGGER.warn("Mismatch in destroy level: {} {}", (Object)this.destroyLevel, (Object)this.level);
                this.destroyLevel.m_6801_(this.player.m_19879_(), this.destroyPos, -1);
                this.debugLogging(pos, true, sequence, "aborted mismatched destroying");
            }
            this.destroyLevel.m_6801_(this.player.m_19879_(), pos, -1);
            this.destroyLevel = null;
            this.debugLogging(pos, true, sequence, "aborted destroying");
        }
    }

    public void destroyAndAck(Level level, BlockPos pos, int sequence, String message) {
        if (this.destroyBlock(level, pos)) {
            this.debugLogging(pos, true, sequence, message);
        } else {
            this.send(level, (Packet<?>)new ClientboundBlockUpdatePacket(pos, level.m_8055_(pos)));
            this.debugLogging(pos, false, sequence, message);
        }
    }

    public boolean destroyBlock(Level level, BlockPos pos) {
        boolean flag;
        BlockState blockstate = level.m_8055_(pos);
        int exp = this.onBlockBreakEvent(level, this.getGameMode(), pos);
        if (exp == -1) {
            return false;
        }
        BlockEntity blockentity = level.m_7702_(pos);
        Block block = blockstate.m_60734_();
        if (block instanceof GameMasterBlock && !this.player.m_36337_()) {
            level.m_7260_(pos, blockstate, blockstate, 3);
            return false;
        }
        if (this.player.m_21205_().onBlockStartBreak(pos, (Player)this.player)) {
            return false;
        }
        if (this.player.m_36187_(level, pos, this.getGameMode())) {
            return false;
        }
        if (this.isCreative()) {
            this.removeBlock(level, pos, false);
            return true;
        }
        ItemStack itemstack = this.player.m_21205_();
        ItemStack itemstack1 = itemstack.m_41777_();
        boolean flag1 = blockstate.canHarvestBlock((BlockGetter)level, pos, (Player)this.player);
        itemstack.m_41686_(level, blockstate, pos, (Player)this.player);
        if (itemstack.m_41619_() && !itemstack1.m_41619_()) {
            ForgeEventFactory.onPlayerDestroyItem((Player)this.player, (ItemStack)itemstack1, (InteractionHand)InteractionHand.MAIN_HAND);
        }
        if ((flag = this.removeBlock(level, pos, flag1)) && flag1) {
            block.m_6240_(level, (Player)this.player, pos, blockstate, blockentity, itemstack1);
        }
        if (flag && exp > 0 && level instanceof ServerLevel) {
            ServerLevel s = (ServerLevel)level;
            blockstate.m_60734_().m_49805_(s, pos, exp);
        }
        return true;
    }

    private boolean removeBlock(Level level, BlockPos pos, boolean canHarvest) {
        BlockState state = level.m_8055_(pos);
        boolean removed = state.onDestroyedByPlayer(level, pos, (Player)this.player, canHarvest, level.m_6425_(pos));
        if (removed) {
            state.m_60734_().m_6786_((LevelAccessor)level, pos, state);
        }
        return removed;
    }

    public int onBlockBreakEvent(Level level, GameType gameType, BlockPos pos) {
        boolean preCancelEvent = false;
        ItemStack itemstack = this.player.m_21205_();
        if (!itemstack.m_41619_() && !itemstack.m_41720_().m_6777_(level.m_8055_(pos), level, pos, (Player)this.player)) {
            preCancelEvent = true;
        }
        if (gameType.m_46407_()) {
            if (gameType == GameType.SPECTATOR) {
                preCancelEvent = true;
            }
            if (!this.player.m_36326_() && itemstack.m_41619_() || !itemstack.m_204128_(level.m_9598_().m_175515_(Registries.f_256747_), new BlockInWorld((LevelReader)level, pos, false))) {
                preCancelEvent = true;
            }
        }
        if (level.m_7702_(pos) == null) {
            this.send(level, (Packet<?>)new ClientboundBlockUpdatePacket(pos, level.m_6425_(pos).m_76188_()));
        }
        BlockState state = level.m_8055_(pos);
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(level, pos, state, (Player)this.player);
        event.setCanceled(preCancelEvent);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            Packet pkt;
            this.send(level, (Packet<?>)new ClientboundBlockUpdatePacket((BlockGetter)level, pos));
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity != null && (pkt = blockEntity.m_58483_()) != null) {
                this.send(level, pkt);
            }
        }
        return event.isCanceled() ? -1 : event.getExpToDrop();
    }

    public InteractionResult useItem(Level level, ItemStack stack, InteractionHand hand) {
        if (this.getGameMode() == GameType.SPECTATOR) {
            return InteractionResult.PASS;
        }
        if (this.player.m_36335_().m_41519_(stack.m_41720_())) {
            return InteractionResult.PASS;
        }
        InteractionResult cancelResult = ForgeHooks.onItemRightClick((Player)this.player, (InteractionHand)hand);
        if (cancelResult != null) {
            return cancelResult;
        }
        int i = stack.m_41613_();
        int j = stack.m_41773_();
        InteractionResultHolder result = stack.m_41682_(level, (Player)this.player, hand);
        ItemStack itemstack = (ItemStack)result.m_19095_();
        if (itemstack == stack && itemstack.m_41613_() == i && itemstack.m_41779_() <= 0 && itemstack.m_41773_() == j) {
            return result.m_19089_();
        }
        if (result.m_19089_() == InteractionResult.FAIL && itemstack.m_41779_() > 0 && !this.player.m_6117_()) {
            return result.m_19089_();
        }
        if (stack != itemstack) {
            this.player.m_21008_(hand, itemstack);
        }
        if (this.isCreative()) {
            itemstack.m_41764_(i);
            if (itemstack.m_41763_() && itemstack.m_41773_() != j) {
                itemstack.m_41721_(j);
            }
        }
        if (itemstack.m_41619_()) {
            this.player.m_21008_(hand, ItemStack.f_41583_);
        }
        if (!this.player.m_6117_()) {
            this.player.f_36095_.m_150429_();
        }
        return result.m_19089_();
    }

    public InteractionResult useItemOn(Level level, ItemStack stack, InteractionHand hand, BlockHitResult hit) {
        InteractionResult interactionresult;
        InteractionResult result;
        BlockPos blockpos = hit.m_82425_();
        BlockState blockstate = level.m_8055_(blockpos);
        if (!blockstate.m_60734_().m_245993_(level.m_246046_())) {
            return InteractionResult.FAIL;
        }
        PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((Player)this.player, (InteractionHand)hand, (BlockPos)blockpos, (BlockHitResult)hit);
        if (event.isCanceled()) {
            return event.getCancellationResult();
        }
        if (this.getGameMode() == GameType.SPECTATOR) {
            MenuProvider menuprovider = blockstate.m_60750_(level, blockpos);
            if (menuprovider != null) {
                this.player.m_5893_(menuprovider);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        UseOnContext useoncontext = new UseOnContext(level, (Player)this.player, hand, stack, hit);
        if (event.getUseItem() != Event.Result.DENY && (result = stack.onItemUseFirst(useoncontext)) != InteractionResult.PASS) {
            return result;
        }
        boolean flag = !this.player.m_21205_().m_41619_() || !this.player.m_21206_().m_41619_();
        boolean flag1 = this.player.m_36341_() && flag && (!this.player.m_21205_().doesSneakBypassUse((LevelReader)level, blockpos, (Player)this.player) || !this.player.m_21206_().doesSneakBypassUse((LevelReader)level, blockpos, (Player)this.player));
        ItemStack itemstack = stack.m_41777_();
        if ((event.getUseBlock() == Event.Result.ALLOW || event.getUseBlock() != Event.Result.DENY && !flag1) && (interactionresult = blockstate.m_60664_(level, (Player)this.player, hand, hit)).m_19077_()) {
            CriteriaTriggers.f_10562_.m_285767_(this.player, blockpos, itemstack);
            return interactionresult;
        }
        if (event.getUseItem() == Event.Result.ALLOW || !stack.m_41619_() && !this.player.m_36335_().m_41519_(stack.m_41720_())) {
            InteractionResult interactionresult1;
            if (event.getUseItem() == Event.Result.DENY) {
                return InteractionResult.PASS;
            }
            if (this.isCreative()) {
                int i = stack.m_41613_();
                interactionresult1 = stack.m_41661_(useoncontext);
                stack.m_41764_(i);
            } else {
                interactionresult1 = stack.m_41661_(useoncontext);
            }
            if (interactionresult1.m_19077_()) {
                CriteriaTriggers.f_10562_.m_285767_(this.player, blockpos, itemstack);
            }
            return interactionresult1;
        }
        return InteractionResult.PASS;
    }

    public boolean m_6198_() {
        return this.getVanilla().m_6198_();
    }

    @FunctionalInterface
    static interface EntityInteraction {
        public InteractionResult run(ServerPlayer var1, Entity var2, InteractionHand var3);
    }
}

