/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.server.level.little;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockDestructionPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.util.math.matrix.IVecOrigin;
import team.creative.littletiles.client.render.entity.LittleEntityRenderManager;
import team.creative.littletiles.common.level.little.LevelBlockChangeListener;
import team.creative.littletiles.common.level.little.LittleLevel;
import team.creative.littletiles.common.level.little.LittleSubLevel;
import team.creative.littletiles.mixin.server.level.MinecraftServerAccessor;
import team.creative.littletiles.server.level.little.LittleChunkProgressListener;
import team.creative.littletiles.server.level.little.LittleServerChunkCache;
import team.creative.littletiles.server.player.LittleServerPlayerConnection;

public abstract class LittleServerLevel
extends ServerLevel
implements LittleLevel {
    public Entity holder;
    public IVecOrigin origin;
    private final List<LevelBlockChangeListener> blockChangeListeners = new ArrayList<LevelBlockChangeListener>();
    public boolean hasChanged = false;
    public boolean preventNeighborUpdate = false;

    private static LevelStem overworldStem(MinecraftServer server) {
        Registry registry = server.m_247573_().m_247579_().m_175515_(Registries.f_256862_);
        return (LevelStem)registry.m_6246_(LevelStem.f_63971_);
    }

    protected LittleServerLevel(MinecraftServer server, ServerLevelData worldInfo, ResourceKey<Level> dimension, boolean debug, long seed, RegistryAccess access) {
        super(server, (Executor)Util.m_183991_(), ((MinecraftServerAccessor)server).getStorageSource(), worldInfo, dimension, LittleServerLevel.overworldStem(server), (ChunkProgressListener)LittleChunkProgressListener.INSTANCE, debug, seed, Collections.EMPTY_LIST, false, null);
    }

    @Override
    public void removeEntityById(int id, Entity.RemovalReason reason) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public LittleEntityRenderManager getRenderManager() {
        return null;
    }

    @Override
    public Entity getHolder() {
        return this.holder;
    }

    @Override
    public void setHolder(Entity entity) {
        this.holder = entity;
    }

    @Override
    public void registerBlockChangeListener(LevelBlockChangeListener listener) {
        this.blockChangeListeners.add(listener);
    }

    public void m_46586_(BlockPos pos, Block block, BlockPos fromPos) {
        if (this.preventNeighborUpdate) {
            return;
        }
        if (this.f_46443_) {
            BlockState blockstate = this.m_8055_(pos);
            try {
                blockstate.m_60690_((Level)this, pos, block, fromPos, false);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Exception while updating neighbours");
                CrashReportCategory crashreportcategory = crashreport.m_127514_("Block being updated");
                crashreportcategory.m_128165_("Source block type", () -> {
                    try {
                        return String.format("ID #%s (%s // %s)", BuiltInRegistries.f_256975_.m_7981_((Object)block), block.m_7705_(), block.getClass().getCanonicalName());
                    }
                    catch (Throwable throwable1) {
                        return "ID #" + BuiltInRegistries.f_256975_.m_7981_((Object)block);
                    }
                });
                CrashReportCategory.m_178950_((CrashReportCategory)crashreportcategory, (LevelHeightAccessor)this, (BlockPos)pos, (BlockState)blockstate);
                throw new ReportedException(crashreport);
            }
        } else {
            super.m_46586_(pos, block, fromPos);
        }
    }

    public void m_46590_(BlockPos pos, Block block, Direction facing) {
        if (this.preventNeighborUpdate) {
            return;
        }
        super.m_46590_(pos, block, facing);
    }

    public void m_46672_(BlockPos pos, Block block) {
        if (this.preventNeighborUpdate) {
            return;
        }
        super.m_46672_(pos, block);
    }

    public void m_6550_(BlockPos pos, BlockState actualState, BlockState setState) {
        this.blockChangeListeners.forEach(x -> x.blockChanged(pos, setState));
    }

    public LittleServerChunkCache getChunkSource() {
        return (LittleServerChunkCache)super.m_7726_();
    }

    @Override
    public void m_104665_(LevelChunk chunk) {
        super.m_8712_(chunk);
        this.getChunkSource().m_7827_().m_9335_(chunk.m_7697_(), false);
    }

    @Override
    public void unload() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int m_7354_() {
        return 0;
    }

    @Override
    public Iterable<Entity> entities() {
        return this.m_142646_().m_142273_();
    }

    @Override
    public void tick() {
        while (this.getChunkSource().m_8466_()) {
        }
        this.m_8793_(((MinecraftServerAccessor)this.m_7654_())::callHaveTime);
    }

    public void load(ChunkPos pos, CompoundTag nbt) {
        this.getChunkSource().loadLevelChunk(pos, nbt);
    }

    @Override
    public Iterable<? extends ChunkAccess> chunks() {
        return this.getChunkSource().all();
    }

    public void m_6801_(int id, BlockPos pos, int progress) {
        LittleServerLevel toCompare = this;
        LittleServerLevel littleServerLevel = this;
        if (littleServerLevel instanceof LittleSubLevel) {
            LittleSubLevel sub = (LittleSubLevel)((Object)littleServerLevel);
            toCompare = sub.getRealLevel();
        }
        for (ServerPlayer serverplayer : this.m_7654_().m_6846_().m_11314_()) {
            double d2;
            double d1;
            double d0;
            if (serverplayer == null || serverplayer.m_9236_() != toCompare || serverplayer.m_19879_() == id || !((d0 = (double)pos.m_123341_() - serverplayer.m_20185_()) * d0 + (d1 = (double)pos.m_123342_() - serverplayer.m_20186_()) * d1 + (d2 = (double)pos.m_123343_() - serverplayer.m_20189_()) * d2 < 1024.0)) continue;
            LittleServerPlayerConnection.send(this, serverplayer, (Packet)new ClientboundBlockDestructionPacket(id, pos, progress));
        }
    }
}

