/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.server.level.little;

import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.util.BitSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.lighting.LevelLightEngine;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.level.little.LittleLevel;
import team.creative.littletiles.common.packet.entity.LittleVanillaPacket;

public class LittleChunkHolder {
    public final LevelChunk chunk;
    private boolean hasChangedSections;
    private final ShortSet[] changedBlocksPerSection;
    private final BitSet blockChangedLightSectionFilter = new BitSet();
    private final BitSet skyChangedLightSectionFilter = new BitSet();
    private final LevelLightEngine lightEngine;

    public LittleChunkHolder(ServerLevel level, ChunkPos pos, LevelLightEngine lightEngine) {
        this(new LevelChunk((Level)level, pos), lightEngine);
    }

    public LittleChunkHolder(LevelChunk chunk, LevelLightEngine lightEngine) {
        this.chunk = chunk;
        this.changedBlocksPerSection = new ShortSet[chunk.m_62953_().m_151559_()];
        this.lightEngine = lightEngine;
    }

    public void blockChanged(BlockPos pos) {
        int i = this.chunk.m_62953_().m_151564_(pos.m_123342_());
        if (this.changedBlocksPerSection[i] == null) {
            this.hasChangedSections = true;
            this.changedBlocksPerSection[i] = new ShortOpenHashSet();
        }
        this.changedBlocksPerSection[i].add(SectionPos.m_123218_((BlockPos)pos));
    }

    public void sectionLightChanged(LightLayer layer, int y) {
        int i = this.lightEngine.m_164447_();
        int j = this.lightEngine.m_164448_();
        if (y >= i && y <= j) {
            int k = y - i;
            if (layer == LightLayer.SKY) {
                this.skyChangedLightSectionFilter.set(k);
            } else {
                this.blockChangedLightSectionFilter.set(k);
            }
        }
    }

    public void broadcastChanges() {
        if (this.hasChangedSections || !this.skyChangedLightSectionFilter.isEmpty() || !this.blockChangedLightSectionFilter.isEmpty()) {
            Level level = this.chunk.m_62953_();
            if (!this.skyChangedLightSectionFilter.isEmpty() || !this.blockChangedLightSectionFilter.isEmpty()) {
                ClientboundLightUpdatePacket clientboundlightupdatepacket = new ClientboundLightUpdatePacket(this.chunk.m_7697_(), this.lightEngine, this.skyChangedLightSectionFilter, this.blockChangedLightSectionFilter);
                this.broadcast((Packet<?>)clientboundlightupdatepacket);
                this.skyChangedLightSectionFilter.clear();
                this.blockChangedLightSectionFilter.clear();
            }
            if (this.hasChangedSections) {
                for (int j = 0; j < this.changedBlocksPerSection.length; ++j) {
                    ShortSet shortset = this.changedBlocksPerSection[j];
                    if (shortset == null) continue;
                    this.changedBlocksPerSection[j] = null;
                    int i = level.m_151568_(j);
                    SectionPos sectionpos = SectionPos.m_123196_((ChunkPos)this.chunk.m_7697_(), (int)i);
                    if (shortset.size() == 1) {
                        BlockPos blockpos = sectionpos.m_123245_(shortset.iterator().nextShort());
                        BlockState blockstate = level.m_8055_(blockpos);
                        this.broadcast((Packet<?>)new ClientboundBlockUpdatePacket(blockpos, blockstate));
                        this.broadcastBlockEntityIfNeeded(level, blockpos, blockstate);
                        continue;
                    }
                    LevelChunkSection levelchunksection = this.chunk.m_183278_(j);
                    ClientboundSectionBlocksUpdatePacket clientboundsectionblocksupdatepacket = new ClientboundSectionBlocksUpdatePacket(sectionpos, shortset, levelchunksection);
                    this.broadcast((Packet<?>)clientboundsectionblocksupdatepacket);
                    clientboundsectionblocksupdatepacket.m_132992_((pos, state) -> this.broadcastBlockEntityIfNeeded(level, (BlockPos)pos, (BlockState)state));
                }
                this.hasChangedSections = false;
            }
        }
    }

    private void broadcastBlockEntityIfNeeded(Level level, BlockPos pos, BlockState state) {
        if (state.m_155947_()) {
            this.broadcastBlockEntity(level, pos);
        }
    }

    private void broadcastBlockEntity(Level level, BlockPos pos) {
        Packet packet;
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity != null && (packet = blockentity.m_58483_()) != null) {
            this.broadcast(packet);
        }
    }

    private void broadcast(Packet<?> packet) {
        LittleTiles.NETWORK.sendToClientTracking((CreativePacket)new LittleVanillaPacket((LittleLevel)this.chunk.m_62953_(), packet), ((LittleLevel)this.chunk.m_62953_()).getHolder());
    }
}

