/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.server.level.little;

import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraftforge.server.ServerLifecycleHooks;
import team.creative.creativecore.common.util.math.matrix.IVecOrigin;
import team.creative.creativecore.common.util.math.matrix.VecOrigin;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.littletiles.client.level.little.FakeClientLevel;
import team.creative.littletiles.common.level.little.LittleLevel;
import team.creative.littletiles.server.level.little.FakeServerLevelInfo;
import team.creative.littletiles.server.level.little.LittleServerLevel;

public class FakeServerLevel
extends LittleServerLevel {
    private final ServerScoreboard scoreboard;
    private DimensionSpecialEffects effects;

    public static LittleLevel createFakeLevel(String name, boolean client) {
        if (client) {
            return FakeServerLevel.createClient(name);
        }
        return new FakeServerLevel(ServerLifecycleHooks.getCurrentServer(), new FakeServerLevelInfo(Difficulty.PEACEFUL, false, true), false, 0L);
    }

    public static FakeClientLevel createClient(String name) {
        return FakeClientLevel.createFakeWorldClient(name, new ClientLevel.ClientLevelData(Difficulty.PEACEFUL, false, true));
    }

    protected FakeServerLevel(MinecraftServer server, ServerLevelData worldInfo, boolean debug, long seed) {
        super(server, worldInfo, (ResourceKey<Level>)f_46428_, debug, seed, (RegistryAccess)server.m_206579_());
        this.scoreboard = new ServerScoreboard(server);
    }

    @Override
    public UUID key() {
        return null;
    }

    public IVecOrigin getOrigin() {
        return this.origin;
    }

    public void setOrigin(Vec3d vec) {
        this.origin = new VecOrigin(vec);
    }

    public Holder<Biome> m_203675_(int p_225604_1_, int p_225604_2_, int p_225604_3_) {
        return this.m_9598_().m_175515_(Registries.f_256952_).m_246971_(Biomes.f_48202_);
    }

    public float m_7717_(Direction p_230487_1_, boolean p_230487_2_) {
        boolean flag = this.effects.m_108885_();
        if (!p_230487_2_) {
            return flag ? 0.9f : 1.0f;
        }
        switch (p_230487_1_) {
            case DOWN: {
                return flag ? 0.9f : 0.5f;
            }
            case UP: {
                return flag ? 0.9f : 1.0f;
            }
            case NORTH: 
            case SOUTH: {
                return 0.8f;
            }
            case WEST: 
            case EAST: {
                return 0.6f;
            }
        }
        return 1.0f;
    }

    public void m_6263_(Player p_184148_1_, double p_184148_2_, double p_184148_4_, double p_184148_6_, SoundEvent p_184148_8_, SoundSource p_184148_9_, float p_184148_10_, float p_184148_11_) {
    }

    public void m_6269_(Player p_217384_1_, Entity p_217384_2_, SoundEvent p_217384_3_, SoundSource p_217384_4_, float p_217384_5_, float p_217384_6_) {
    }

    public void m_214150_(Player p_220363_, double p_220364_, double p_220365_, double p_220366_, SoundEvent p_220367_, SoundSource p_220368_, float p_220369_, float p_220370_, long p_220371_) {
    }

    public void m_213890_(Player p_220372_, Entity p_220373_, Holder<SoundEvent> p_220374_, SoundSource p_220375_, float p_220376_, float p_220377_, long p_220378_) {
    }

    public ServerScoreboard m_6188_() {
        return this.scoreboard;
    }

    public RecipeManager m_7465_() {
        if (this.f_46443_) {
            return Minecraft.m_91087_().m_91403_().m_105141_();
        }
        return this.m_7654_().m_129894_();
    }

    public void m_5898_(Player p_217378_1_, int p_217378_2_, BlockPos p_217378_3_, int p_217378_4_) {
    }

    public void m_142346_(Entity p_151549_, GameEvent p_151550_, BlockPos p_151551_) {
    }

    public MapItemSavedData m_7489_(String id) {
        return null;
    }

    public void m_142325_(String id, MapItemSavedData data) {
    }

    public String toString() {
        return "FakeServerLevel";
    }
}

