/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.server.action.interact;

import java.util.HashMap;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import team.creative.littletiles.common.action.LittleInteraction;

public class LittleInteractionHandlerServer {
    protected HashMap<Player, LittleInteraction> interactions = new HashMap();

    public LittleInteractionHandlerServer() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, this::interact);
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerLogout);
    }

    public void start(Player player, int index, boolean rightclick) {
        this.interactions.put(player, new LittleInteraction(index, rightclick));
    }

    public void end(Player player, int index) {
        LittleInteraction interaction = this.interactions.get(player);
        if (interaction != null && interaction.index <= index) {
            this.interactions.remove(player);
        }
    }

    public void interact(PlayerInteractEvent event) {
        if (!event.getLevel().f_46443_ && this.interactions.containsKey(event.getEntity())) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        this.interactions.remove(event.getEntity());
    }
}

