/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.mixin.rubidium;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.VertexBuffer;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import me.jellysquid.mods.sodium.client.gl.arena.GlBufferArena;
import me.jellysquid.mods.sodium.client.gl.arena.GlBufferSegment;
import me.jellysquid.mods.sodium.client.gl.arena.PendingUpload;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexFormat;
import me.jellysquid.mods.sodium.client.gl.buffer.GlBuffer;
import me.jellysquid.mods.sodium.client.gl.buffer.GlBufferTarget;
import me.jellysquid.mods.sodium.client.gl.device.CommandList;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.render.SodiumWorldRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSectionManager;
import me.jellysquid.mods.sodium.client.render.chunk.data.SectionRenderDataStorage;
import me.jellysquid.mods.sodium.client.render.chunk.region.RenderRegion;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.material.DefaultMaterials;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;
import org.lwjgl.opengl.GL15C;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import team.creative.creativecore.common.util.type.list.Tuple;
import team.creative.creativecore.common.util.type.map.ChunkLayerMap;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.client.mod.rubidium.RubidiumInteractor;
import team.creative.littletiles.client.mod.rubidium.buffer.RubidiumChunkBufferDownloader;
import team.creative.littletiles.client.mod.rubidium.buffer.RubidiumChunkBufferUploader;
import team.creative.littletiles.client.render.cache.LayeredBufferCache;
import team.creative.littletiles.client.render.cache.buffer.BufferCache;
import team.creative.littletiles.client.render.cache.buffer.BufferCollection;
import team.creative.littletiles.client.render.cache.pipeline.LittleRenderPipelineType;
import team.creative.littletiles.client.render.mc.RenderChunkExtender;
import team.creative.littletiles.client.render.mc.VertexBufferExtender;
import team.creative.littletiles.mixin.rubidium.ChunkBuildBuffersAccessor;
import team.creative.littletiles.mixin.rubidium.ChunkBuilderAccessor;
import team.creative.littletiles.mixin.rubidium.GLRenderDeviceAccessor;
import team.creative.littletiles.mixin.rubidium.GlBufferSegmentAccessor;
import team.creative.littletiles.mixin.rubidium.RenderSectionManagerAccessor;
import team.creative.littletiles.mixin.rubidium.SectionRenderDataStorageAccessor;
import team.creative.littletiles.mixin.rubidium.SodiumWorldRendererAccessor;

@Mixin(value={RenderSection.class})
public abstract class RenderSectionMixin
implements RenderChunkExtender {
    @Shadow(remap=false)
    private int sectionIndex;
    @Shadow(remap=false)
    private int chunkX;
    @Shadow(remap=false)
    private int chunkY;
    @Shadow(remap=false)
    private int chunkZ;
    @Shadow(remap=false)
    private TextureAtlasSprite[] animatedSprites;
    @Shadow(remap=false)
    private boolean built;
    @Shadow(remap=false)
    private int flags;
    @Unique
    private BlockPos origin;
    @Unique
    private volatile int queued;
    @Unique
    public volatile ChunkLayerMap<BufferCollection> lastUploaded;

    @Override
    public int getQueued() {
        return this.queued;
    }

    @Override
    public void setQueued(int queued) {
        this.queued = queued;
    }

    @Override
    public ChunkLayerMap<BufferCollection> getLastUploaded() {
        return this.lastUploaded;
    }

    @Override
    public void setLastUploaded(ChunkLayerMap<BufferCollection> uploaded) {
        this.lastUploaded = uploaded;
    }

    @Override
    public void begin(BufferBuilder builder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public VertexBuffer getVertexBuffer(RenderType layer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void markReadyForUpdate(boolean playerChanged) {
        ((SodiumWorldRendererAccessor)SodiumWorldRenderer.instance()).getRenderSectionManager().scheduleRebuild(this.chunkX, this.chunkY, this.chunkZ, playerChanged);
    }

    @Override
    public void setQuadSorting(BufferBuilder builder, double x, double y, double z) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty(RenderType layer) {
        return this.getUploadedBuffer(this.getStorage(this.getRenderRegion(), layer)) == null;
    }

    @Override
    public BufferBuilder.SortState getTransparencyState() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHasBlock(RenderType layer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockPos standardOffset() {
        if (this.origin == null) {
            this.origin = new BlockPos(this.chunkX * 16, this.chunkY * 16, this.chunkZ * 16);
        }
        return this.origin;
    }

    @Override
    public LittleRenderPipelineType getPipeline() {
        return RubidiumInteractor.PIPELINE;
    }

    public GlBufferSegment getUploadedBuffer(SectionRenderDataStorage storage) {
        SectionRenderDataStorageAccessor s = (SectionRenderDataStorageAccessor)storage;
        if (s == null) {
            return null;
        }
        return s.getAllocations()[this.sectionIndex];
    }

    public SectionRenderDataStorage getStorage(RenderRegion region, RenderType layer) {
        return region.getStorage(DefaultMaterials.forRenderLayer((RenderType)layer).pass);
    }

    public RenderRegion getRenderRegion() {
        return ((RenderSectionManagerAccessor)((SodiumWorldRendererAccessor)SodiumWorldRenderer.instance()).getRenderSectionManager()).getRegions().createForChunk(this.chunkX, this.chunkY, this.chunkZ);
    }

    @Override
    public int sectionIndex() {
        return this.sectionIndex;
    }

    @Override
    public synchronized void prepareUpload() {
        this.backToRAM();
        RenderChunkExtender.super.prepareUpload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer downloadUploadedData(VertexBufferExtender buffer, long offset, int size) {
        boolean active = ((GLRenderDeviceAccessor)RenderDevice.INSTANCE).getIsActive();
        if (!active) {
            RenderDevice.enterManagedCode();
        }
        try {
            RenderDevice.INSTANCE.createCommandList().bindBuffer(GlBufferTarget.ARRAY_BUFFER, (GlBuffer)buffer);
            ByteBuffer result = ByteBuffer.allocateDirect(size);
            GL15C.glGetBufferSubData((int)GlBufferTarget.ARRAY_BUFFER.getTargetParameter(), (long)offset, (ByteBuffer)result);
            ByteBuffer byteBuffer = result;
            return byteBuffer;
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            if (!(e instanceof IllegalStateException)) {
                e.printStackTrace();
            }
            ByteBuffer byteBuffer = null;
            return byteBuffer;
        }
        finally {
            if (!active) {
                RenderDevice.exitManagedCode();
            }
        }
    }

    public ByteBuffer downloadSegment(GlBufferSegment segment, GlVertexFormat format) {
        GlBuffer buffer = ((GlBufferSegmentAccessor)segment).getArena().getBufferObject();
        return this.downloadUploadedData((VertexBufferExtender)buffer, segment.getOffset() * format.getStride(), segment.getLength() * format.getStride());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void backToRAM() {
        block7: {
            RenderRegion region = this.getRenderRegion();
            ChunkLayerMap<BufferCollection> caches = this.getLastUploaded();
            if (caches == null) {
                return;
            }
            Runnable run = () -> {
                RubidiumChunkBufferDownloader downloader = new RubidiumChunkBufferDownloader();
                RenderSectionManager manager = ((SodiumWorldRendererAccessor)SodiumWorldRenderer.instance()).getRenderSectionManager();
                ChunkBuilderAccessor chunkBuilder = (ChunkBuilderAccessor)manager.getBuilder();
                GlVertexFormat format = ((ChunkBuildBuffersAccessor)chunkBuilder.getLocalContext().buffers).getVertexType().getVertexFormat();
                for (Tuple tuple : caches.tuples()) {
                    GlBufferSegment segment;
                    SectionRenderDataStorage storage = region.getStorage(DefaultMaterials.forRenderLayer((RenderType)((RenderType)tuple.key)).pass);
                    if (storage == null || (segment = this.getUploadedBuffer(storage)) == null) continue;
                    ByteBuffer vertexData = this.downloadSegment(segment, format);
                    if (vertexData == null) {
                        ((BufferCollection)tuple.value).discard();
                        continue;
                    }
                    downloader.set(storage.getDataPointer(this.sectionIndex), format, segment.getOffset(), vertexData);
                    ((BufferCollection)tuple.value).download(downloader);
                    downloader.clear();
                }
                this.setLastUploaded(null);
            };
            try {
                if (Minecraft.m_91087_().m_18695_()) {
                    run.run();
                    break block7;
                }
                RenderSectionMixin renderSectionMixin = this;
                synchronized (renderSectionMixin) {
                    CompletableFuture.runAsync(run, (Executor)Minecraft.m_91087_()).join();
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public Vec3 offsetCorrection(RenderChunkExtender chunk) {
        return null;
    }

    @Override
    public boolean appendRenderData(Iterable<? extends LayeredBufferCache> blocks) {
        RenderSectionManager manager = ((SodiumWorldRendererAccessor)SodiumWorldRenderer.instance()).getRenderSectionManager();
        RenderRegion region = this.getRenderRegion();
        ChunkBuilderAccessor chunkBuilder = (ChunkBuilderAccessor)manager.getBuilder();
        GlVertexFormat format = ((ChunkBuildBuffersAccessor)chunkBuilder.getLocalContext().buffers).getVertexType().getVertexFormat();
        RubidiumChunkBufferUploader uploader = new RubidiumChunkBufferUploader();
        for (RenderType layer : RenderType.m_110506_()) {
            int size = 0;
            for (LayeredBufferCache layeredBufferCache : blocks) {
                size += layeredBufferCache.length(layer);
            }
            if (size == 0) continue;
            TerrainRenderPass pass = DefaultMaterials.forRenderLayer((RenderType)layer).pass;
            SectionRenderDataStorage sectionRenderDataStorage = region.createStorage(pass);
            GlBufferSegment segment = this.getUploadedBuffer(sectionRenderDataStorage);
            ByteBuffer vanillaBuffer = null;
            if (segment != null) {
                vanillaBuffer = this.downloadSegment(segment, format);
            }
            if (segment == null) {
                if (layer == RenderType.m_110466_()) continue;
                LittleTiles.LOGGER.error("Failed to download chunk data. chunk: {}, layer: {}", (Object)this, (Object)layer);
                continue;
            }
            int[] extraLengthFacing = new int[ModelQuadFacing.COUNT];
            for (LayeredBufferCache layeredBufferCache : blocks) {
                for (int i = 0; i < extraLengthFacing.length; ++i) {
                    int n = i;
                    extraLengthFacing[n] = extraLengthFacing[n] + layeredBufferCache.length(layer, i);
                }
            }
            uploader.set(sectionRenderDataStorage.getDataPointer(this.sectionIndex), format, segment.getOffset(), vanillaBuffer, size, extraLengthFacing, null);
            if (segment != null) {
                sectionRenderDataStorage.removeMeshes(this.sectionIndex);
            }
            for (LayeredBufferCache layeredBufferCache : blocks) {
                BufferCache cache = layeredBufferCache.get(layer);
                if (cache == null || !cache.isAvailable()) continue;
                cache.upload(uploader);
            }
            boolean active = ((GLRenderDeviceAccessor)RenderDevice.INSTANCE).getIsActive();
            if (!active) {
                RenderDevice.enterManagedCode();
            }
            PendingUpload pendingUpload = new PendingUpload(uploader.buffer());
            CommandList commandList = RenderDevice.INSTANCE.createCommandList();
            RenderRegion.DeviceResources resources = region.createResources(commandList);
            GlBufferArena arena = resources.getGeometryArena();
            boolean bufferChanged = arena.upload(commandList, Stream.of(pendingUpload));
            if (bufferChanged) {
                region.refresh(commandList);
            }
            sectionRenderDataStorage.setMeshes(this.sectionIndex, pendingUpload.getResult(), null, uploader.ranges());
            if (!active) {
                RenderDevice.exitManagedCode();
            }
            uploader.clear();
        }
        this.animatedSprites = uploader.sprites();
        this.built = true;
        this.flags |= 1;
        return true;
    }
}

