/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.mixin.rubidium;

import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildContext;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildOutput;
import me.jellysquid.mods.sodium.client.render.chunk.compile.tasks.ChunkBuilderMeshingTask;
import me.jellysquid.mods.sodium.client.render.chunk.data.BuiltSectionMeshParts;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.material.DefaultMaterials;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.material.Material;
import me.jellysquid.mods.sodium.client.util.task.CancellationToken;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import team.creative.creativecore.common.util.type.map.ChunkLayerMap;
import team.creative.littletiles.client.mod.rubidium.data.BuiltSectionMeshPartsExtender;
import team.creative.littletiles.client.render.cache.buffer.BufferCache;
import team.creative.littletiles.client.render.cache.buffer.BufferCollection;
import team.creative.littletiles.client.render.cache.buffer.ChunkBufferUploader;
import team.creative.littletiles.client.render.cache.pipeline.LittleRenderPipelineType;
import team.creative.littletiles.client.render.mc.RebuildTaskExtender;
import team.creative.littletiles.client.render.mc.RenderChunkExtender;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.mixin.rubidium.TerrainRenderPassAccessor;

@Mixin(value={ChunkBuilderMeshingTask.class})
public class ChunkBuilderMeshingTaskMixin
implements RebuildTaskExtender {
    @Shadow(remap=false)
    @Final
    private RenderSection render;
    @Unique
    public ChunkLayerMap<BufferCollection> caches;
    @Unique
    public ChunkBuildContext buildContext;

    @Inject(at={@At(value="HEAD")}, remap=false, require=1, method={"execute(Lme/jellysquid/mods/sodium/client/render/chunk/compile/ChunkBuildContext;Lme/jellysquid/mods/sodium/client/util/task/CancellationToken;)Lme/jellysquid/mods/sodium/client/render/chunk/compile/ChunkBuildOutput;"})
    public void performBuildStart(ChunkBuildContext buildContext, CancellationToken cancellationSource, CallbackInfoReturnable<ChunkBuildOutput> info) {
        LittleRenderPipelineType.startCompile((RenderChunkExtender)this.render, this);
        this.buildContext = buildContext;
    }

    @Redirect(method={"execute(Lme/jellysquid/mods/sodium/client/render/chunk/compile/ChunkBuildContext;Lme/jellysquid/mods/sodium/client/util/task/CancellationToken;)Lme/jellysquid/mods/sodium/client/render/chunk/compile/ChunkBuildOutput;"}, remap=false, require=1, at=@At(value="INVOKE", target="Lme/jellysquid/mods/sodium/client/world/WorldSlice;getBlockEntity(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/entity/BlockEntity;", remap=true))
    public BlockEntity getBlockEntity(WorldSlice slice, BlockPos pos) {
        BlockEntity entity = slice.m_7702_(pos);
        if (entity instanceof BETiles) {
            BETiles be = (BETiles)entity;
            LittleRenderPipelineType.compile((RenderChunkExtender)this.render, be, this);
        }
        return entity;
    }

    @Inject(at={@At(value="TAIL")}, remap=false, require=1, method={"execute(Lme/jellysquid/mods/sodium/client/render/chunk/compile/ChunkBuildContext;Lme/jellysquid/mods/sodium/client/util/task/CancellationToken;)Lme/jellysquid/mods/sodium/client/render/chunk/compile/ChunkBuildOutput;"})
    public void performBuildEnd(ChunkBuildContext buildContext, CancellationToken cancellationSource, CallbackInfoReturnable<ChunkBuildOutput> info) {
        LittleRenderPipelineType.endCompile((RenderChunkExtender)this.render, this);
        this.buildContext = null;
        this.caches = null;
    }

    @Redirect(method={"execute(Lme/jellysquid/mods/sodium/client/render/chunk/compile/ChunkBuildContext;Lme/jellysquid/mods/sodium/client/util/task/CancellationToken;)Lme/jellysquid/mods/sodium/client/render/chunk/compile/ChunkBuildOutput;"}, remap=false, at=@At(value="INVOKE", target="Lme/jellysquid/mods/sodium/client/render/chunk/compile/ChunkBuildBuffers;createMesh(Lme/jellysquid/mods/sodium/client/render/chunk/terrain/TerrainRenderPass;)Lme/jellysquid/mods/sodium/client/render/chunk/data/BuiltSectionMeshParts;"))
    public BuiltSectionMeshParts createMesh(ChunkBuildBuffers buffers, TerrainRenderPass pass) {
        BuiltSectionMeshParts parts = buffers.createMesh(pass);
        if (parts != null && this.caches != null) {
            ((BuiltSectionMeshPartsExtender)parts).setBuffers((BufferCollection)this.caches.get(((TerrainRenderPassAccessor)pass).getLayer()));
        }
        return parts;
    }

    @Unique
    public BufferCollection getOrCreateBuffers(RenderType layer) {
        BufferCollection cache;
        if (this.caches == null) {
            this.caches = new ChunkLayerMap();
        }
        if ((cache = (BufferCollection)this.caches.get(layer)) == null) {
            cache = new BufferCollection();
            this.caches.put(layer, (Object)cache);
        }
        return cache;
    }

    @Override
    public BufferCache upload(RenderType layer, BufferCache cache) {
        Material mat = DefaultMaterials.forRenderLayer((RenderType)layer);
        if (cache.upload((ChunkBufferUploader)this.buildContext.buffers.get(mat))) {
            this.getOrCreateBuffers(layer).queueForUpload(cache);
            return cache;
        }
        return null;
    }
}

