/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.mixin.common.entity;

import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import team.creative.creativecore.common.level.IOrientatedLevel;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;
import team.creative.littletiles.common.structure.type.bed.ILittleBedPlayerExtension;
import team.creative.littletiles.common.structure.type.bed.LittleBed;

@Mixin(value={Player.class})
public abstract class PlayerBedMixin
extends LivingEntity
implements ILittleBedPlayerExtension {
    @Unique
    public LittleBed bed;
    @Shadow
    private int f_36110_;

    protected PlayerBedMixin(EntityType<? extends LivingEntity> type, Level level) {
        super(type, level);
    }

    @Override
    public LittleBed getBed() {
        return this.bed;
    }

    @Override
    public void setBed(LittleBed bed) {
        this.bed = bed;
    }

    public Direction m_21259_() {
        LittleBed bed = this.getBed();
        if (bed != null) {
            return bed.getBedDirection();
        }
        return super.m_21259_();
    }

    @Override
    @Unique
    public void setSleepingCounter(int counter) {
        this.f_36110_ = counter;
    }

    @Inject(at={@At(value="HEAD")}, method={"tick()V"})
    public void tick(CallbackInfo info) {
        if (this.bed != null && this.bed.getStructureLevel() instanceof IOrientatedLevel) {
            this.setPositionToBed();
        }
    }

    @Override
    public boolean setPositionToBed() {
        if (this.bed != null) {
            try {
                Vec3d vec = this.bed.getHighestCenterVec();
                Vec3d offset = new Vec3d();
                offset.set(this.bed.direction.axis, (double)this.bed.direction.offset() * 0.5);
                vec.add(offset);
                Level level = this.bed.getStructureLevel();
                if (level instanceof IOrientatedLevel) {
                    IOrientatedLevel l = (IOrientatedLevel)level;
                    l.getOrigin().transformPointToWorld(vec);
                }
                this.m_6034_(vec.x, vec.y, vec.z);
                return true;
            }
            catch (CorruptedConnectionException | NotYetConnectedException e) {
                LittleTiles.LOGGER.error("Could not sleep in bed", (Throwable)e);
            }
        }
        return false;
    }
}

