/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.mixin.common.entity;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import team.creative.creativecore.common.util.mc.PlayerUtils;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.level.handler.LittleAnimationHandler;
import team.creative.littletiles.common.math.vec.LittleHitResult;

@Mixin(value={Entity.class})
public class EntityMixin {
    @Unique
    private Entity asEntity() {
        return (Entity)this;
    }

    @Inject(method={"pick"}, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true, require=1)
    public void pick(double reach, float partialTicks, boolean fluid, CallbackInfoReturnable<HitResult> info, Vec3 pos, Vec3 view, Vec3 look) {
        double d;
        Entity entity = this.asEntity();
        HitResult result = (HitResult)info.getReturnValue();
        if (result != null) {
            d = pos.m_82554_(result.m_82450_());
        } else if (entity instanceof Player) {
            Player p = (Player)entity;
            d = PlayerUtils.getReach((Player)p);
        } else {
            d = 4.0;
        }
        double reachDistance = d;
        LittleHitResult hit = ((LittleAnimationHandler)LittleTiles.ANIMATION_HANDLERS.get(entity.m_9236_())).getHit(pos, look, reachDistance);
        if (hit != null) {
            info.setReturnValue((Object)hit);
        }
    }
}

