/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.mixin.common.collision;

import java.util.Iterator;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockCollisions;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.level.handler.LittleAnimationHandler;

@Mixin(value={BlockCollisions.class})
public class BlockCollisionsMixin<T> {
    @Shadow
    @Final
    private AABB f_186392_;
    @Shadow
    @Final
    private CollisionContext f_186393_;
    @Shadow
    @Final
    private CollisionGetter f_186397_;
    @Shadow
    @Final
    private BlockPos.MutableBlockPos f_186395_;
    @Unique
    private Iterator<VoxelShape> extraShapes;
    @Shadow
    @Final
    private BiFunction<BlockPos.MutableBlockPos, VoxelShape, T> f_285595_;

    @Inject(method={"computeNext"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/Cursor3D;advance()Z")}, cancellable=true, require=1)
    private void computeStart(CallbackInfoReturnable<T> info) {
        if (this.extraShapes != null) {
            if (this.extraShapes.hasNext()) {
                info.setReturnValue(this.f_285595_.apply(this.f_186395_, this.extraShapes.next()));
            } else {
                this.extraShapes = null;
            }
        }
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/CollisionGetter;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/AABB;ZLjava/util/function/BiFunction;)V"}, at={@At(value="RETURN")}, require=1)
    private void constructorEnd(CollisionGetter level, @Nullable Entity entity, AABB bb, boolean onlySuffocatingBlocks, BiFunction<BlockPos.MutableBlockPos, VoxelShape, ?> resultProvider, CallbackInfo info) {
        if (!(this.f_186397_ instanceof Level) || onlySuffocatingBlocks) {
            return;
        }
        Iterable<VoxelShape> shapes = ((LittleAnimationHandler)LittleTiles.ANIMATION_HANDLERS.get((Level)this.f_186397_)).collisionExcept(entity, this.f_186392_, (Level)this.f_186397_);
        if (shapes != null) {
            this.extraShapes = shapes.iterator();
        }
    }
}

